/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.translate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.SqlToyThreadDataHolder;
import org.sagacity.sqltoy.config.model.FieldTranslate;
import org.sagacity.sqltoy.config.model.SqlExecuteTrace;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.inner.TranslateExtend;
import org.sagacity.sqltoy.translate.CacheUpdateWatcher;
import org.sagacity.sqltoy.translate.FieldTranslateCacheHolder;
import org.sagacity.sqltoy.translate.TranslateConfigParse;
import org.sagacity.sqltoy.translate.TranslateFactory;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;
import org.sagacity.sqltoy.translate.cache.impl.TranslateEhcacheManager;
import org.sagacity.sqltoy.translate.model.CheckerConfigModel;
import org.sagacity.sqltoy.translate.model.DefaultConfig;
import org.sagacity.sqltoy.translate.model.TranslateConfigModel;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateManager {
    protected static final Logger logger = LoggerFactory.getLogger(TranslateManager.class);
    private TranslateCacheManager translateCacheManager;
    private String charset = "UTF-8";
    private IgnoreKeyCaseMap<String, TranslateConfigModel> translateMap = new IgnoreKeyCaseMap();
    private CopyOnWriteArrayList<CheckerConfigModel> updateCheckers = new CopyOnWriteArrayList();
    private boolean initialized = false;
    private String translateConfig = null;
    public static final String defaultTranslateConfig = "classpath:sqltoy-translate.xml;classpath:translates";
    private CacheUpdateWatcher cacheUpdateWatcher;
    private SqlToyContext sqlToyContext;

    public void setTranslateConfig(String translateConfig) {
        this.translateConfig = translateConfig;
    }

    public synchronized void initialize(SqlToyContext sqlToyContext, TranslateCacheManager cacheManager, int delayCheckCacheSeconds) throws Exception {
        if (this.initialized) {
            return;
        }
        try {
            String realTranslateConfig;
            this.sqlToyContext = sqlToyContext;
            this.initialized = true;
            String string = realTranslateConfig = this.translateConfig == null ? defaultTranslateConfig : this.translateConfig;
            if (logger.isDebugEnabled()) {
                logger.debug("\u5f00\u59cb\u52a0\u8f7dsqltoy\u7684translate\u7f13\u5b58\u7ffb\u8bd1\u914d\u7f6e\u6587\u4ef6:{}", (Object)realTranslateConfig);
            } else {
                System.out.println("\u5f00\u59cb\u52a0\u8f7dsqltoy\u7684translate\u7f13\u5b58\u7ffb\u8bd1\u914d\u7f6e\u6587\u4ef6:" + realTranslateConfig);
            }
            DefaultConfig defaultConfig = TranslateConfigParse.parseTranslateConfig(sqlToyContext, this.translateMap, this.updateCheckers, realTranslateConfig, this.translateConfig == null, this.charset);
            if (defaultConfig.isUseCache()) {
                this.translateCacheManager = cacheManager == null ? new TranslateEhcacheManager() : cacheManager;
                if (!StringUtil.isBlank(defaultConfig.getDiskStorePath()) && this.translateCacheManager instanceof TranslateEhcacheManager) {
                    ((TranslateEhcacheManager)this.translateCacheManager).setDiskStorePath(defaultConfig.getDiskStorePath());
                }
                this.translateCacheManager.setTranslateMap(this.translateMap);
                boolean initSuccess = this.translateCacheManager.init();
                if (initSuccess) {
                    this.cacheUpdateWatcher = new CacheUpdateWatcher(sqlToyContext, this.translateCacheManager, this.translateMap, this.updateCheckers, delayCheckCacheSeconds, defaultConfig.getDeviationSeconds());
                    this.cacheUpdateWatcher.start();
                    logger.debug("sqltoy\u7684translate\u5171:{} \u4e2a\u7f13\u5b58\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210,\u5e76\u4e14\u542f\u52a8:{} \u4e2a\u7f13\u5b58\u66f4\u65b0\u68c0\u6d4b!", (Object)this.translateMap.size(), (Object)this.updateCheckers.size());
                } else {
                    logger.debug("sqltoy\u7684translate\u5171:{} \u4e2a\u7f13\u5b58\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210,\u60a8\u6ca1\u6709\u914d\u7f6e\u7f13\u5b58\u66f4\u65b0\u68c0\u6d4b\u673a\u5236\u6216\u6ca1\u6709\u914d\u7f6e\u7f13\u5b58,\u5c06\u4e0d\u505a\u7f13\u5b58\u66f4\u65b0\u68c0\u6d4b!", (Object)this.translateMap.size());
                }
            } else {
                logger.warn("translateConfig={} \u672a\u627e\u5230\u5b9e\u9645\u5b9a\u4e49\u6587\u4ef6,\u8bf7\u6b63\u786e\u5b9a\u4e49[\u4ee5.trans.xml|-translate.xml|-translates.xml\u7ed3\u5c3e],\u5982\u4e0d\u4f7f\u7528\u7f13\u5b58\u7ffb\u8bd1\u53ef\u5ffd\u89c6\u6b64\u63d0\u793a!", (Object)realTranslateConfig);
            }
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7dsqltoy\u7684translate\u7f13\u5b58\u7ffb\u8bd1\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38!{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    public HashMap<String, FieldTranslateCacheHolder> getTranslates(HashMap<String, FieldTranslate> translates) {
        SqlExecuteTrace sqlTrace = SqlExecuteStat.get();
        HashMap<String, FieldTranslateCacheHolder> result = new HashMap<String, FieldTranslateCacheHolder>();
        HashMap<String, FieldTranslate> realTranslates = this.wrapI18nIndex(translates);
        for (Map.Entry<String, FieldTranslate> entry : realTranslates.entrySet()) {
            FieldTranslate fieldTranslate = entry.getValue();
            String colName = entry.getKey();
            FieldTranslateCacheHolder fieldTranslateHandler = new FieldTranslateCacheHolder();
            int translateSize = fieldTranslate.translates.length;
            fieldTranslateHandler.setTranslates(fieldTranslate.translates);
            fieldTranslateHandler.setKeyField(fieldTranslate.keyField);
            HashMap[] cacheAry = new HashMap[translateSize];
            for (int i = 0; i < translateSize; ++i) {
                Translate translate = fieldTranslate.translates[i];
                TranslateExtend extend = translate.getExtend();
                if (this.translateMap.containsKey(extend.cache)) {
                    TranslateConfigModel cacheModel = this.translateMap.get(extend.cache);
                    extend.dynamicCache = cacheModel.isDynamicCache();
                    extend.cacheSid = cacheModel.getSid();
                    extend.cacheProperties = cacheModel.getProperties();
                    HashMap<String, Object[]> cache = this.getCacheData(cacheModel, extend.cacheType);
                    if (cache != null) {
                        int cacheEltLength;
                        if (cache.size() > 0 && extend.index >= (cacheEltLength = cache.values().iterator().next().length)) {
                            throw new IllegalArgumentException("\u7f13\u5b58\u53d6\u503c\u6570\u7ec4\u8d8a\u754c:cacheName:" + extend.cache + ", column:" + extend.column + ",cache-indexs:(" + extend.index + ">=" + cacheEltLength + ")[\u7f13\u5b58\u5185\u5bb9\u6570\u7ec4\u957f\u5ea6],\u8bf7\u68c0\u67e5cache-indexs\u503c\u786e\u4fdd\u8ddf\u7f13\u5b58\u6570\u636e\u5177\u4f53\u5217\u4fdd\u6301\u4e00\u81f4!");
                        }
                        cacheAry[i] = cache;
                        continue;
                    }
                    cacheAry[i] = new HashMap();
                    logger.warn("sqltoy translate:cacheName={},cache-type={},column={}\u914d\u7f6e\u4e0d\u6b63\u786e,\u672a\u83b7\u53d6\u5bf9\u5e94cache\u6570\u636e!", new Object[]{cacheModel.getCache(), extend.cacheType, extend.column});
                    continue;
                }
                cacheAry[i] = new HashMap();
                logger.error("cacheName:{} \u6ca1\u6709\u914d\u7f6e,\u8bf7\u68c0\u67e5\u7f13\u5b58\u914d\u7f6e\u6587\u4ef6!", (Object)extend.cache);
            }
            fieldTranslateHandler.setCacheArray(cacheAry);
            result.put(colName, fieldTranslateHandler);
        }
        if (sqlTrace != null) {
            SqlExecuteStat.set(sqlTrace);
        }
        return result;
    }

    private HashMap<String, FieldTranslate> wrapI18nIndex(HashMap<String, FieldTranslate> translateConfig) {
        String locale = SqlToyThreadDataHolder.getLanguage();
        if (locale == null) {
            return translateConfig;
        }
        HashMap<String, FieldTranslate> result = new HashMap<String, FieldTranslate>();
        for (Map.Entry<String, FieldTranslate> entry : translateConfig.entrySet()) {
            String colName = entry.getKey();
            FieldTranslate fieldTranslate = entry.getValue();
            if (this.hasI18n(fieldTranslate)) {
                FieldTranslate newFieldTranslate = new FieldTranslate();
                Translate[] translatesAry = new Translate[fieldTranslate.translates.length];
                int i = 0;
                Translate[] translateArray = fieldTranslate.translates;
                int n = translateArray.length;
                for (int j = 0; j < n; ++j) {
                    Integer realIndex;
                    Translate translate;
                    translatesAry[i] = translate = translateArray[j];
                    TranslateExtend transExt = translate.getExtend();
                    TranslateConfigModel translateConfigModel = this.getCacheConfig(transExt.cache);
                    if (translateConfigModel.hasI18n(transExt.index) && (realIndex = translateConfigModel.getI18nIndex(locale)) != null && realIndex != transExt.index) {
                        Translate cloneTrans = translate.clone();
                        cloneTrans.setIndex(realIndex);
                        translatesAry[i] = cloneTrans;
                    }
                    ++i;
                }
                newFieldTranslate.colName = colName;
                newFieldTranslate.keyField = fieldTranslate.keyField;
                newFieldTranslate.translates = translatesAry;
                result.put(colName, newFieldTranslate);
                continue;
            }
            result.put(colName, fieldTranslate);
        }
        return result;
    }

    private boolean hasI18n(FieldTranslate fieldTranslate) {
        for (Translate translate : fieldTranslate.translates) {
            TranslateExtend transExt = translate.getExtend();
            if (!this.getCacheConfig(transExt.cache).hasI18n(transExt.index)) continue;
            return true;
        }
        return false;
    }

    private HashMap<String, Object[]> getCacheData(TranslateConfigModel cacheModel, String cacheType) {
        HashMap<String, Object[]> result = this.translateCacheManager.getCache(cacheModel.getCache(), cacheType);
        if ((result == null || result.isEmpty()) && (result = TranslateFactory.getCacheData(this.sqlToyContext, cacheModel, cacheType)) != null && !result.isEmpty()) {
            this.translateCacheManager.put(cacheModel, cacheModel.getCache(), cacheType, result);
        }
        return result;
    }

    public HashMap<String, Object[]> getCacheData(String cacheName, String cacheType) {
        TranslateConfigModel cacheModel = this.translateMap.get(cacheName);
        if (cacheModel == null) {
            logger.error("cacheName:{} \u6ca1\u6709\u914d\u7f6e,\u8bf7\u68c0\u67e5\u7f13\u5b58\u914d\u7f6e\u6587\u4ef6!", (Object)cacheName);
            return null;
        }
        SqlExecuteTrace sqlTrace = SqlExecuteStat.get();
        HashMap<String, Object[]> result = this.getCacheData(cacheModel, cacheType);
        if (sqlTrace != null) {
            SqlExecuteStat.set(sqlTrace);
        }
        return result;
    }

    public void putCacheData(String cacheName, String cacheType, HashMap<String, Object[]> cacheValue) {
        if (this.translateCacheManager != null) {
            TranslateConfigModel cacheModel = this.translateMap.get(cacheName);
            if (cacheModel == null) {
                logger.error("cacheName:{} \u6ca1\u6709\u914d\u7f6e,\u8bf7\u68c0\u67e5\u7f13\u5b58\u914d\u7f6e\u6587\u4ef6!", (Object)cacheName);
                return;
            }
            this.translateCacheManager.put(cacheModel, cacheModel.getCache(), cacheType, cacheValue);
        } else {
            logger.error("\u56e0\u6ca1\u6709\u5b9a\u4e49\u7f13\u5b58\u7ffb\u8bd1\u7684\u914d\u7f6e\u6587\u4ef6(\u53ef\u4e0d\u5b9a\u4e49\u5177\u4f53\u7f13\u5b58)\uff0c\u5219\u6ca1\u6709\u542f\u7528\u7f13\u5b58\u7ffb\u8bd1,\u65e0\u6cd5\u8bbe\u7f6e\u7f13\u5b58\u6570\u636e!");
        }
    }

    public void clear(String cacheName, String cacheType) {
        TranslateConfigModel cacheModel;
        if (this.translateCacheManager != null && (cacheModel = this.translateMap.get(cacheName)) != null) {
            this.translateCacheManager.clear(cacheModel.getCache(), cacheType);
        }
    }

    public boolean existCache(String cacheName) {
        return this.translateMap.containsKey(cacheName);
    }

    public TranslateConfigModel getCacheConfig(String cacheName) {
        return this.translateMap.get(cacheName);
    }

    public void putCache(TranslateConfigModel translateConfigModel) {
        if (translateConfigModel == null) {
            return;
        }
        if (this.translateCacheManager == null) {
            logger.error("\u56e0\u6ca1\u6709\u5b9a\u4e49\u7f13\u5b58\u7ffb\u8bd1\u7684\u914d\u7f6e\u6587\u4ef6(\u53ef\u4e0d\u5b9a\u4e49\u5177\u4f53\u7f13\u5b58)\uff0c\u5219\u6ca1\u6709\u542f\u7528\u7f13\u5b58\u7ffb\u8bd1,\u65e0\u6cd5\u52a8\u6001\u589e\u52a0\u7f13\u5b58!");
        } else {
            this.translateMap.put(translateConfigModel.getCache(), translateConfigModel);
        }
    }

    public void removeCache(String cacheName) {
        TranslateConfigModel cacheModel = this.translateMap.get(cacheName);
        if (cacheModel == null) {
            logger.error("cacheName:{} \u6ca1\u6709\u914d\u7f6e,\u8bf7\u68c0\u67e5\u7f13\u5b58\u914d\u7f6e\u6587\u4ef6!", (Object)cacheName);
            return;
        }
        this.translateMap.remove(cacheName);
        if (this.translateCacheManager != null) {
            this.translateCacheManager.clear(cacheModel.getCache(), null);
        }
        for (int i = 0; i < this.updateCheckers.size(); ++i) {
            CheckerConfigModel checker = this.updateCheckers.get(i);
            if (!checker.getCache().equalsIgnoreCase(cacheName)) continue;
            this.updateCheckers.remove(i);
            break;
        }
    }

    public void removeCacheUpdater(CheckerConfigModel checkerConfigModel) {
        if (checkerConfigModel == null) {
            return;
        }
        if (StringUtil.isNotBlank(checkerConfigModel.getCache()) && !this.translateMap.containsKey(checkerConfigModel.getCache())) {
            logger.error("cacheName:{} \u4e0d\u5b58\u5728\u65e0\u9700\u505a\u79fb\u9664,\u8bf7\u68c0\u67e5\u7f13\u5b58\u914d\u7f6e\u6587\u4ef6!", (Object)checkerConfigModel.getCache());
            return;
        }
        for (int i = 0; i < this.updateCheckers.size(); ++i) {
            CheckerConfigModel checker = this.updateCheckers.get(i);
            if (!checker.getId().equalsIgnoreCase(checkerConfigModel.getId())) continue;
            this.updateCheckers.remove(i);
            break;
        }
    }

    public void putCacheUpdater(CheckerConfigModel checkerConfigModel) {
        if (checkerConfigModel == null) {
            return;
        }
        if (StringUtil.isNotBlank(checkerConfigModel.getCache())) {
            if (!this.translateMap.containsKey(checkerConfigModel.getCache())) {
                logger.error("cacheName:{} \u6ca1\u6709\u914d\u7f6e,\u8bf7\u68c0\u67e5\u7f13\u5b58\u914d\u7f6e\u6587\u4ef6!", (Object)checkerConfigModel.getCache());
                return;
            }
        } else if (checkerConfigModel.isIncrement()) {
            logger.error("\u7f13\u5b58\u589e\u91cf\u66f4\u65b0\u68c0\u6d4b\u5fc5\u987b\u8981\u6307\u5b9a\u5177\u4f53\u7684\u7f13\u5b58\u540d\u79f0:checkerConfigModel.setCache(cacheName)!");
            return;
        }
        if (StringUtil.isBlank(checkerConfigModel.getSql()) && (StringUtil.isBlank(checkerConfigModel.getService()) || StringUtil.isBlank(checkerConfigModel.getMethod())) && StringUtil.isBlank(checkerConfigModel.getUrl())) {
            logger.error("\u7f13\u5b58\u66f4\u65b0\u68c0\u6d4b\u5fc5\u987b\u8bbe\u5b9a:sql\u3001[service|method]\u3001url(rest) \u4e09\u79cd\u7c7b\u578b\u4e2d\u7684\u4e00\u79cd!");
            return;
        }
        for (int i = 0; i < this.updateCheckers.size(); ++i) {
            CheckerConfigModel checker = this.updateCheckers.get(i);
            if (!checker.getId().equalsIgnoreCase(checkerConfigModel.getId())) continue;
            this.updateCheckers.remove(i);
            break;
        }
        this.updateCheckers.add(checkerConfigModel);
    }

    public Set<String> getCacheNames() {
        HashSet<String> cacheNames = new HashSet<String>();
        if (!this.translateMap.isEmpty()) {
            Iterator iter = this.translateMap.values().iterator();
            while (iter.hasNext()) {
                cacheNames.add(((TranslateConfigModel)iter.next()).getCache());
            }
        }
        return cacheNames;
    }

    public Collection<TranslateConfigModel> getAllTranslates() {
        return this.translateMap.values();
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public TranslateCacheManager getTranslateCacheManager() {
        return this.translateCacheManager;
    }

    public void destroy() {
        try {
            if (this.translateCacheManager != null) {
                this.translateCacheManager.destroy();
            }
            if (this.cacheUpdateWatcher != null && !this.cacheUpdateWatcher.isInterrupted()) {
                this.cacheUpdateWatcher.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

