/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.callback.TreeIdAndPidGet;
import org.sagacity.sqltoy.config.model.SummaryColMeta;
import org.sagacity.sqltoy.config.model.SummaryGroupMeta;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(CollectionUtil.class);
    public static final String ILLEGAL_NUM_REGEX = "%|\u2030|\\$|\u00a5";

    private CollectionUtil() {
    }

    public static Object[] convertArray(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).toArray();
        }
        if (obj instanceof int[]) {
            int[] tmp = (int[])obj;
            Object[] result = new Integer[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = tmp[i];
            }
            return result;
        }
        if (obj instanceof short[]) {
            short[] tmp = (short[])obj;
            Object[] result = new Short[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = tmp[i];
            }
            return result;
        }
        if (obj instanceof long[]) {
            long[] tmp = (long[])obj;
            Object[] result = new Long[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = tmp[i];
            }
            return result;
        }
        if (obj instanceof float[]) {
            float[] tmp = (float[])obj;
            Object[] result = new Float[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = Float.valueOf(tmp[i]);
            }
            return result;
        }
        if (obj instanceof double[]) {
            double[] tmp = (double[])obj;
            Object[] result = new Double[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = tmp[i];
            }
            return result;
        }
        if (obj instanceof boolean[]) {
            boolean[] tmp = (boolean[])obj;
            Object[] result = new Boolean[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = tmp[i];
            }
            return result;
        }
        if (obj instanceof char[]) {
            char[] tmp = (char[])obj;
            Object[] result = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = String.valueOf(tmp[i]);
            }
            return result;
        }
        if (obj instanceof byte[]) {
            byte[] tmp = (byte[])obj;
            Object[] result = new Byte[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = tmp[i];
            }
            return result;
        }
        return new Object[]{obj};
    }

    public static List arrayToDeepList(Object arySource) {
        if (null == arySource) {
            logger.error("arrayToDeepList:the array is Null");
            return null;
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (arySource instanceof Object[][]) {
            Object[][] aryObject = (Object[][])arySource;
            if (null != aryObject && 0 < aryObject.length) {
                int n = aryObject.length;
                for (int i = 0; i < n; ++i) {
                    ArrayList<Object> tmpList = new ArrayList<Object>();
                    int rowLength = aryObject[i].length;
                    for (int j = 0; j < rowLength; ++j) {
                        tmpList.add(aryObject[i][j]);
                    }
                    resultList.add(tmpList);
                }
            }
        } else if (arySource.getClass().isArray()) {
            Object[] aryObject = CollectionUtil.convertArray(arySource);
            if (null != aryObject && 0 < aryObject.length) {
                int n = aryObject.length;
                for (int i = 0; i < n; ++i) {
                    resultList.add(aryObject[i]);
                }
            }
        } else {
            logger.error("error define the Array! please sure the array is one or two dimension!");
        }
        return resultList;
    }

    public static List arrayToList(Object arySource) {
        if (null == arySource) {
            logger.error("arrayToList:the Ary Source is Null");
            return null;
        }
        if (arySource instanceof List) {
            return (List)arySource;
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (arySource.getClass().isArray()) {
            Object[] aryObject = CollectionUtil.convertArray(arySource);
            if (null != aryObject && 0 < aryObject.length) {
                int n = aryObject.length;
                for (int i = 0; i < n; ++i) {
                    resultList.add(aryObject[i]);
                }
            }
        } else {
            logger.warn("arySource is not Array! it type is :" + arySource.getClass());
            resultList.add(arySource);
        }
        return resultList;
    }

    public static void sortArray(Object[] aryData, boolean descend) {
        if (aryData != null && aryData.length > 1) {
            int length = aryData.length;
            int dataType = 1;
            if (aryData[0] instanceof Number) {
                dataType = 2;
            } else if (aryData[0] instanceof Date) {
                dataType = 3;
            } else if (aryData[0] instanceof LocalDate) {
                dataType = 4;
            } else if (aryData[0] instanceof LocalDateTime) {
                dataType = 5;
            } else if (aryData[0] instanceof LocalTime) {
                dataType = 6;
            }
            boolean lessThen = false;
            for (int i = 0; i < length - 1; ++i) {
                for (int j = i + 1; j < length; ++j) {
                    Object iData = aryData[i];
                    Object jData = aryData[j];
                    if (dataType == 1) {
                        String str1 = iData.toString();
                        String str2 = jData.toString();
                        lessThen = str1.length() < str2.length() ? true : (str1.length() > str2.length() ? false : str1.compareTo(str2) < 0);
                    } else if (dataType == 2) {
                        lessThen = ((Number)iData).doubleValue() < ((Number)jData).doubleValue();
                    } else if (dataType == 3) {
                        lessThen = ((Date)iData).before((Date)jData);
                    } else if (dataType == 4) {
                        lessThen = ((LocalDate)iData).compareTo((LocalDate)jData) < 0;
                    } else if (dataType == 5) {
                        lessThen = ((LocalDateTime)iData).compareTo((LocalDateTime)jData) < 0;
                    } else if (dataType == 6) {
                        boolean bl = lessThen = ((LocalTime)iData).compareTo((LocalTime)jData) < 0;
                    }
                    if ((!descend || !lessThen) && (descend || lessThen)) continue;
                    aryData[i] = jData;
                    aryData[j] = iData;
                }
            }
        }
    }

    public static <T> List<T> sortTreeList(List<T> treeList, TreeIdAndPidGet<T> treeIdAndPidGet, Object ... pids) {
        if (treeList == null || treeList.isEmpty() || pids == null || pids.length == 0) {
            return treeList;
        }
        int totalRecord = treeList.size();
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < treeList.size(); ++i) {
            T row = treeList.get(i);
            Object pid = treeIdAndPidGet.getIdAndPid(row)[1];
            if (!CollectionUtil.any(pid, pids)) continue;
            result.add(row);
            treeList.remove(i);
            --i;
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("\u6392\u5e8f\u6811\u5f62\u6570\u636e\u96c6\u5408\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u7236ids:" + StringUtil.linkAry(",", false, pids));
        }
        int beginIndex = 0;
        int addCount = 0;
        while (treeList.size() != 0) {
            addCount = 0;
            Object idValue = treeIdAndPidGet.getIdAndPid(result.get(beginIndex))[0];
            for (int i = 0; i < treeList.size(); ++i) {
                Object pidValue = treeIdAndPidGet.getIdAndPid(treeList.get(i))[1];
                if (!idValue.equals(pidValue)) continue;
                result.add(beginIndex + addCount + 1, treeList.get(i));
                treeList.remove(i);
                ++addCount;
                --i;
            }
            if (++beginIndex + 1 <= result.size()) continue;
        }
        if (result.size() != totalRecord) {
            logger.error("sortTreeList\u64cd\u4f5c\u53d1\u73b0\u90e8\u5206\u6570\u636e\u4e0d\u7b26\u5408\u6811\u5f62\u7ed3\u6784\u89c4\u5219,\u8bf7\u68c0\u67e5!");
        }
        return result;
    }

    public static Object[] subtractArray(Object[] sourceAry, int begin, int length) {
        if (sourceAry == null || sourceAry.length == 0) {
            return null;
        }
        if (begin + length > sourceAry.length || length == 0) {
            return sourceAry;
        }
        Object[] distinctAry = new Object[sourceAry.length - length];
        if (begin == 0) {
            System.arraycopy(sourceAry, length, distinctAry, 0, sourceAry.length - length);
        } else {
            System.arraycopy(sourceAry, 0, distinctAry, 0, begin);
            System.arraycopy(sourceAry, begin + length, distinctAry, begin, sourceAry.length - length - begin);
        }
        return distinctAry;
    }

    public static Object[][] twoDimenlistToArray(Collection source) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        Object[][] result = new Object[source.size()][];
        int index = 0;
        for (Object obj : source) {
            if (obj instanceof Collection) {
                result[index] = ((Collection)obj).toArray();
            } else if (obj.getClass().isArray()) {
                result[index] = CollectionUtil.convertArray(obj);
            } else if (obj instanceof Map) {
                result[index] = ((Map)obj).values().toArray();
            }
            ++index;
        }
        return result;
    }

    public static int judgeObjectDimen(Object obj) {
        int result = 0;
        if (obj == null) {
            return -1;
        }
        if (obj instanceof Collection || obj.getClass().isArray() || obj instanceof Map) {
            result = 1;
            if (obj instanceof Collection) {
                Collection tmp = (Collection)obj;
                if (tmp.isEmpty()) {
                    return result;
                }
                Object firstCellValue = ((List)obj).get(0);
                if (firstCellValue != null && (firstCellValue instanceof Collection || firstCellValue.getClass().isArray() || firstCellValue instanceof Map)) {
                    result = 2;
                }
            } else if (obj.getClass().isArray()) {
                Object[] tmp = CollectionUtil.convertArray(obj);
                if (tmp.length == 0) {
                    return result;
                }
                Object firstCellValue = tmp[0];
                if (firstCellValue != null && (firstCellValue instanceof Collection || firstCellValue.getClass().isArray() || firstCellValue instanceof Map)) {
                    result = 2;
                }
            } else if (obj instanceof Map) {
                Map tmp = (Map)obj;
                if (tmp.isEmpty()) {
                    return result;
                }
                Object firstCellValue = tmp.values().iterator().next();
                if (firstCellValue != null && (firstCellValue instanceof Collection || firstCellValue.getClass().isArray() || firstCellValue instanceof Map)) {
                    result = 2;
                }
            }
        }
        return result;
    }

    public static List pivotList(List data, List categorys, int categCol, int pkColumn, int categCompareCol, int startCol, int endCol, Object defaultValue) {
        return CollectionUtil.pivotList(data, categorys, new Integer[]{categCol}, new Integer[]{pkColumn}, new Integer[]{categCompareCol}, startCol, endCol, defaultValue);
    }

    public static List pivotList(List data, List categorys, Integer[] categoryCol, Integer[] pkColumns, Integer[] categCompareCol, int startCol, int endCol, Object defaultValue) {
        boolean isTwoDimensionCategory;
        Integer[] categCol;
        if (data == null || data.isEmpty()) {
            return data;
        }
        if (categoryCol == null) {
            categCol = new Integer[categCompareCol.length];
            for (int i = 0; i < categCompareCol.length; ++i) {
                categCol[i] = i;
            }
        } else {
            categCol = categoryCol;
        }
        boolean bl = isTwoDimensionCategory = categorys.get(0) instanceof Collection || categorys.get(0).getClass().isArray();
        if (isTwoDimensionCategory && (categCompareCol.length > categorys.size() || categCompareCol.length != categCol.length)) {
            throw new IllegalArgumentException("\u591a\u7ef4\u65cb\u8f6c\u53c2\u7167\u6570\u636e\u884c\u6570\u8ddf\u53c2\u7167\u5217\u7684\u6570\u91cf\u8981\u4e00\u81f4,categCol.length == categCompareCol.length!");
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int dataWidth = ((List)data.get(0)).size();
        int cateItemSize = isTwoDimensionCategory ? ((Collection)categorys.get(0)).size() : categorys.size();
        int rotateWith = endCol - startCol + 1;
        int lastRowWidth = dataWidth - categCompareCol.length + (cateItemSize - 1) * rotateWith;
        int rotateTotalCount = cateItemSize * rotateWith;
        int count = 0;
        boolean isRotaCol = false;
        Object[] rowData = null;
        int indexLength = pkColumns.length;
        boolean categoryColEqual = false;
        int categColSize = categCompareCol.length;
        boolean pkColumnsEqual = false;
        List compareRow = null;
        int rowSize = data.size();
        for (int i = 0; i < rowSize; ++i) {
            int j;
            Object compareValue;
            Object pkColValue;
            int k;
            List rowList = (List)data.get(i);
            pkColumnsEqual = true;
            if (i == 0) {
                pkColumnsEqual = false;
            } else {
                for (k = 0; k < indexLength; ++k) {
                    pkColValue = rowList.get(pkColumns[k]);
                    if (pkColValue == null) {
                        pkColValue = "null";
                    }
                    if ((compareValue = compareRow.get(pkColumns[k])) == null) {
                        compareValue = "null";
                    }
                    boolean bl2 = pkColumnsEqual = pkColumnsEqual && BeanUtil.equalsIgnoreType(pkColValue, compareValue, false);
                    if (!pkColumnsEqual) break;
                }
            }
            if (!pkColumnsEqual) {
                compareRow = rowList;
                if (i != 0) {
                    result.add(rowData);
                }
                rowData = new Object[lastRowWidth];
                if (defaultValue != null) {
                    for (j = 0; j < rotateTotalCount; ++j) {
                        rowData[dataWidth - rotateWith - categCompareCol.length + j] = defaultValue;
                    }
                }
                count = 0;
                for (k = 0; k < dataWidth; ++k) {
                    isRotaCol = false;
                    for (int m = 0; m < categColSize; ++m) {
                        if (k != categCompareCol[m]) continue;
                        isRotaCol = true;
                        break;
                    }
                    if (k >= startCol && k <= endCol) {
                        isRotaCol = true;
                    }
                    if (isRotaCol) continue;
                    rowData[count] = rowList.get(k);
                    ++count;
                }
            }
            for (j = 0; j < cateItemSize; ++j) {
                int t;
                if (categColSize == 1) {
                    pkColValue = rowList.get(categCompareCol[0]);
                    if (pkColValue == null) {
                        pkColValue = "null";
                    }
                    Object e = compareValue = isTwoDimensionCategory ? ((List)categorys.get(categCol[0])).get(j) : categorys.get(j);
                    if (compareValue == null) {
                        compareValue = "null";
                    }
                    if (!BeanUtil.equalsIgnoreType(pkColValue, compareValue, false)) continue;
                    for (t = 0; t < rotateWith; ++t) {
                        rowData[count + j * rotateWith + t] = rowList.get(startCol + t);
                    }
                    continue;
                }
                categoryColEqual = true;
                for (int k2 = 0; k2 < categColSize; ++k2) {
                    pkColValue = rowList.get(categCompareCol[k2]);
                    if (pkColValue == null) {
                        pkColValue = "null";
                    }
                    Object e = compareValue = isTwoDimensionCategory ? ((List)categorys.get(categCol[k2])).get(j) : categorys.get(j);
                    if (compareValue == null) {
                        compareValue = "null";
                    }
                    categoryColEqual = categoryColEqual && BeanUtil.equalsIgnoreType(pkColValue, compareValue, false);
                }
                if (!categoryColEqual) continue;
                for (t = 0; t < rotateWith; ++t) {
                    rowData[count + j * rotateWith + t] = rowList.get(startCol + t);
                }
            }
            if (i != rowSize - 1) continue;
            result.add(rowData);
        }
        CollectionUtil.innerArrayToList(result);
        return result;
    }

    public static HashMap hashList(Object data, Object keyProp, Object valueProp, boolean keyToStr) {
        return CollectionUtil.hashList(data, keyProp, valueProp, keyToStr, false);
    }

    public static HashMap hashList(Object data, Object keyProp, Object valueProp, boolean keyToStr, boolean isLinkedHash) {
        int dimen = CollectionUtil.judgeObjectDimen(data);
        boolean isBean = !NumberUtil.isInteger(keyProp.toString());
        int keyIndex = -1;
        int valueIndex = -1;
        String valueProperty = null;
        String keyProperty = "";
        if (!isBean) {
            keyIndex = Integer.parseInt(keyProp.toString());
            valueIndex = valueProp == null ? -1 : Integer.parseInt(valueProp.toString());
        } else {
            keyProperty = keyProp.toString();
            valueProperty = (String)valueProp;
        }
        HashMap result = isLinkedHash ? new LinkedHashMap() : new HashMap();
        try {
            List hashValues = null;
            String[] hashProperties = null;
            if (isBean) {
                String[] stringArray;
                if (valueProperty == null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = keyProperty;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = keyProperty;
                    stringArray = stringArray3;
                    stringArray3[1] = valueProperty;
                }
                hashProperties = stringArray;
            }
            switch (dimen) {
                case -1: 
                case 0: {
                    break;
                }
                case 1: {
                    if (data.getClass().isArray()) {
                        Object[] hashObj = CollectionUtil.convertArray(data);
                        if (isBean) {
                            hashValues = BeanUtil.reflectBeansToList(CollectionUtil.arrayToList(hashObj), hashProperties);
                        }
                        int n = hashObj.length;
                        for (int i = 0; i < n; ++i) {
                            if (isBean) {
                                result.put(keyToStr ? ((List)hashValues.get(i)).get(0).toString() : ((List)hashValues.get(i)).get(0), valueProperty == null ? hashObj[i] : ((List)hashValues.get(i)).get(1));
                                continue;
                            }
                            List rowData = (List)hashObj[i];
                            result.put(keyToStr ? rowData.get(keyIndex).toString() : rowData.get(keyIndex), valueIndex == -1 ? hashObj[i] : rowData.get(valueIndex));
                        }
                    } else {
                        if (!(data instanceof List)) break;
                        List hashObj = (List)data;
                        if (isBean) {
                            hashValues = BeanUtil.reflectBeansToList(hashObj, hashProperties);
                        }
                        int n = hashObj.size();
                        for (int i = 0; i < n; ++i) {
                            if (isBean) {
                                result.put(keyToStr ? ((List)hashValues.get(i)).get(0).toString() : ((List)hashValues.get(i)).get(0), valueProperty == null ? hashObj.get(i) : ((List)hashValues.get(i)).get(1));
                                continue;
                            }
                            Object[] rowData = CollectionUtil.convertArray(hashObj.get(i));
                            result.put(keyToStr ? rowData[keyIndex].toString() : rowData[keyIndex], valueIndex == -1 ? hashObj.get(i) : rowData[valueIndex]);
                        }
                    }
                    break;
                }
                case 2: {
                    if (data.getClass().isArray()) {
                        Object[] hashObj = CollectionUtil.convertArray(data);
                        int n = hashObj.length;
                        for (int i = 0; i < n; ++i) {
                            Object[] rowData = CollectionUtil.convertArray(hashObj[i]);
                            result.put(keyToStr ? rowData[keyIndex].toString() : rowData[keyIndex], valueIndex == -1 ? hashObj[i] : rowData[valueIndex]);
                        }
                    } else {
                        if (!(data instanceof List)) break;
                        List hashObj = (List)data;
                        int n = hashObj.size();
                        for (int i = 0; i < n; ++i) {
                            List rowData = (List)hashObj.get(i);
                            result.put(keyToStr ? rowData.get(keyIndex).toString() : rowData.get(keyIndex), valueIndex == -1 ? hashObj.get(i) : rowData.get(valueIndex));
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void innerArrayToList(List source) {
        if (source == null || source.isEmpty()) {
            return;
        }
        if (source.get(0).getClass().isArray()) {
            int n = source.size();
            for (int i = 0; i < n; ++i) {
                ArrayList<Object> rowList = new ArrayList<Object>();
                Object[] rowAry = CollectionUtil.convertArray(source.get(i));
                int k = rowAry.length;
                for (int j = 0; j < k; ++j) {
                    rowList.add(rowAry[j]);
                }
                source.remove(i);
                source.add(i, rowList);
            }
        }
    }

    public static List innerListToArray(List source) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int n = source.size();
        for (int i = 0; i < n; ++i) {
            Object sonList = source.get(i);
            if (null == sonList) {
                result.add(null);
                continue;
            }
            if (sonList instanceof Collection) {
                result.add(((Collection)sonList).toArray());
                continue;
            }
            if (sonList.getClass().isArray()) {
                result.add(sonList);
                continue;
            }
            logger.error("\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u4e3aCollection");
            break;
        }
        return result;
    }

    public static void groupSummary(List sumData, SummaryGroupMeta[] groupMetas, boolean isReverse, String linkSign, boolean skipSingleRowSummary) {
        if (sumData == null || sumData.size() < 2 || groupMetas == null || groupMetas.length == 0) {
            return;
        }
        LinkedHashSet<Integer> groupCols = new LinkedHashSet<Integer>();
        for (SummaryGroupMeta groupMeta : groupMetas) {
            if (groupMeta.getGroupCols() != null && groupMeta.getGroupCols().length > 0) {
                Integer[] integerArray = groupMeta.getGroupCols();
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int index = integerArray[i];
                    groupCols.add(index);
                }
            }
            if (groupCols.size() > 0) {
                Integer[] cols = new Integer[groupCols.size()];
                groupCols.toArray(cols);
                groupMeta.setGroupCols(cols);
            }
            if (groupMeta.getSumSite() != null) {
                groupMeta.setSumSite(groupMeta.getSumSite().toLowerCase());
                continue;
            }
            groupMeta.setSumSite("");
        }
        if (isReverse) {
            Collections.reverse(sumData);
            for (SummaryGroupMeta groupMeta : groupMetas) {
                if (groupMeta.getSumSite() == null) continue;
                if ("top".equals(groupMeta.getSumSite())) {
                    groupMeta.setSumSite("bottom");
                    continue;
                }
                if (!"bottom".equals(groupMeta.getSumSite())) continue;
                groupMeta.setSumSite("top");
            }
        }
        CollectionUtil.summaryList(sumData, groupMetas, StringUtil.isBlank(linkSign) ? " / " : linkSign, skipSingleRowSummary);
        if (isReverse) {
            Collections.reverse(sumData);
        }
    }

    private static void summaryList(List<List> dataSet, SummaryGroupMeta[] groupMetas, String linkSign, boolean skipSingleRowSummary) {
        ArrayList<List> iterList = new ArrayList<List>();
        for (List item : dataSet) {
            iterList.add(item);
        }
        int groupSize = groupMetas.length;
        List preRow = (List)iterList.get(0);
        int dataSize = iterList.size();
        int addRows = 0;
        for (int i = 0; i < dataSize; ++i) {
            List row = (List)iterList.get(i);
            for (int j = groupSize; j > 0; --j) {
                SummaryGroupMeta groupMeta = groupMetas[j - 1];
                if (CollectionUtil.isEquals(row, preRow, i, groupMeta.getGroupCols())) {
                    CollectionUtil.calculateTotal(row, groupMeta);
                } else {
                    if (groupMeta.getSummaryCols()[0].getRowCount() > 1 || !skipSingleRowSummary) {
                        List sumRows = CollectionUtil.createSummaryRow(preRow, groupMeta, linkSign);
                        dataSet.addAll(i + addRows, sumRows);
                        addRows += sumRows.size();
                    }
                    for (SummaryColMeta colMeta : groupMeta.getSummaryCols()) {
                        colMeta.setNullCount(0);
                        colMeta.setSumValue(BigDecimal.ZERO);
                        colMeta.setRowCount(0);
                    }
                    CollectionUtil.calculateTotal(row, groupMeta);
                }
                if (i != dataSize - 1 || groupMeta.getSummaryCols()[0].getRowCount() <= 1 && skipSingleRowSummary) continue;
                if (groupMeta.isGlobalReverse()) {
                    dataSet.addAll(0, CollectionUtil.createSummaryRow(row, groupMeta, linkSign));
                    continue;
                }
                dataSet.addAll(CollectionUtil.createSummaryRow(row, groupMeta, linkSign));
            }
            preRow = row;
        }
    }

    private static boolean isEquals(List currentRow, List preRow, int index, Integer[] columns) {
        if (columns == null || columns.length == 0 || index == 0) {
            return true;
        }
        for (int i = 0; i < columns.length; ++i) {
            int cellIndex = columns[i];
            if (BeanUtil.equals(currentRow.get(cellIndex), preRow.get(cellIndex))) continue;
            return false;
        }
        return true;
    }

    private static void calculateTotal(List row, SummaryGroupMeta groupMeta) {
        for (SummaryColMeta colMeta : groupMeta.getSummaryCols()) {
            Object cellValue = row.get(colMeta.getColIndex());
            colMeta.setRowCount(colMeta.getRowCount() + 1);
            if (cellValue == null || "".equals(cellValue.toString().trim())) {
                colMeta.setNullCount(colMeta.getNullCount() + 1);
                continue;
            }
            colMeta.setSumValue(colMeta.getSumValue().add(new BigDecimal(cellValue.toString().replace(",", ""))));
        }
    }

    private static List createSummaryRow(List row, SummaryGroupMeta groupMeta, String linkSign) {
        ArrayList result = new ArrayList();
        int rowSize = groupMeta.getRowSize();
        int labelIndex = groupMeta.getLabelIndex();
        for (int i = 0; i < rowSize; ++i) {
            ArrayList rowData = new ArrayList();
            for (int j = 0; j < row.size(); ++j) {
                rowData.add(null);
            }
            if (labelIndex > 0) {
                for (int k = 0; k < labelIndex; ++k) {
                    rowData.set(k, row.get(k));
                }
            }
            result.add(rowData);
        }
        List sumList = null;
        List aveList = null;
        if (rowSize == 2) {
            if ("top".equals(groupMeta.getSumSite())) {
                sumList = (List)result.get(0);
                aveList = (List)result.get(1);
            } else {
                sumList = (List)result.get(1);
                aveList = (List)result.get(0);
            }
            sumList.set(labelIndex, groupMeta.getSumTitle());
            aveList.set(labelIndex, groupMeta.getAverageTitle());
        } else {
            sumList = (List)result.get(0);
            if (groupMeta.getSummaryType() == 3) {
                if ("left".equals(groupMeta.getSumSite())) {
                    sumList.set(labelIndex, groupMeta.getSumTitle() + linkSign + groupMeta.getAverageTitle());
                } else {
                    sumList.set(labelIndex, groupMeta.getAverageTitle() + linkSign + groupMeta.getSumTitle());
                }
            } else if (groupMeta.getSummaryType() == 1) {
                sumList.set(labelIndex, groupMeta.getSumTitle());
            } else if (groupMeta.getSummaryType() == 2) {
                sumList.set(labelIndex, groupMeta.getAverageTitle());
            }
        }
        String sumStr = "--";
        String aveStr = "--";
        for (SummaryColMeta colMeta : groupMeta.getSummaryCols()) {
            BigDecimal sumValue = colMeta.getSumValue();
            BigDecimal aveValue = sumValue.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (colMeta.isAveSkipNull() ? sumValue.divide(BigDecimal.valueOf(colMeta.getRowCount() - colMeta.getNullCount()), colMeta.getRadixSize(), colMeta.getRoundingMode()) : sumValue.divide(BigDecimal.valueOf(colMeta.getRowCount()), colMeta.getRadixSize(), colMeta.getRoundingMode()));
            if (rowSize == 2) {
                if (colMeta.getSummaryType() == 1 || colMeta.getSummaryType() == 3) {
                    sumList.set(colMeta.getColIndex(), sumValue);
                }
                if (colMeta.getSummaryType() != 2 && colMeta.getSummaryType() != 3) continue;
                aveList.set(colMeta.getColIndex(), aveValue);
                continue;
            }
            if (groupMeta.getSummaryType() == 3) {
                if (colMeta.getSummaryType() == 1) {
                    sumStr = sumValue.toPlainString();
                    aveStr = "--";
                } else if (colMeta.getSummaryType() == 2) {
                    aveStr = aveValue.toPlainString();
                    sumStr = "--";
                } else if (colMeta.getSummaryType() == 3) {
                    sumStr = sumValue.toPlainString();
                    aveStr = aveValue.toPlainString();
                }
                if ("left".equals(groupMeta.getSumSite())) {
                    sumList.set(colMeta.getColIndex(), sumStr + linkSign + aveStr);
                    continue;
                }
                sumList.set(colMeta.getColIndex(), aveStr + linkSign + sumStr);
                continue;
            }
            if (colMeta.getSummaryType() == 1) {
                sumList.set(colMeta.getColIndex(), sumValue);
                continue;
            }
            if (colMeta.getSummaryType() != 2) continue;
            sumList.set(colMeta.getColIndex(), aveValue);
        }
        return result;
    }

    public static List convertColToRow(List data, Integer[] colIndexs) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        boolean innerAry = data.get(0).getClass().isArray();
        int newResultRowCnt = 0;
        newResultRowCnt = colIndexs == null ? (innerAry ? CollectionUtil.convertArray(data.get(0)).length : ((List)data.get(0)).size()) : colIndexs.length;
        Object[][] resultAry = new Object[newResultRowCnt][data.size()];
        Object[] rowAry = null;
        List rowList = null;
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            int j;
            if (innerAry) {
                rowAry = CollectionUtil.convertArray(data.get(i));
            } else {
                rowList = (List)data.get(i);
            }
            if (colIndexs != null) {
                int k = colIndexs.length;
                for (j = 0; j < k; ++j) {
                    resultAry[j][i] = innerAry ? rowAry[colIndexs[j]] : rowList.get(colIndexs[j]);
                }
                continue;
            }
            for (j = 0; j < newResultRowCnt; ++j) {
                resultAry[j][i] = innerAry ? rowAry[j] : rowList.get(j);
            }
        }
        return CollectionUtil.arrayToDeepList(resultAry);
    }

    public static boolean any(String compareStr, String[] compareAry, boolean ignoreCase) {
        if (compareStr == null || compareAry == null || compareAry.length == 0) {
            return false;
        }
        for (String s : compareAry) {
            if (!(ignoreCase ? compareStr.equalsIgnoreCase(s) : compareStr.equals(s))) continue;
            return true;
        }
        return false;
    }

    public static Object[] toArray(String[] values, String argType) {
        if (values == null) {
            return null;
        }
        String type = argType.toLowerCase();
        Object[] result = null;
        if ("string".equals(type)) {
            result = new String[values.length];
        } else if ("int".equals(type) || "integer".equals(type)) {
            result = new Integer[values.length];
        } else if ("long".equals(type)) {
            result = new Long[values.length];
        } else if ("date".equals(type)) {
            result = new Date[values.length];
        } else if ("boolean".equals(type)) {
            result = new Boolean[values.length];
        } else if ("double".equals(type)) {
            result = new Double[values.length];
        } else if ("float".equals(type)) {
            result = new Float[values.length];
        } else if ("short".equals(type)) {
            result = new Short[values.length];
        } else if ("java.lang.class".equals(type) || "class".equals(type)) {
            result = new Class[values.length];
        }
        for (int i = 0; i < result.length; ++i) {
            if (values[i] == null) continue;
            if ("string".equals(type)) {
                result[i] = values[i];
                continue;
            }
            if ("int".equals(type) || "integer".equals(type)) {
                result[i] = Integer.valueOf(values[i]);
                continue;
            }
            if ("long".equals(type)) {
                result[i] = Long.valueOf(values[i]);
                continue;
            }
            if ("date".equals(type)) {
                result[i] = DateUtil.parseString(values[i]);
                continue;
            }
            if ("boolean".equals(type)) {
                result[i] = Boolean.parseBoolean(values[i]);
                continue;
            }
            if ("double".equals(type)) {
                result[i] = Double.valueOf(values[i]);
                continue;
            }
            if ("float".equals(type)) {
                result[i] = Float.valueOf(values[i]);
                continue;
            }
            if ("short".equals(type)) {
                result[i] = Short.valueOf(values[i]);
                continue;
            }
            if (!"java.lang.class".equals(type) && !"class".equals(type)) continue;
            try {
                result[i] = Class.forName(values[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean any(Object value, Object ... compareAry) {
        return CollectionUtil.any(value, false, compareAry);
    }

    public static boolean any(Object value, boolean ignoreCase, Object ... compareAry) {
        if (compareAry == null || compareAry.length == 0) {
            return false;
        }
        String valueStr = value == null ? "" : value.toString();
        for (Object s : compareAry) {
            if (value == null || s == null) {
                return value == s;
            }
            if (value.equals(s)) {
                return true;
            }
            if (!ignoreCase || !valueStr.equalsIgnoreCase(s.toString())) continue;
            return true;
        }
        return false;
    }

    public static void removeNull(List dataSet) {
        if (dataSet != null && !dataSet.isEmpty()) {
            Iterator iter = dataSet.iterator();
            while (iter.hasNext()) {
                if (null != iter.next()) continue;
                iter.remove();
            }
        }
    }

    public static void groupSort(List<List> dataSet, Integer[] groupIndexes, int sortIndex, boolean desc) {
        if (dataSet == null || dataSet.size() < 2) {
            return;
        }
        int length = dataSet.size();
        int dataType = CollectionUtil.getSortDataType(dataSet, sortIndex);
        int start = 0;
        int groupSize = groupIndexes.length;
        Object[] compareValue = new Object[groupSize];
        Object[] tempObj = new Object[groupSize];
        boolean isEqual = false;
        for (int i = 0; i < length; ++i) {
            int j;
            List row = dataSet.get(i);
            isEqual = true;
            for (j = 0; j < groupSize; ++j) {
                tempObj[j] = row.get(groupIndexes[j]);
                if (i == 0) {
                    compareValue[j] = tempObj[j];
                }
                isEqual = isEqual && tempObj[j].equals(compareValue[j]);
            }
            if (!isEqual) {
                int end = i - 1;
                CollectionUtil.sortList(dataSet, sortIndex, dataType, start, end, !desc);
                start = i;
                for (j = 0; j < groupSize; ++j) {
                    compareValue[j] = tempObj[j];
                }
            }
            if (i != length - 1) continue;
            CollectionUtil.sortList(dataSet, sortIndex, dataType, start, i, !desc);
        }
    }

    public static int getSortDataType(List<List> dataSet, int sortIndex) {
        int dataType = 1;
        for (List item : dataSet) {
            Object dataValue = item.get(sortIndex);
            if (dataValue == null) continue;
            if (dataValue instanceof String) {
                dataType = 1;
                break;
            }
            if (dataValue instanceof Number) {
                dataType = 2;
                break;
            }
            if (dataValue instanceof Date) {
                dataType = 3;
                break;
            }
            if (dataValue instanceof LocalDate) {
                dataType = 4;
                break;
            }
            if (dataValue instanceof LocalDateTime) {
                dataType = 5;
                break;
            }
            if (!(dataValue instanceof LocalTime)) break;
            dataType = 6;
            break;
        }
        return dataType;
    }

    public static List sortList(List<List> sortList, final int orderCol, final int dataType, int start, int end, final boolean ascend) {
        if (start == end) {
            return sortList;
        }
        List<List> subList = sortList.subList(start, end + 1);
        Collections.sort(subList, new Comparator<List>(){

            @Override
            public int compare(List o1, List o2) {
                return CollectionUtil.compareValue(o1.get(orderCol), o2.get(orderCol), dataType, ascend);
            }
        });
        return sortList;
    }

    private static int compareValue(Object iData, Object jData, int dataType, boolean ascend) {
        boolean lessThen = false;
        boolean isEqual = false;
        if (iData == null && jData == null) {
            isEqual = true;
        }
        if (iData != null && jData == null) {
            lessThen = false;
        } else if (iData == null && jData != null) {
            lessThen = true;
        } else if (iData.equals(jData)) {
            isEqual = true;
        } else if (dataType == 2) {
            lessThen = ((Number)iData).doubleValue() < ((Number)jData).doubleValue();
        } else if (dataType == 3) {
            lessThen = ((Date)iData).before((Date)jData);
        } else if (dataType == 4) {
            lessThen = ((LocalDate)iData).compareTo((LocalDate)jData) < 0;
        } else if (dataType == 5) {
            lessThen = ((LocalDateTime)iData).compareTo((LocalDateTime)jData) < 0;
        } else if (dataType == 6) {
            lessThen = ((LocalTime)iData).compareTo((LocalTime)jData) < 0;
        } else {
            String str1 = iData.toString();
            String str2 = jData.toString();
            if (str1.length() < str2.length()) {
                lessThen = true;
            } else if (str1.length() > str2.length()) {
                lessThen = false;
            } else {
                boolean bl = lessThen = str1.compareTo(str2) < 0;
            }
        }
        if (isEqual) {
            return 0;
        }
        if (ascend) {
            return lessThen ? -1 : 1;
        }
        return lessThen ? 1 : -1;
    }

    public static void groupCalculate(List<List> dataSet, Integer[] groupIndexes, int calcuateIndex, boolean isSum) {
        int groupSize = groupIndexes.length;
        int length = dataSet.size();
        Object[] compareValue = new Object[groupSize];
        Object[] tempObj = new Object[groupSize];
        boolean isEqual = false;
        int start = 0;
        int end = 0;
        BigDecimal calculateValue = new BigDecimal(0);
        for (int i = 0; i < length; ++i) {
            int k;
            int j;
            List row = dataSet.get(i);
            Object tmpCellValue = row.get(calcuateIndex);
            BigDecimal cellValue = CollectionUtil.toDecimal(tmpCellValue);
            isEqual = true;
            for (j = 0; j < groupSize; ++j) {
                tempObj[j] = row.get(groupIndexes[j]);
                if (i == 0) {
                    compareValue[j] = row.get(groupIndexes[j]);
                }
                isEqual = isEqual && tempObj[j].equals(compareValue[j]);
            }
            if (isEqual) {
                calculateValue = calculateValue.add(cellValue);
            } else {
                end = i - 1;
                if (!isSum && end > start) {
                    calculateValue = calculateValue.divide(BigDecimal.valueOf(end - start), 4, RoundingMode.HALF_DOWN);
                }
                for (k = start; k <= end; ++k) {
                    dataSet.get(k).add(calculateValue);
                }
                for (j = 0; j < groupSize; ++j) {
                    compareValue[j] = tempObj[j];
                }
                calculateValue = new BigDecimal(0).add(cellValue);
                start = i;
            }
            if (i != length - 1) continue;
            end = i;
            if (!isSum && end > start) {
                calculateValue = calculateValue.divide(BigDecimal.valueOf(end - start), 4, RoundingMode.HALF_DOWN);
            }
            for (k = start; k <= end; ++k) {
                dataSet.get(k).add(calculateValue);
            }
        }
    }

    private static BigDecimal toDecimal(Object tmpCellValue) {
        if (tmpCellValue == null) {
            return BigDecimal.ZERO;
        }
        if (tmpCellValue instanceof BigDecimal) {
            return (BigDecimal)tmpCellValue;
        }
        if (tmpCellValue instanceof Number) {
            return new BigDecimal(tmpCellValue.toString());
        }
        return new BigDecimal(tmpCellValue.toString().replaceAll(",", "").replaceFirst(ILLEGAL_NUM_REGEX, ""));
    }

    public static List<Object[]> clearRepeat(List<Object[]> inArgsList) {
        int i;
        if (inArgsList == null || inArgsList.isEmpty() || inArgsList.get(0).length < 2) {
            return inArgsList;
        }
        int size = inArgsList.size();
        ArrayList middleList = new ArrayList();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (int i2 = 0; i2 < size; ++i2) {
            middleList.add(new ArrayList());
        }
        HashSet<String> notRepeatSet = new HashSet<String>();
        int loopSize = inArgsList.get(0).length;
        for (i = 0; i < loopSize; ++i) {
            int j;
            String key = "";
            for (j = 0; j < size; ++j) {
                key = key + ",{" + inArgsList.get(j)[i] + "}";
            }
            if (notRepeatSet.contains(key)) continue;
            notRepeatSet.add(key);
            for (j = 0; j < size; ++j) {
                ((List)middleList.get(j)).add(inArgsList.get(j)[i]);
            }
        }
        for (i = 0; i < size; ++i) {
            result.add(((List)middleList.get(i)).toArray());
        }
        return result;
    }
}

