/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.sagacity.sqltoy.callback.TransactionHandler;
import org.sagacity.sqltoy.exception.DataAccessException;

public class DBTransUtils {
    private static ThreadLocal<Connection> threadLocal = new TransmittableThreadLocal();

    public static Object doTrans(DataSource dataSource, TransactionHandler transactionHandler) throws DataAccessException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            conn.setAutoCommit(false);
            threadLocal.set(conn);
            Object result = transactionHandler.doTrans();
            conn.commit();
            Object object = result;
            return object;
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new DataAccessException(e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
            threadLocal.remove();
        }
    }

    public static Connection getCurrentConnection() {
        return threadLocal.get();
    }
}

