/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final String[] CHINA_DATE_KEYS = new String[]{"\u25cb", "\u041e", "0", "\u039f", "O", "\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5e74", "\u6708", "\u65e5", "\u65f6", "\u5206", "\u79d2"};
    private static final String[] CHINA_DATE_KEY_MAP = new String[]{"0", "0", "0", "0", "0", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "-", "-", " ", ":", ":", " "};
    private static final String[] MONTH_ENGLISH_NAME = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] MONTH_ENGLISH_NAKE = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s");
    private static final String[] WEEK_CHINA_NAME = new String[]{"\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", "\u661f\u671f\u65e5"};
    private static final String[] WEEK_ENGLISH_NAME = new String[]{"Monday", "Tuesday", "Wednesday", "Thurday", "Friday", "Saturday", "Sunday"};
    private static final String[] WEEK_ENGLISH_NAKE = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static final Pattern WEEK_PATTERN = Pattern.compile("(?i)(Mon|Tue|Wed|Thu|Fri|Sat|Sun)\\s");
    private static final Pattern DAY_PATTERN = Pattern.compile("(?i)\\s\\d{1,2}(st|th|rd)?\\s");
    private static final Pattern MORE_TEN_PATTERN = Pattern.compile("(\u4e00|\u4e8c|\u4e09|\u56db|\u4e94)?\\\u5341(\u4e00|\u4e8c|\u4e09|\u56db|\u4e94|\u516d|\u4e03|\u516b|\u4e5d)");
    private static final Collection<String> DEFAULT_DAY_PATTERNS = Arrays.asList("MMM dd yyyy", "MMM dd z yyyy");
    private static final Collection<String> DEFAULT_WEEK_DAY_PATTERNS = Arrays.asList("EEE MMM dd yyyy", "EEE MMM dd z yyyy");
    private static final Collection<String> DEFAULT_TIME_PATTERNS = Arrays.asList("MMM dd HH:mm:ss z yyyy", "MMM dd HH:mm:ss yyyy", "MMM dd yyyy HH:mm:ss", "MMM dd yyyy HH:mm:ss z");
    private static final Collection<String> DEFAULT_WEEK_TIME_PATTERNS = Arrays.asList("EEE MMM dd HH:mm:ss z yyyy", "EEE MMM dd HH:mm:ss yyyy", "EEE MMM dd yyyy HH:mm:ss z", "EEEE dd-MMM-yyyy HH:mm:ss", "EEEE dd-MMM-yyyy HH:mm:ss z", "EEEE dd-MMM-yy HH:mm:ss z", "EEEE dd-MMM-yy HH:mm:ss");
    private static final Pattern DAYTH_PATTERN = Pattern.compile("(?i)\\s\\d{1,2}(st|th|nd|rd)\\s");
    private static final Pattern TIME_PATTERN = Pattern.compile("\\d{1,2}\\:\\d{1,2}");
    private static final Pattern TIME_DOT_PATTERN = Pattern.compile("\\d\\.\\d");

    private DateUtil() {
    }

    public static java.util.Date parse(Object data, String format) {
        return DateUtil.parse(data, format, null);
    }

    public static java.util.Date parse(Object data, String format, Locale locale) {
        if (null == data) {
            logger.error("The date string is null!");
            return null;
        }
        if (data instanceof String) {
            return DateUtil.parseString((String)data, format, locale);
        }
        if (format == null) {
            return DateUtil.convertDateObject(data, null, locale);
        }
        String result = DateUtil.formatDate(data, format, locale);
        return DateUtil.parseString(result, format, locale);
    }

    public static java.util.Date parseString(String dateStr) {
        return DateUtil.parseString(dateStr, null, null);
    }

    public static java.util.Date parseString(String dateVar, String dateFormat, Locale locale) {
        if (dateVar == null) {
            return null;
        }
        String dateStr = dateVar.trim();
        if ("".equals(dateStr) || dateStr.toLowerCase().equals("null")) {
            return null;
        }
        String realDF = null;
        boolean isLocalDateTime = false;
        boolean isLocalTime = false;
        if (StringUtil.isNotBlank(dateFormat)) {
            realDF = dateFormat;
        } else {
            int size;
            boolean hasBlank;
            if (StringUtil.matches(dateStr, "[a-zA-Z]{2}")) {
                return DateUtil.parseEnglishDate(dateStr, locale);
            }
            if (StringUtil.matches(dateStr, "[\u5e74\u6708\u65e5\u65f6\u5206\u79d2]")) {
                dateStr = DateUtil.parseChinaDate(dateStr);
            } else if (StringUtil.hasChinese(dateStr)) {
                return null;
            }
            boolean bl = hasBlank = dateStr.indexOf(" ") != -1 || dateStr.toUpperCase().indexOf("T") >= 6;
            if (hasBlank) {
                dateStr = dateStr.replaceFirst("\\s+", " ").replaceFirst("(?i)T", " ").replace("-", "").replace(".", "").replace(":", "").replace("/", "");
                int preSize = dateStr.indexOf(" ");
                size = dateStr.length();
                if (size > 21) {
                    dateStr = DateUtil.addZero(dateStr, size, 24);
                    realDF = "yyyyMMdd HHmmssSSSSSSSSS";
                    isLocalDateTime = true;
                } else if (size > 18) {
                    dateStr = DateUtil.addZero(dateStr, size, 21);
                    realDF = "yyyyMMdd HHmmssSSSSSS";
                    isLocalDateTime = true;
                } else if (size > 16) {
                    dateStr = DateUtil.addZero(dateStr, size, 18);
                    realDF = "yyyyMMdd HHmmssSSS";
                    isLocalDateTime = true;
                } else if (size == 16) {
                    if (preSize == 8) {
                        realDF = "yyyyMMdd HHmmssS";
                        isLocalDateTime = true;
                    } else {
                        realDF = "yyMMdd HHmmssSSS";
                        isLocalDateTime = true;
                    }
                } else {
                    realDF = size == 13 ? (preSize == 8 ? "yyyyMMdd HHmm" : "yyMMdd HHmmss") : (size == 11 ? (preSize == 8 ? "yyyyMMdd HH" : "yyMMdd HHmm") : (size == 9 ? "yyMMdd HH" : "yyyyMMdd HHmmss"));
                }
            } else {
                dateStr = dateStr.replace(",", "");
                size = dateStr.length();
                if (dateStr.indexOf(":") != -1) {
                    if (dateStr.indexOf(".") != -1) {
                        if (size > 15) {
                            dateStr = DateUtil.addZero(dateStr, size, 18);
                            realDF = "HH:mm:ss.SSSSSSSSS";
                            isLocalTime = true;
                        } else if (size > 12) {
                            dateStr = DateUtil.addZero(dateStr, size, 15);
                            realDF = "HH:mm:ss.SSSSSS";
                            isLocalTime = true;
                        } else if (size > 10) {
                            dateStr = DateUtil.addZero(dateStr, size, 12);
                            realDF = "HH:mm:ss.SSS";
                            isLocalTime = true;
                        } else {
                            realDF = "HH:mm:ss.S";
                            isLocalTime = true;
                        }
                    } else {
                        realDF = size == 5 ? "HH:mm" : "HH:mm:ss";
                    }
                } else {
                    int splitCount = StringUtil.matchCnt(dateStr = dateStr.replace("-", "/").replace(".", "/"), "\\/");
                    if (splitCount == 2) {
                        int startIndex = dateStr.indexOf("/");
                        realDF = startIndex == 2 ? "yy/MM/dd" : "yyyy/MM/dd";
                    } else if (splitCount == 1) {
                        realDF = size > 5 ? "yyyy/MM" : "yy/MM";
                    } else if (size > 22) {
                        dateStr = dateStr.substring(0, 8).concat(" ").concat(dateStr.substring(8, 14)).concat(".").concat(DateUtil.addZero(dateStr.substring(14), 9));
                        realDF = "yyyyMMdd HHmmss.SSSSSSSSS";
                        isLocalDateTime = true;
                    } else if (size > 19) {
                        dateStr = dateStr.substring(0, 8).concat(" ").concat(dateStr.substring(8, 14)).concat(".").concat(DateUtil.addZero(dateStr.substring(14), 6));
                        realDF = "yyyyMMdd HHmmss.SSSSSS";
                        isLocalDateTime = true;
                    } else if (size > 17) {
                        dateStr = dateStr.substring(0, 8).concat(" ").concat(dateStr.substring(8, 14)).concat(".").concat(DateUtil.addZero(dateStr.substring(14), 3));
                        realDF = "yyyyMMdd HHmmss.SSS";
                        isLocalDateTime = true;
                    } else if (size == 17) {
                        dateStr = dateStr.substring(0, 8).concat(" ").concat(dateStr.substring(8, 14)).concat(".").concat(dateStr.substring(14));
                        realDF = "yyyyMMdd HHmmss.S";
                        isLocalDateTime = true;
                    } else if (size == 15) {
                        realDF = "yyyyMMdd HHmmss";
                    } else if (size == 14) {
                        realDF = "yyyyMMddHHmmss";
                    } else {
                        if (size == 13) {
                            return new java.util.Date(Long.valueOf(dateStr));
                        }
                        realDF = size == 12 ? "yyMMddHHmmss" : (size == 10 ? "yyyyMMddHH" : (size == 6 ? "yyyyMM" : (size == 4 ? "yyyy" : "yyyyMMdd")));
                    }
                }
            }
            if (realDF == null) {
                String string = realDF = hasBlank ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd";
            }
        }
        if (isLocalTime) {
            LocalTime time = LocalTime.parse(dateStr, DateTimeFormatter.ofPattern(realDF));
            return DateUtil.asDate(time);
        }
        if (isLocalDateTime) {
            LocalDateTime localDateTime = LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(realDF));
            return DateUtil.asDate(localDateTime);
        }
        java.util.Date result = null;
        try {
            SimpleDateFormat df = locale == null ? new SimpleDateFormat(realDF) : new SimpleDateFormat(realDF, locale);
            result = df.parse(dateStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (result == null) {
            result = DateUtil.parseString(dateVar, null, locale);
            result = DateUtil.parseString(DateUtil.formatDate(result, realDF));
        }
        return result;
    }

    public static LocalDateTime parseLocalDateTime(String dateVar) {
        return DateUtil.parseLocalDateTime(dateVar, null);
    }

    public static LocalDateTime parseLocalDateTime(String dateVar, String dateFormat) {
        if (dateVar == null) {
            return null;
        }
        String dateStr = dateVar.trim();
        if ("".equals(dateStr) || dateStr.toLowerCase().equals("null")) {
            return null;
        }
        String realDF = null;
        boolean isTime = false;
        boolean isDate = false;
        if (StringUtil.isNotBlank(dateFormat)) {
            realDF = dateFormat;
        } else {
            int size;
            boolean hasBlank;
            if (StringUtil.matches(dateStr, "[a-zA-Z]{2}")) {
                return DateUtil.asLocalDateTime(DateUtil.parseEnglishDate(dateStr, null));
            }
            if (StringUtil.matches(dateStr, "[\u5e74\u6708\u65e5\u65f6\u5206\u79d2]")) {
                dateStr = DateUtil.parseChinaDate(dateStr);
            } else if (StringUtil.hasChinese(dateStr)) {
                return null;
            }
            boolean bl = hasBlank = dateStr.indexOf(" ") != -1 || dateStr.toUpperCase().indexOf("T") >= 6;
            if (hasBlank) {
                dateStr = dateStr.replaceFirst("\\s+", " ").replaceFirst("(?i)T", " ").replace("-", "").replace(".", "").replace(":", "").replace("/", "");
                int preSize = dateStr.indexOf(" ");
                size = dateStr.length();
                if (size > 21) {
                    dateStr = DateUtil.addZero(dateStr, size, 24);
                    realDF = "yyyyMMdd HHmmssSSSSSSSSS";
                } else if (size > 18) {
                    dateStr = DateUtil.addZero(dateStr, size, 21);
                    realDF = "yyyyMMdd HHmmssSSSSSS";
                } else if (size > 16) {
                    dateStr = DateUtil.addZero(dateStr, size, 18);
                    realDF = "yyyyMMdd HHmmssSSS";
                } else {
                    realDF = size == 16 ? (preSize == 8 ? "yyyyMMdd HHmmssS" : "yyMMdd HHmmssSSS") : (size == 13 ? (preSize == 8 ? "yyyyMMdd HHmm" : "yyMMdd HHmmss") : (size == 11 ? (preSize == 8 ? "yyyyMMdd HH" : "yyMMdd HHmm") : (size == 9 ? "yyMMdd HH" : "yyyyMMdd HHmmss")));
                }
            } else {
                dateStr = dateStr.replace(",", "");
                size = dateStr.length();
                if (dateStr.indexOf(":") != -1) {
                    if (dateStr.indexOf(".") != -1) {
                        if (size > 15) {
                            dateStr = DateUtil.addZero(dateStr, size, 18);
                            realDF = "HH:mm:ss.SSSSSSSSS";
                        } else if (size > 12) {
                            dateStr = DateUtil.addZero(dateStr, size, 15);
                            realDF = "HH:mm:ss.SSSSSS";
                        } else if (size > 10) {
                            dateStr = DateUtil.addZero(dateStr, size, 12);
                            realDF = "HH:mm:ss.SSS";
                        } else {
                            realDF = "HH:mm:ss.S";
                        }
                    } else {
                        realDF = size == 5 ? "HH:mm" : "HH:mm:ss";
                    }
                    isTime = true;
                } else {
                    int splitCount = StringUtil.matchCnt(dateStr = dateStr.replace("-", "/").replace(".", "/"), "\\/");
                    if (splitCount == 2) {
                        int startIndex = dateStr.indexOf("/");
                        realDF = startIndex == 2 ? "yy/MM/dd" : "yyyy/MM/dd";
                        isDate = true;
                    } else if (splitCount == 1) {
                        realDF = size > 5 ? "yyyy/MM" : "yy/MM";
                        isDate = true;
                    } else if (size > 22) {
                        realDF = "yyyyMMdd HHmmss.SSSSSSSSS";
                        dateStr = dateStr.substring(0, 8).concat(" ").concat(dateStr.substring(8, 14)).concat(".").concat(DateUtil.addZero(dateStr.substring(14), 9));
                    } else if (size > 19) {
                        dateStr = dateStr.substring(0, 8).concat(" ").concat(dateStr.substring(8, 14)).concat(".").concat(DateUtil.addZero(dateStr.substring(14), 6));
                        realDF = "yyyyMMdd HHmmss.SSSSSS";
                    } else if (size > 17) {
                        dateStr = dateStr.substring(0, 8).concat(" ").concat(dateStr.substring(8, 14)).concat(".").concat(DateUtil.addZero(dateStr.substring(14), 3));
                        realDF = "yyyyMMdd HHmmss.SSS";
                    } else if (size == 17) {
                        dateStr = dateStr.substring(0, 8).concat(" ").concat(dateStr.substring(8, 14)).concat(".").concat(dateStr.substring(14));
                        realDF = "yyyyMMdd HHmmss.S";
                    } else if (size == 15) {
                        realDF = "yyyyMMdd HHmmss";
                    } else if (size == 14) {
                        realDF = "yyyyMMddHHmmss";
                    } else {
                        if (size == 13) {
                            return DateUtil.asLocalDateTime(new java.util.Date(Long.valueOf(dateStr)));
                        }
                        if (size == 12) {
                            realDF = "yyMMddHHmmss";
                        } else if (size == 10) {
                            realDF = "yyyyMMddHH";
                        } else if (size == 6) {
                            realDF = "yyyyMM";
                            isDate = true;
                        } else if (size == 4) {
                            realDF = "yyyy";
                            isDate = true;
                        } else {
                            realDF = "yyyyMMdd";
                            isDate = true;
                        }
                    }
                }
            }
            if (realDF == null) {
                if (hasBlank) {
                    realDF = "yyyy-MM-dd HH:mm:ss";
                } else {
                    realDF = "yyyy-MM-dd";
                    isDate = true;
                }
            }
        }
        LocalDateTime result = null;
        try {
            if (isTime) {
                LocalTime timeResult = LocalTime.parse(dateStr, DateTimeFormatter.ofPattern(realDF));
                return LocalDateTime.of(LocalDate.now(), timeResult);
            }
            if (isDate) {
                java.util.Date dateResult = new SimpleDateFormat(realDF).parse(dateStr);
                return DateUtil.asLocalDateTime(dateResult);
            }
            result = LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(realDF));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = DateUtil.parseLocalDateTime(dateStr, null);
            result = DateUtil.parseLocalDateTime(DateUtil.formatDate(result, realDF));
        }
        return result;
    }

    public static java.util.Date convertDateObject(Object dt) {
        return DateUtil.convertDateObject(dt, null, null);
    }

    public static LocalDateTime convertLocalDateTime(Object dt) {
        if (dt == null) {
            logger.warn("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u6b63\u786e\u8f93\u5165!");
            return null;
        }
        LocalDateTime result = null;
        if (dt instanceof String) {
            return DateUtil.parseLocalDateTime(dt.toString().trim());
        }
        if (dt instanceof java.util.Date) {
            return DateUtil.asLocalDateTime((java.util.Date)dt);
        }
        if (dt instanceof LocalDate) {
            LocalDate localDate = (LocalDate)dt;
            result = LocalDateTime.of(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), 0, 0, 0);
            return result;
        }
        if (dt instanceof LocalDateTime) {
            return (LocalDateTime)dt;
        }
        if (dt instanceof Number) {
            return DateUtil.parseLocalDateTime(dt.toString().trim());
        }
        if (dt instanceof LocalTime) {
            result = LocalDateTime.of(LocalDate.now(), (LocalTime)dt);
        }
        return result;
    }

    public static java.util.Date convertDateObject(Object dt, String format, Locale locale) {
        String dtStr;
        if (dt == null) {
            logger.warn("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u6b63\u786e\u8f93\u5165!");
            return null;
        }
        java.util.Date result = null;
        result = dt instanceof String ? ((dtStr = dt.toString().trim()).length() == 13 && NumberUtil.isInteger(dtStr) ? new java.util.Date(Long.valueOf(dtStr)) : DateUtil.parseString(dtStr, format, locale)) : (dt instanceof java.util.Date ? new java.util.Date(((java.util.Date)dt).getTime()) : (dt instanceof LocalDate ? DateUtil.asDate((LocalDate)dt) : (dt instanceof LocalDateTime ? DateUtil.asDate((LocalDateTime)dt) : (dt instanceof Number ? ((dtStr = dt.toString().trim()).length() != 13 ? DateUtil.parseString(dtStr, format, locale) : new java.util.Date(((Number)dt).longValue())) : (dt instanceof LocalTime ? DateUtil.asDate((LocalTime)dt) : DateUtil.parseString(dt.toString().trim(), format, locale))))));
        return result;
    }

    public static String formatDate(Object dt, String format) {
        return DateUtil.formatDate(dt, format, null);
    }

    public static String formatDate(Object dt, String format, Locale locale) {
        if (dt == null) {
            return null;
        }
        if (format == null) {
            throw new IllegalArgumentException("\u683c\u5f0f\u5316\u65e5\u671f\u6307\u5b9a\u7684format \u4e3anull,\u8bf7\u6b63\u786e\u8f93\u5165\u53c2\u6570!");
        }
        String fmtUpper = format.toUpperCase();
        if ("YY".equals(fmtUpper)) {
            String year = Integer.toString(DateUtil.getYear(dt));
            return year.substring(year.length() - 2);
        }
        if ("YYYY".equals(fmtUpper)) {
            return Integer.toString(DateUtil.getYear(dt));
        }
        if ("MM".equals(fmtUpper)) {
            int month = DateUtil.getMonth(dt);
            return (month < 10 ? "0" : "").concat(Integer.toString(month));
        }
        if ("DD".equals(fmtUpper)) {
            int day = DateUtil.getDay(dt);
            return (day < 10 ? "0" : "").concat(Integer.toString(day));
        }
        if (dt instanceof LocalDateTime) {
            return DateTimeFormatter.ofPattern(format).format((LocalDateTime)dt);
        }
        if (dt instanceof LocalTime) {
            return DateTimeFormatter.ofPattern(format).format((LocalTime)dt);
        }
        if (dt instanceof LocalDate) {
            return DateTimeFormatter.ofPattern(format).format((LocalDate)dt);
        }
        if (locale == null && (fmtUpper.endsWith("SSS") || fmtUpper.endsWith(".S"))) {
            LocalDateTime result = DateUtil.convertLocalDateTime(dt);
            if (result == null) {
                return null;
            }
            if (fmtUpper.startsWith("YY")) {
                return DateTimeFormatter.ofPattern(format).format(result);
            }
            if (fmtUpper.startsWith("HH")) {
                return DateTimeFormatter.ofPattern(format).format(result.toLocalTime());
            }
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(format) : new SimpleDateFormat(format, locale);
        java.util.Date tmp = DateUtil.convertDateObject(dt, null, locale);
        return null == tmp ? null : df.format(tmp);
    }

    @Deprecated
    public static String formatDate(Object dt, String format, String targetFormat, Locale locale) {
        java.util.Date result = DateUtil.parse(dt, format, locale);
        return DateUtil.formatDate(result, targetFormat);
    }

    public static Date getSqlDate(Object date) {
        return new Date(DateUtil.convertDateObject(date == null ? new java.util.Date() : date).getTime());
    }

    public static Timestamp getTimestamp(Object date) {
        return new Timestamp(date == null ? System.currentTimeMillis() : DateUtil.convertDateObject(date).getTime());
    }

    public static java.util.Date getNowTime() {
        return Calendar.getInstance().getTime();
    }

    public static LocalDate getDate() {
        return LocalDate.now();
    }

    public static LocalDate getDate(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof LocalDate) {
            return (LocalDate)date;
        }
        if (date instanceof LocalDateTime) {
            return ((LocalDateTime)date).toLocalDate();
        }
        return DateUtil.asLocalDate(DateUtil.convertDateObject(date));
    }

    public static LocalDateTime getDateTime() {
        return LocalDateTime.now();
    }

    public static LocalDateTime getDateTime(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof LocalDateTime) {
            return (LocalDateTime)date;
        }
        return DateUtil.asLocalDateTime(DateUtil.convertDateObject(date));
    }

    public static LocalTime getTime() {
        return LocalTime.now();
    }

    public static java.util.Date addMilliSecond(Object dt, long millisecond) {
        java.util.Date result = DateUtil.convertDateObject(dt);
        if (millisecond != 0L) {
            result.setTime(result.getTime() + millisecond);
        }
        return result;
    }

    public static java.util.Date addSecond(Object dt, double second) {
        Double millisecond = 1000.0 * second;
        return DateUtil.addMilliSecond(dt, millisecond.longValue());
    }

    public static java.util.Date addDay(Object dt, long day) {
        return DateUtil.addMilliSecond(dt, 86400000L * day);
    }

    public static java.util.Date addDay(Object dt, double day) {
        Double millisecond = 8.64E7 * day;
        return DateUtil.addMilliSecond(dt, millisecond.longValue());
    }

    public static java.util.Date addMonth(Object dt, int month) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(DateUtil.convertDateObject(dt));
        gc.add(2, month);
        return gc.getTime();
    }

    public static java.util.Date addYear(Object dt, int year) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(DateUtil.convertDateObject(dt));
        gc.add(1, year);
        return gc.getTime();
    }

    public static int getYear(Object dateValue) {
        if (dateValue == null) {
            return LocalDate.now().getYear();
        }
        return DateUtil.convertLocalDateTime(dateValue).getYear();
    }

    public static int getMonth(Object dateValue) {
        if (dateValue == null) {
            return LocalDate.now().getMonthValue();
        }
        return DateUtil.convertLocalDateTime(dateValue).getMonthValue();
    }

    @Deprecated
    public static int getDay(Object dateValue) {
        return DateUtil.getDayOfMonth(dateValue);
    }

    public static int getDayOfMonth(Object dateValue) {
        if (dateValue == null) {
            return LocalDate.now().getDayOfMonth();
        }
        return DateUtil.convertLocalDateTime(dateValue).getDayOfMonth();
    }

    public static int getDayOfWeek(Object dateValue) {
        if (dateValue == null) {
            return LocalDate.now().getDayOfWeek().getValue();
        }
        return DateUtil.convertLocalDateTime(dateValue).getDayOfWeek().getValue();
    }

    public static int getIntervalMonths(Object floorDate, Object goalDate) {
        LocalDateTime date1 = DateUtil.convertLocalDateTime(goalDate);
        LocalDateTime date2 = DateUtil.convertLocalDateTime(floorDate);
        return date1.getYear() * 12 + date1.getMonthValue() - date2.getYear() * 12 - date2.getMonthValue();
    }

    public static int getIntervalYears(Object floorDate, Object goalDate) {
        return DateUtil.convertLocalDateTime(goalDate).getYear() - DateUtil.convertLocalDateTime(floorDate).getYear();
    }

    public static int getIntervalDays(Object floorDate, Object goalDate) {
        BigDecimal result = new BigDecimal(Double.valueOf(DateUtil.getIntervalMillSeconds(DateUtil.formatDate(floorDate, "yyyy-MM-dd"), DateUtil.formatDate(goalDate, "yyyy-MM-dd"))) / 8.64E7);
        return result.setScale(1, RoundingMode.HALF_UP).intValue();
    }

    public static double getIntervalHours(Object floorDate, Object goalDate) {
        BigDecimal result = new BigDecimal(Double.valueOf(DateUtil.getIntervalMillSeconds(floorDate, goalDate)) / 3600000.0);
        return result.setScale(1, RoundingMode.HALF_UP).doubleValue();
    }

    public static double getIntervalMinutes(Object floorDate, Object goalDate) {
        BigDecimal result = new BigDecimal(Double.valueOf(DateUtil.getIntervalMillSeconds(floorDate, goalDate)) / 60000.0);
        return result.setScale(1, RoundingMode.HALF_UP).doubleValue();
    }

    public static double getIntervalSeconds(Object floorDate, Object goalDate) {
        return Double.valueOf(DateUtil.getIntervalMillSeconds(floorDate, goalDate)) / 1000.0;
    }

    public static long getIntervalMillSeconds(Object floorDate, Object goalDate) {
        return DateUtil.convertDateObject(goalDate).getTime() - DateUtil.convertDateObject(floorDate).getTime();
    }

    public static String format2China(Object dateValue) {
        java.util.Date date = DateUtil.convertDateObject(dateValue);
        if (null == date) {
            return null;
        }
        GregorianCalendar pointDate = new GregorianCalendar();
        pointDate.setTime(date);
        StringBuilder result = new StringBuilder();
        if (dateValue instanceof String) {
            String tmpDate = (String)dateValue;
            if (tmpDate.length() >= 4) {
                result.append(pointDate.get(1) + "\u5e74");
            }
            if (tmpDate.length() >= 6) {
                result.append(pointDate.get(2) + 1 + "\u6708");
            }
            if (tmpDate.length() >= 8) {
                result.append(pointDate.get(5) + "\u65e5");
            }
            if (tmpDate.length() > 10) {
                result.append(pointDate.get(11) + "\u65f6");
                result.append(pointDate.get(12) + "\u5206");
                result.append(pointDate.get(13) + "\u79d2");
            }
        } else {
            result.append(pointDate.get(1) + "\u5e74");
            result.append(pointDate.get(2) + 1 + "\u6708");
            result.append(pointDate.get(5) + "\u65e5");
            result.append(pointDate.get(11) + "\u65f6");
            result.append(pointDate.get(12) + "\u5206");
            result.append(pointDate.get(13) + "\u79d2");
        }
        return result.toString();
    }

    public static String parseChinaDate(String chinaDate, String format) {
        if (StringUtil.isBlank(chinaDate)) {
            return null;
        }
        String tmp = chinaDate.replaceAll("\\s+", "");
        Matcher matcher = MORE_TEN_PATTERN.matcher(tmp);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            String groupStr = matcher.group();
            if (groupStr.length() == 3) {
                map.put(groupStr, groupStr.replace("\u5341", ""));
                continue;
            }
            if (groupStr.length() != 2) continue;
            map.put(groupStr, groupStr.replace("\u5341", "1"));
        }
        for (Map.Entry entry : map.entrySet()) {
            tmp = tmp.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        for (int i = 0; i < CHINA_DATE_KEYS.length; ++i) {
            tmp = tmp.replaceAll(CHINA_DATE_KEYS[i], CHINA_DATE_KEY_MAP[i]);
        }
        if ((tmp = tmp.replace("\u6574", "").trim()).endsWith("-") || tmp.endsWith(":")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (StringUtil.isBlank(format)) {
            return tmp.toString();
        }
        return DateUtil.formatDate(tmp, format);
    }

    public static String parseChinaDate(String chinaDate) {
        return DateUtil.parseChinaDate(chinaDate, null);
    }

    public static java.util.Date firstDayOfMonth(Object objectDate) {
        java.util.Date date = DateUtil.convertDateObject(objectDate);
        if (null == date) {
            return null;
        }
        String tmp = DateUtil.formatDate(date, "yyyy-MM-dd");
        return DateUtil.parse(tmp, "yyyy-MM");
    }

    public static java.util.Date lastDayOfMonth(Object objectDate) {
        java.util.Date date = DateUtil.convertDateObject(objectDate);
        if (null == date) {
            return null;
        }
        String tmp = DateUtil.formatDate(date, "yyyy-MM-dd");
        java.util.Date result = DateUtil.parse(tmp, "yyyy-MM");
        result = DateUtil.addMonth(result, 1);
        result = DateUtil.addDay((Object)result, -1L);
        return result;
    }

    public static java.util.Date asDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return java.util.Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static java.util.Date asSqlDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return java.util.Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static java.util.Date asDate(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.now(), localTime);
        return java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Time asTime(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        return Time.valueOf(localTime);
    }

    public static java.util.Date asDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime asLocalTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalTime();
    }

    public static LocalDateTime asLocalDateTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private static java.util.Date parseEnglishDate(String dateStr, Locale locale) {
        int i;
        dateStr = dateStr.replace(",", " ");
        dateStr = dateStr.replace(". ", " ");
        Matcher dotMatcher = TIME_DOT_PATTERN.matcher(dateStr);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        while (dotMatcher.find()) {
            indexList.add(dotMatcher.start() + 1);
        }
        if (!indexList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(dateStr);
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                stringBuilder.deleteCharAt(index);
                stringBuilder.insert(index, ":");
            }
            dateStr = stringBuilder.toString();
        }
        for (i = 0; i < 12; ++i) {
            dateStr = dateStr.replaceFirst("(?i)" + MONTH_ENGLISH_NAME[i], MONTH_ENGLISH_NAKE[i]);
        }
        dateStr = dateStr.replaceFirst("(?i)Sept\\s", "Sep ");
        dateStr = dateStr.replaceFirst("(?i)Thur\\s", "Thu ").replaceFirst("(?i)Tues\\s", "Tue ");
        for (i = 0; i < 7; ++i) {
            dateStr = dateStr.replaceFirst("(?i)" + WEEK_ENGLISH_NAME[i], WEEK_ENGLISH_NAKE[i]);
        }
        Matcher daythMatcher = DAYTH_PATTERN.matcher(dateStr = " ".concat(dateStr));
        if (daythMatcher.find()) {
            String groupString = daythMatcher.group();
            groupString = groupString.substring(0, groupString.length() - 3);
            dateStr = dateStr.substring(0, daythMatcher.start()).concat(groupString).concat(dateStr.substring(daythMatcher.end() - 1));
        }
        int monthIndex = StringUtil.matchIndex(dateStr, MONTH_PATTERN);
        int dayIndex = StringUtil.matchIndex(dateStr, DAY_PATTERN);
        if (monthIndex != 1 && dayIndex != -1 && dayIndex < monthIndex) {
            Matcher mothMatcher;
            Matcher dayMatcher = DAY_PATTERN.matcher(dateStr);
            String dayStr = "";
            if (dayMatcher.find()) {
                dateStr = dateStr.substring(0, dayMatcher.start()).concat(dateStr.substring(dayMatcher.end() - 1));
                dayStr = dayMatcher.group().trim();
            }
            if ((mothMatcher = MONTH_PATTERN.matcher(dateStr)).find()) {
                dateStr = dateStr.substring(0, mothMatcher.end()).concat(dayStr).concat(dateStr.substring(mothMatcher.end() - 1));
            }
        }
        boolean hasWeek = StringUtil.matches(dateStr, WEEK_PATTERN);
        dateStr = dateStr.trim();
        SimpleDateFormat dateParser = null;
        Iterator<String> formatIter = StringUtil.matches(dateStr, TIME_PATTERN) ? (hasWeek ? DEFAULT_WEEK_TIME_PATTERNS.iterator() : DEFAULT_TIME_PATTERNS.iterator()) : (hasWeek ? DEFAULT_WEEK_DAY_PATTERNS.iterator() : DEFAULT_DAY_PATTERNS.iterator());
        java.util.Date result = null;
        while (formatIter.hasNext()) {
            String format = formatIter.next();
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(format, locale == null ? Locale.ENGLISH : locale);
            } else {
                dateParser.applyPattern(format);
            }
            try {
                result = dateParser.parse(dateStr);
                if (result == null) continue;
                break;
            }
            catch (ParseException parseException) {
            }
        }
        return result;
    }

    public static String processNano(int nanoTime) {
        if (nanoTime == 0) {
            return "";
        }
        String nanoStr = StringUtil.addLeftZero2Len("" + nanoTime, 9);
        if (nanoStr.endsWith("000000")) {
            nanoStr = nanoStr.substring(0, 3);
        } else if (nanoStr.endsWith("000")) {
            nanoStr = nanoStr.substring(0, 6);
        }
        return "." + nanoStr;
    }

    private static String addZero(String timeStr, int toLength) {
        return DateUtil.addZero(timeStr, timeStr.length(), toLength);
    }

    private static String addZero(String timeStr, int size, int toLength) {
        int addSize = toLength - size;
        if (addSize == 1) {
            return timeStr.concat("0");
        }
        if (addSize == 2) {
            return timeStr.concat("00");
        }
        if (addSize == 3) {
            return timeStr.concat("000");
        }
        return timeStr;
    }

    public static final class FORMAT {
        public static final String YEAR_MONTH = "yyyy-MM";
        public static final String DATE_6CHAR = "yyMMdd";
        public static final String DATE_8CHAR = "yyyyMMdd";
        public static final String DATE_DOT = "yyyy.MM.dd";
        public static final String DATE_SLASH = "yyyy/MM/dd";
        public static final String DATE_HORIZONTAL = "yyyy-MM-dd";
        public static final String DATETIME_DOT = "yyyy.MM.dd HH:mm:ss";
        public static final String DATETIME_SLASH = "yyyy/MM/dd HH:mm:ss";
        public static final String DATETIME_HORIZONTAL = "yyyy-MM-dd HH:mm:ss";
    }
}

