/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.sagacity.sqltoy.utils.IOUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putFileInOutStream(OutputStream out, Object fileName) {
        if (fileName == null || out == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File outFile = null;
        if (fileName instanceof String) {
            outFile = new File((String)fileName);
        } else if (fileName instanceof File) {
            outFile = (File)fileName;
        } else {
            throw new IllegalArgumentException("fileName\u53c2\u6570\u7c7b\u578b\u9519\u8bef,\u53ea\u63d0\u4f9bString and File\u4e24\u4e2a\u7c7b\u578b!");
        }
        FileInputStream fileIn = null;
        if (outFile.exists()) {
            try {
                int length;
                fileIn = new FileInputStream(outFile);
                byte[] buffer = new byte[1024];
                while ((length = fileIn.read(buffer)) != -1) {
                    out.write(buffer, 0, length);
                }
                out.flush();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(out, fileIn);
                    throw throwable;
                }
                IOUtil.closeQuietly(out, fileIn);
            }
            IOUtil.closeQuietly(out, fileIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putInputStreamToFile(InputStream is, String fileName) {
        FileOutputStream fos = null;
        try {
            int length;
            File writeFile = new File(fileName);
            FileUtil.createFolder(writeFile.getParent());
            fos = new FileOutputStream(writeFile);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                fos.write(buffer, 0, length);
            }
            fos.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fos, is);
                throw throwable;
            }
            IOUtil.closeQuietly(fos, is);
        }
        IOUtil.closeQuietly(fos, is);
    }

    public static InputStream putFileToInputStream(String fileName) throws Exception {
        return new FileInputStream(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putBytesToFile(byte[] bytes, String fileName) {
        FileOutputStream fos = null;
        try {
            File writeFile = new File(fileName);
            FileUtil.createFolder(writeFile.getParent());
            fos = new FileOutputStream(writeFile);
            fos.write(bytes);
            fos.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fos);
                throw throwable;
            }
            IOUtil.closeQuietly(fos);
        }
        IOUtil.closeQuietly(fos);
    }

    public static String readFileAsStr(File file, String charset) throws IOException {
        byte[] fileBytes = FileUtil.readAsBytes(file);
        if (StringUtil.isBlank(charset)) {
            return new String(fileBytes);
        }
        return new String(fileBytes, charset);
    }

    public static String readFileAsStr(Object file, String charset) {
        return FileUtil.inputStreamToStr(FileUtil.getFileInputStream(file), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStreamToStr(InputStream is, String encoding) {
        if (null == is) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        BufferedReader in = null;
        try {
            in = StringUtil.isNotBlank(encoding) ? new BufferedReader(new InputStreamReader(is, encoding)) : new BufferedReader(new InputStreamReader(is));
            String line = "";
            int meter = 0;
            while ((line = in.readLine()) != null) {
                if (meter > 0) {
                    buffer.append("\n");
                }
                buffer.append(line);
                ++meter;
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                throw throwable;
            }
            IOUtil.closeQuietly(in);
        }
        IOUtil.closeQuietly(in);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLineAsStr(File file, String charset) {
        BufferedReader reader = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            reader = StringUtil.isBlank(charset) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            int meter = 0;
            while ((line = reader.readLine()) != null) {
                if (meter > 0) {
                    result.append("\n");
                }
                result.append(line);
                ++meter;
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(reader);
                throw throwable;
            }
            IOUtil.closeQuietly(reader);
        }
        IOUtil.closeQuietly(reader);
        return result.toString();
    }

    public static InputStream getFileInputStream(Object file) {
        if (file == null) {
            return null;
        }
        try {
            InputStream result;
            if (file instanceof InputStream) {
                return (InputStream)file;
            }
            if (file instanceof File) {
                return new FileInputStream((File)file);
            }
            String realFile = (String)file;
            if (new File(realFile).exists()) {
                return new FileInputStream(realFile);
            }
            if (StringUtil.indexOfIgnoreCase(realFile.trim(), "classpath:") == 0) {
                realFile = realFile.trim().substring(10).trim();
            }
            if (realFile.length() > 0 && realFile.charAt(0) == '/') {
                realFile = realFile.substring(1);
            }
            if ((result = Thread.currentThread().getContextClassLoader().getResourceAsStream(realFile)) == null) {
                try {
                    URL url;
                    Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(realFile);
                    while (urls.hasMoreElements() && (result = new FileInputStream((url = urls.nextElement()).getFile())) == null) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
        catch (FileNotFoundException fn) {
            fn.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existFile(Object file) throws IOException {
        if (file == null) {
            return false;
        }
        if (file instanceof InputStream) {
            return true;
        }
        if (file instanceof File) {
            return ((File)file).exists();
        }
        String realFile = (String)file;
        if (new File(realFile).exists()) {
            return true;
        }
        try (InputStream result = null;){
            if (StringUtil.indexOfIgnoreCase(realFile.trim(), "classpath:") == 0) {
                realFile = realFile.trim().substring(10).trim();
            }
            if (realFile.length() > 0 && realFile.charAt(0) == '/') {
                realFile = realFile.substring(1);
            }
            if ((result = Thread.currentThread().getContextClassLoader().getResourceAsStream(realFile)) == null) {
                URL url;
                Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(realFile);
                while (urls.hasMoreElements() && (result = new FileInputStream((url = urls.nextElement()).getFile())) == null) {
                }
            }
            if (result != null) {
                boolean urls = true;
                return urls;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAsBytes(Object file) {
        if (file == null) {
            return null;
        }
        InputStream in = null;
        byte[] ret = null;
        try {
            in = FileUtil.getFileInputStream(file);
            ret = IOUtil.getBytes(in);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                throw throwable;
            }
            IOUtil.closeQuietly(in);
        }
        IOUtil.closeQuietly(in);
        return ret;
    }

    public static void putStrToFile(String content, String fileName, String charset) throws Exception {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter writer = null;
        try {
            File writeFile = new File(fileName);
            FileUtil.createFolder(writeFile.getParent());
            fos = new FileOutputStream(writeFile);
            osw = charset != null ? new OutputStreamWriter((OutputStream)fos, charset) : new OutputStreamWriter(fos);
            writer = new BufferedWriter(osw);
            writer.write(content);
            writer.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(writer, osw, fos);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(writer, osw, fos);
    }

    public static void getPathFiles(File parentFile, List fileList, String[] filters) {
        if (parentFile == null || !parentFile.exists()) {
            return;
        }
        if (parentFile.isDirectory()) {
            File[] files = parentFile.listFiles();
            for (int loop = 0; loop < files.length; ++loop) {
                if (!files[loop].isDirectory()) {
                    FileUtil.matchFilters(fileList, files[loop], filters);
                    continue;
                }
                FileUtil.getPathFiles(files[loop], fileList, filters);
            }
        } else {
            FileUtil.matchFilters(fileList, parentFile, filters);
        }
    }

    public static List getPathFiles(Object baseDir, String[] filters) {
        if (baseDir == null) {
            return null;
        }
        ArrayList fileList = new ArrayList();
        File file = baseDir instanceof String ? FileUtil.getFile((String)baseDir) : (File)baseDir;
        FileUtil.getPathFiles(file, fileList, filters);
        return fileList;
    }

    public static boolean isRootPath(String path) {
        return System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") == -1 ? path.indexOf("/") == 0 : StringUtil.matches(path, "^[a-zA-Z]+:\\w*");
    }

    private static void matchFilters(List fileList, File file, String[] filters) {
        if (filters == null || filters.length == 0) {
            fileList.add(file);
        } else {
            for (int i = 0; i < filters.length; ++i) {
                if (!StringUtil.matches(file.getName(), filters[i])) continue;
                fileList.add(file);
                break;
            }
        }
    }

    public static void createFolder(String folderPath) {
        try {
            File tmpFile = new File(folderPath);
            if (!tmpFile.exists()) {
                tmpFile.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u521b\u5efa\u76ee\u5f55:{}\u64cd\u4f5c\u51fa\u9519{}", (Object)folderPath, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(String filePathAndName, String fileContent) {
        PrintWriter myFile;
        FileWriter resultFile;
        block7: {
            resultFile = null;
            myFile = null;
            try {
                File myFilePath = new File(filePathAndName);
                if (!myFilePath.exists()) {
                    if (!myFilePath.getParentFile().exists()) {
                        myFilePath.getParentFile().mkdirs();
                    }
                    if (fileContent == null) {
                        myFilePath.createNewFile();
                    }
                }
                if (fileContent == null) break block7;
                resultFile = new FileWriter(myFilePath);
                myFile = new PrintWriter(resultFile);
                myFile.println(fileContent);
            }
            catch (Exception e) {
                try {
                    logger.error("\u521b\u5efa\u6587\u4ef6:{},\u64cd\u4f5c\u51fa\u9519{}", (Object)filePathAndName, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(myFile, resultFile);
                    throw throwable;
                }
                IOUtil.closeQuietly(myFile, resultFile);
            }
        }
        IOUtil.closeQuietly(myFile, resultFile);
    }

    public static boolean delFile(String filePathAndName) {
        boolean bea = false;
        try {
            File myDelFile = new File(filePathAndName);
            if (myDelFile.exists()) {
                myDelFile.delete();
                bea = true;
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u4ef6:{},\u64cd\u4f5c\u51fa\u9519{}", (Object)filePathAndName, (Object)e.getMessage());
        }
        return bea;
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            new File(folderPath).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean delAllFile(String path) {
        boolean result = false;
        File file = new File(path);
        if (!file.exists()) {
            return result;
        }
        if (!file.isDirectory()) {
            return result;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            if (path.endsWith(File.separator)) {
                FileUtil.delAllFile(path + tempList[i]);
                FileUtil.delFolder(path + tempList[i]);
            } else {
                FileUtil.delAllFile(path + File.separator + tempList[i]);
                FileUtil.delFolder(path + File.separator + tempList[i]);
            }
            result = true;
        }
        return result;
    }

    public static boolean deleteMatchedFile(Object path, String[] regex) {
        List matchedFile = FileUtil.getPathFiles(path, regex);
        if (matchedFile != null && !matchedFile.isEmpty()) {
            logger.debug("\u5c06\u5220\u9664\u7684\u6587\u4ef6\u6570\u91cf\u5171\u8ba1:{}\u4e2a!", (Object)matchedFile.size());
            Iterator iter = matchedFile.iterator();
            while (iter.hasNext()) {
                ((File)iter.next()).delete();
            }
        }
        return true;
    }

    public static boolean copyFile(String oldPathFile, String newPathFile) {
        File oldfile = new File(oldPathFile);
        return FileUtil.copyFile(oldfile, newPathFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean copyFile(File oldPathFile, String newPathFile) {
        boolean bl;
        FileOutputStream fs;
        FileInputStream inStream;
        block6: {
            inStream = null;
            fs = null;
            newPathFile = FileUtil.formatPath(newPathFile);
            File newFile = new File(newPathFile);
            FileUtil.createFolder(newFile.getParent());
            if (!oldPathFile.exists()) break block6;
            inStream = new FileInputStream(oldPathFile);
            fs = new FileOutputStream(newFile);
            byte[] buffer = new byte[1024];
            int byteread = 0;
            while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
            fs.flush();
            boolean bl2 = true;
            IOUtil.closeQuietly(fs, inStream);
            return bl2;
        }
        try {
            logger.error("\u6587\u4ef6=" + oldPathFile + "\u4e0d\u5b58\u5728!\u8ba1\u5212\u6539\u540d\u5bf9\u5e94\u7684\u6587\u4ef6\u4e3a=" + newPathFile);
            bl = false;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                logger.error("\u590d\u5236\u6587\u4ef6:" + oldPathFile + " \u5230\u76ee\u6807\u6587\u4ef6:" + newPathFile + " \u64cd\u4f5c\u5931\u8d25!");
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fs, inStream);
                throw throwable;
            }
            IOUtil.closeQuietly(fs, inStream);
            return false;
        }
        IOUtil.closeQuietly(fs, inStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFolder(String oldPath, String newPath) {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            FileUtil.createFolder(newPath);
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    input = new FileInputStream(temp);
                    output = new FileOutputStream(newPath + File.separator + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copyFolder(oldPath + File.separator + file[i], newPath + File.separator + file[i]);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                logger.error("\u590d\u5236\u6574\u4e2a\u6587\u4ef6\u5939,\u4ece\u6587\u4ef6\u5939:{} \u5230\u6587\u4ef6\u5939:{},\u64cd\u4f5c\u51fa\u9519{}", new Object[]{oldPath, newPath, e.getMessage()});
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(output, input);
                throw throwable;
            }
            IOUtil.closeQuietly(output, input);
        }
        IOUtil.closeQuietly(output, input);
    }

    public static void moveFile(String oldPath, String newPath, boolean deleteOldFile) {
        FileUtil.copyFile(oldPath, newPath);
        if (deleteOldFile) {
            FileUtil.delFile(oldPath);
        }
    }

    public static void moveFolder(String oldPath, String newPath) {
        FileUtil.copyFolder(oldPath, newPath);
        FileUtil.delFolder(oldPath);
    }

    public static synchronized int rename(Object fileName, String distFile) {
        File oldFile = fileName instanceof String ? new File((String)fileName) : (File)fileName;
        if (oldFile.exists()) {
            try {
                oldFile.renameTo(new File(distFile));
                return 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMessageDigest(String fileName, String digestType) {
        MessageDigest md;
        DigestInputStream din;
        FileInputStream fin;
        String result;
        block7: {
            result = "";
            fin = null;
            din = null;
            md = MessageDigest.getInstance(digestType);
            fin = new FileInputStream(fileName);
            if (fin.available() != 0) break block7;
            String string = "";
            IOUtil.closeQuietly(din, fin);
            return string;
        }
        try {
            din = new DigestInputStream(fin, md);
            while (din.read() != -1) {
            }
            byte[] re = md.digest();
            for (int i = 0; i < re.length; ++i) {
                result = result + Integer.toHexString(0xFF & re[i] | 0xFFFFFF00).substring(6);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(din, fin);
                throw throwable;
            }
            IOUtil.closeQuietly(din, fin);
        }
        IOUtil.closeQuietly(din, fin);
        return result;
    }

    public static String linkPath(String topPath, String lowPath) {
        if (lowPath != null && FileUtil.isRootPath(lowPath)) {
            return lowPath;
        }
        String firstPath = "";
        String secondPath = "";
        if (StringUtil.isNotBlank(topPath)) {
            firstPath = topPath;
        }
        if (StringUtil.isNotBlank(lowPath)) {
            secondPath = lowPath;
        }
        if ("".equals(firstPath.concat(secondPath).trim())) {
            return "";
        }
        firstPath = !"".equals(firstPath) ? ("/".equals(firstPath.substring(firstPath.length() - 1)) || "\\".equals(firstPath.substring(firstPath.length() - 1)) ? firstPath.substring(0, firstPath.length() - 1) + File.separator : firstPath + File.separator) : firstPath + File.separator;
        if (!"".equals(secondPath) && ("/".equals(secondPath.substring(0, 1)) || "\\".equals(secondPath.substring(0, 1)))) {
            secondPath = secondPath.substring(1);
        }
        return firstPath.concat(secondPath);
    }

    public static String formatPath(String path) {
        path = StringUtil.replaceAllStr(path, "\\\\", File.separator);
        path = StringUtil.replaceAllStr(path, "\\", File.separator);
        path = StringUtil.replaceAllStr(path, "/", File.separator);
        return path;
    }

    public static File getFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        File result = null;
        if (fileName.trim().toLowerCase().startsWith("classpath:")) {
            URL url;
            String realPath = fileName.trim().substring(10).trim();
            if (realPath.length() > 0 && realPath.charAt(0) == '/') {
                realPath = realPath.substring(1);
            }
            if ((url = Thread.currentThread().getContextClassLoader().getResource(realPath)) != null && "file".equals(url.getProtocol())) {
                try {
                    result = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        } else {
            result = new File(fileName);
        }
        return result;
    }

    public static boolean isPackage(String file) {
        if (file.trim().startsWith("classpath:")) {
            return true;
        }
        if (FileUtil.isRootPath(file)) {
            return false;
        }
        return !new File(file).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFileByStream(Object fileName, String content) {
        BufferedWriter out = null;
        try {
            File appendFile = null;
            appendFile = fileName instanceof String ? new File((String)fileName) : (File)fileName;
            if (!appendFile.exists()) {
                appendFile.createNewFile();
            }
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(appendFile, true)));
            out.write(content);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
        }
        IOUtil.closeQuietly(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFileByWriter(Object fileName, String content) {
        FileWriter writer = null;
        try {
            File appendFile = null;
            appendFile = fileName instanceof String ? new File((String)fileName) : (File)fileName;
            if (!appendFile.exists()) {
                appendFile.createNewFile();
            }
            writer = new FileWriter(appendFile, true);
            writer.write(content);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(writer);
                throw throwable;
            }
            IOUtil.closeQuietly(writer);
        }
        IOUtil.closeQuietly(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFileByRandomAccess(Object fileName, String content) {
        RandomAccessFile randomFile = null;
        try {
            File appendFile = null;
            appendFile = fileName instanceof String ? new File((String)fileName) : (File)fileName;
            if (!appendFile.exists()) {
                appendFile.createNewFile();
            }
            randomFile = new RandomAccessFile(appendFile, "rw");
            long fileLength = randomFile.length();
            randomFile.seek(fileLength);
            randomFile.writeBytes(content);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(randomFile);
                throw throwable;
            }
            IOUtil.closeQuietly(randomFile);
        }
        IOUtil.closeQuietly(randomFile);
    }

    public static String getParentPath(String fileName) {
        if (fileName.lastIndexOf("/") != -1) {
            return fileName.substring(0, fileName.lastIndexOf("/"));
        }
        if (fileName.lastIndexOf("\\") != -1) {
            return fileName.substring(0, fileName.lastIndexOf("\\"));
        }
        return null;
    }

    public static String skipPath(String basePath, String skipFile) {
        String lastFile;
        String realFile = FileUtil.formatPath(skipFile).trim();
        if (realFile.indexOf("." + File.separator) == 0) {
            realFile = realFile.substring(2);
        }
        String pattern = ".." + File.separator;
        int index = realFile.indexOf(pattern);
        File tmpFile = new File(basePath);
        String string = lastFile = index != 0 ? tmpFile.getPath() : null;
        while (index == 0) {
            lastFile = tmpFile.getParent();
            tmpFile = tmpFile.getParentFile();
            realFile = realFile.substring(3);
            index = realFile.indexOf(pattern);
        }
        return FileUtil.linkPath(lastFile, realFile);
    }
}

