/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.config.model.NoSqlConfigModel;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(30000).setConnectTimeout(10000).setSocketTimeout(180000).build();
    protected static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final String CHARSET = "UTF-8";
    private static final String SEARCH = "_search";
    private static final String CONTENT_TYPE = "application/json";
    private static final String POST = "POST";

    private HttpClientUtils() {
    }

    public static String doPost(SqlToyContext sqltoyContext, String url, String username, String password, String[] paramName, String[] paramValue) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Connection", "close");
        httpPost.setConfig(requestConfig);
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            HttpEntity reponseEntity;
            if (StringUtil.isNotBlank(username) && StringUtil.isNotBlank(password)) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            } else {
                client = HttpClients.createDefault();
            }
            if (paramValue != null && paramValue.length > 0) {
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (int i = 0; i < paramValue.length; ++i) {
                    if (paramValue[i] == null) continue;
                    nvps.add(new BasicNameValuePair(paramName[i], paramValue[i]));
                }
                UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nvps, CHARSET);
                httpEntity.setContentType(CONTENT_TYPE);
                httpPost.setEntity((HttpEntity)httpEntity);
            }
            if ((reponseEntity = (response = client.execute((HttpUriRequest)httpPost)).getEntity()) != null) {
                String string = EntityUtils.toString((HttpEntity)reponseEntity, (String)CHARSET);
                return string;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static JSONObject doPost(SqlToyContext sqltoyContext, NoSqlConfigModel nosqlConfig, ElasticEndpoint esConfig, Object postValue) throws Exception {
        if (esConfig.getUrl() == null) {
            throw new IllegalArgumentException("\u8bf7\u6b63\u786e\u914d\u7f6esqltoyContext elasticConfigs \u6307\u5b9aes\u7684\u670d\u52a1\u5730\u5740!");
        }
        charset = nosqlConfig.getCharset() == null ? "UTF-8" : nosqlConfig.getCharset();
        httpEntity = null;
        if (nosqlConfig.isSqlMode()) {
            if (esConfig.isNativeSql()) {
                map = new HashMap<String, String>();
                map.put("query", postValue.toString());
                httpEntity = new StringEntity(JSON.toJSONString(map), charset);
            } else {
                httpEntity = new StringEntity(postValue.toString(), charset);
            }
        } else {
            httpEntity = new StringEntity(JSON.toJSONString((Object)postValue), charset);
        }
        httpEntity.setContentEncoding(charset);
        httpEntity.setContentType("application/json");
        reponseEntity = null;
        result = null;
        if (esConfig.getRestClient() != null) {
            realUrl = HttpClientUtils.wrapUrl(esConfig, nosqlConfig);
            if (sqltoyContext.isDebug()) {
                HttpClientUtils.logger.debug("esRestClient\u6267\u884c:URL=[{}],Path={},\u6267\u884c\u7684JSON=[{}]", new Object[]{esConfig.getUrl(), realUrl, JSON.toJSONString((Object)postValue)});
            }
            restClient = null;
            try {
                restClient = esConfig.getRestClient();
                request = new Request("POST", realUrl);
                request.setEntity((HttpEntity)httpEntity);
                response = restClient.performRequest(request);
                reponseEntity = response.getEntity();
                if (reponseEntity == null) ** GOTO lbl77
                result = EntityUtils.toString((HttpEntity)reponseEntity, (String)nosqlConfig.getCharset());
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    if (restClient != null) {
                        restClient.close();
                    }
                }
                catch (Exception var13_19) {}
            }
        } else {
            realUrl = HttpClientUtils.wrapUrl(esConfig, nosqlConfig);
            httpPost = new HttpPost(realUrl);
            if (sqltoyContext.isDebug()) {
                HttpClientUtils.logger.debug("httpClient\u6267\u884cURL=[{}],\u6267\u884c\u7684JSON=[{}]", (Object)realUrl, (Object)JSON.toJSONString((Object)postValue));
            }
            httpPost.setEntity((HttpEntity)httpEntity);
            httpPost.setHeader("Connection", "close");
            if (nosqlConfig.getRequestTimeout() != 30000 || nosqlConfig.getConnectTimeout() != 10000 || nosqlConfig.getSocketTimeout() != 180000) {
                httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(nosqlConfig.getRequestTimeout()).setConnectTimeout(nosqlConfig.getConnectTimeout()).setSocketTimeout(nosqlConfig.getSocketTimeout()).build());
            } else {
                httpPost.setConfig(HttpClientUtils.requestConfig);
            }
            client = null;
            response = null;
            try {
                if (StringUtil.isNotBlank(esConfig.getUsername()) && StringUtil.isNotBlank(esConfig.getPassword())) {
                    credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
                    client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                } else {
                    client = HttpClients.createDefault();
                }
                response = client.execute((HttpUriRequest)httpPost);
                reponseEntity = response.getEntity();
                if (reponseEntity != null) {
                    result = EntityUtils.toString((HttpEntity)reponseEntity, (String)nosqlConfig.getCharset());
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (Exception var15_21) {}
            }
        }
        if (StringUtil.isBlank(result)) {
            return null;
        }
        if (sqltoyContext.isDebug()) {
            HttpClientUtils.logger.debug("result={}", (Object)result);
        }
        if ((json = JSON.parseObject((String)result)).containsKey("error")) {
            errorMessage = JSON.toJSONString((Object)json.getJSONObject("error").getJSONArray("root_cause").get(0));
            HttpClientUtils.logger.error("elastic\u67e5\u8be2\u5931\u8d25,endpoint:[{}],\u9519\u8bef\u4fe1\u606f:[{}]", (Object)nosqlConfig.getEndpoint(), (Object)errorMessage);
            throw new DataAccessException("ElasticSearch\u67e5\u8be2\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:" + errorMessage);
        }
        return json;
    }

    private static String wrapUrl(ElasticEndpoint esConfig, NoSqlConfigModel nosqlConfig) {
        String url = esConfig.getUrl();
        String sqlPath = esConfig.getSqlPath();
        if (StringUtil.isBlank(sqlPath)) {
            sqlPath = "_sql";
        }
        if (nosqlConfig.isSqlMode()) {
            if (!url.toLowerCase().contains(sqlPath)) {
                url = url.concat(url.endsWith("/") ? "" : "/").concat(sqlPath);
            }
        } else {
            if (StringUtil.isNotBlank(nosqlConfig.getIndex())) {
                url = url.concat(url.endsWith("/") ? "" : "/").concat(nosqlConfig.getIndex());
            }
            if (StringUtil.isNotBlank(nosqlConfig.getType())) {
                url = url.concat(url.endsWith("/") ? "" : "/").concat(nosqlConfig.getType());
            }
            if (!url.toLowerCase().endsWith(SEARCH)) {
                url = url.concat(url.endsWith("/") ? "" : "/").concat(SEARCH);
            }
        }
        return url;
    }
}

