/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class MacroIfLogic {
    private static final String BLANK = " ";

    private MacroIfLogic() {
    }

    public static boolean evalLogic(String evalExpression, List paramValues, int preCount, int logicParamCnt, int sqlParamType) {
        for (int i = 0; i < logicParamCnt; ++i) {
            Object value = paramValues.get(preCount + i);
            if (value == null || (!value.getClass().isArray() || CollectionUtil.convertArray(value).length != 0) && (!(value instanceof Collection) || !((Collection)value).isEmpty())) continue;
            return false;
        }
        String simpleResult = MacroIfLogic.evalSimpleExpress(evalExpression = evalExpression.replaceAll("\\<\\>", "!=").replaceAll("\r|\t|\n", BLANK).trim(), logicParamCnt == 0 ? null : paramValues, preCount, sqlParamType);
        if (!"undefine".equals(simpleResult)) {
            return Boolean.parseBoolean(simpleResult);
        }
        return true;
    }

    private static String evalSimpleExpress(String evalExpression, List paramValues, int preCount, int sqlParamType) {
        if (evalExpression.indexOf("||") != -1 && evalExpression.indexOf("&&") != -1) {
            return "undefine";
        }
        String[] compareStr = new String[]{"!=", "==", ">=", "<=", ">", "<", "=", " include ", " exclude ", " in ", " out ", " startswith ", " endswith "};
        String[] splitReg = new String[]{"\\!\\=", "\\=\\=", "\\>\\=", "\\<\\=", "\\>", "\\<", "\\=", "\\s+include\\s+", "\\s+exclude\\s+", "\\s+in\\s+", "\\s+out\\s+", "\\s+startswith\\s+", "\\s+endswith\\s+"};
        String splitStr = "==";
        String logicStr = "\\&\\&";
        try {
            int i;
            if (evalExpression.indexOf("||") != -1) {
                logicStr = "\\|\\|";
            }
            String[] expressions = evalExpression.split(logicStr);
            boolean[] expressResult = new boolean[expressions.length];
            String compareType = "==";
            int meter = 0;
            boolean hasArg = true;
            boolean isNegate = false;
            for (i = 0; i < expressions.length; ++i) {
                Object leftValue;
                hasArg = false;
                String express = expressions[i].trim();
                String expressLow = express.toLowerCase();
                for (int j = 0; j < compareStr.length; ++j) {
                    if (expressLow.indexOf(compareStr[j]) == -1) continue;
                    compareType = compareStr[j].trim();
                    splitStr = splitReg[j];
                    break;
                }
                String[] params = express.split(splitStr);
                String leftParamLow = params[0].trim().toLowerCase();
                if (paramValues != null) {
                    hasArg = MacroIfLogic.hasArg(leftParamLow, sqlParamType);
                }
                isNegate = false;
                if (hasArg) {
                    leftValue = paramValues.get(preCount + meter);
                    if (leftValue != null && leftValue instanceof Enum) {
                        leftValue = BeanUtil.getEnumValue(leftValue);
                    }
                    if (leftParamLow.startsWith("!")) {
                        isNegate = true;
                    }
                    ++meter;
                } else {
                    leftValue = params[0].trim();
                }
                String rightValue = params.length > 1 ? params[1].trim() : (isNegate ? "false" : "true");
                if (paramValues != null && MacroIfLogic.isArg(rightValue, sqlParamType)) {
                    Object rightObj = paramValues.get(preCount + meter);
                    rightValue = rightObj == null ? "null" : (rightObj instanceof Enum ? BeanUtil.getEnumValue(rightObj).toString() : rightObj.toString());
                    ++meter;
                }
                expressResult[i] = hasArg && (leftParamLow.startsWith("size(") || leftParamLow.startsWith("length(")) ? MacroIfLogic.compare(leftValue == null ? 0 : CollectionUtil.convertArray(leftValue).length, compareType, rightValue) : MacroIfLogic.compare(leftValue, compareType, rightValue);
            }
            if ("\\&\\&".equals(logicStr) || "&&".equals(logicStr)) {
                for (i = 0; i < expressions.length; ++i) {
                    if (expressResult[i]) continue;
                    return "false";
                }
                return "true";
            }
            for (i = 0; i < expressions.length; ++i) {
                if (!expressResult[i]) continue;
                return "true";
            }
            return "false";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "undefine";
        }
    }

    public static boolean compare(Object value, String compareType, String compareValue) {
        String[] compareValues;
        String valueStr;
        String[] calculateStr;
        compareValue = MacroIfLogic.removeStartEndQuote(compareValue);
        String append = "0";
        for (String calculate : calculateStr = new String[]{"+", "-"}) {
            if (compareValue.trim().indexOf(calculate) <= 0) continue;
            String[] tmpAry = compareValue.split("+".equals(calculate) ? "\\+" : "\\-");
            append = calculate + tmpAry[1].trim();
            compareValue = tmpAry[0].trim();
            break;
        }
        String type = "string";
        String dayTimeFmt = "yyyy-MM-dd HH:mm:ss";
        String dayFmt = "yyyy-MM-dd";
        String lowCompareValue = compareValue.toLowerCase();
        if ("now()".equals(lowCompareValue) || ".now".equals(lowCompareValue) || "${.now}".equals(lowCompareValue) || "nowtime()".equals(lowCompareValue)) {
            compareValue = DateUtil.formatDate(DateUtil.addSecond(new Date(), Double.parseDouble(append)), dayTimeFmt);
            type = "time";
        } else if ("day()".equals(lowCompareValue) || "sysdate()".equals(lowCompareValue) || ".day".equals(lowCompareValue) || ".day()".equals(lowCompareValue) || "${.day}".equals(lowCompareValue)) {
            compareValue = DateUtil.formatDate(DateUtil.addSecond(new Date(), Double.parseDouble(append)), dayFmt);
            type = "date";
        }
        String string = valueStr = value == null ? "null" : MacroIfLogic.removeStartEndQuote(value.toString());
        if ("time".equals(type)) {
            valueStr = DateUtil.formatDate(value, dayTimeFmt);
        } else if ("date".equals(type)) {
            valueStr = DateUtil.formatDate(value, dayFmt);
        }
        if ("==".equals(compareType) || "=".equals(compareType)) {
            return valueStr.equalsIgnoreCase(compareValue);
        }
        if ("!=".equals(compareType)) {
            return !valueStr.equalsIgnoreCase(compareValue);
        }
        if (value == null) {
            return false;
        }
        if (">=".equals(compareType)) {
            return MacroIfLogic.moreEqual(value, valueStr, compareValue, type);
        }
        if ("<=".equals(compareType)) {
            return MacroIfLogic.lessEqual(value, valueStr, compareValue, type);
        }
        if (">".equals(compareType)) {
            return MacroIfLogic.more(value, valueStr, compareValue, type);
        }
        if ("<".equals(compareType)) {
            return MacroIfLogic.less(value, valueStr, compareValue, type);
        }
        if ("include".equals(compareType)) {
            return MacroIfLogic.include(value, valueStr, compareValue, type);
        }
        if ("exclude".equals(compareType)) {
            return !MacroIfLogic.include(value, valueStr, compareValue, type);
        }
        if ("in".equals(compareType)) {
            return MacroIfLogic.in(value, valueStr, compareValue, type);
        }
        if ("out".equals(compareType)) {
            return MacroIfLogic.out(value, valueStr, compareValue, type);
        }
        if ("startswith".equals(compareType)) {
            return valueStr.startsWith(compareValue);
        }
        if ("endswith".equals(compareType)) {
            return valueStr.endsWith(compareValue);
        }
        if ("between".equals(compareType) && (compareValues = compareValue.split("\\,")).length == 2) {
            return MacroIfLogic.between(value, valueStr, compareValues[0], compareValues[1]);
        }
        return true;
    }

    private static boolean moreEqual(Object value, String valueStr, String compare, String type) {
        if ("time".equals(type) || "date".equals(type)) {
            return DateUtil.convertDateObject(valueStr).compareTo(DateUtil.convertDateObject(compare)) >= 0;
        }
        if (NumberUtil.isNumber(valueStr) && NumberUtil.isNumber(compare)) {
            return Double.parseDouble(valueStr) >= Double.parseDouble(compare);
        }
        return valueStr.compareTo(compare) >= 0;
    }

    private static boolean lessEqual(Object value, String valueStr, String compare, String type) {
        if ("time".equals(type) || "date".equals(type)) {
            return DateUtil.convertDateObject(valueStr).compareTo(DateUtil.convertDateObject(compare)) <= 0;
        }
        if (NumberUtil.isNumber(valueStr) && NumberUtil.isNumber(compare)) {
            return Double.parseDouble(valueStr) <= Double.parseDouble(compare);
        }
        return valueStr.compareTo(compare) <= 0;
    }

    private static boolean more(Object value, String valueStr, String compare, String type) {
        if ("time".equals(type) || "date".equals(type)) {
            return DateUtil.convertDateObject(valueStr).compareTo(DateUtil.convertDateObject(compare)) > 0;
        }
        if (NumberUtil.isNumber(valueStr) && NumberUtil.isNumber(compare)) {
            return Double.parseDouble(valueStr) > Double.parseDouble(compare);
        }
        return valueStr.compareTo(compare) > 0;
    }

    private static boolean less(Object value, String valueStr, String compare, String type) {
        if ("time".equals(type) || "date".equals(type)) {
            return DateUtil.convertDateObject(valueStr).compareTo(DateUtil.convertDateObject(compare)) < 0;
        }
        if (NumberUtil.isNumber(valueStr) && NumberUtil.isNumber(compare)) {
            return Double.parseDouble(valueStr) < Double.parseDouble(compare);
        }
        return valueStr.compareTo(compare) < 0;
    }

    private static boolean include(Object value, String valueStr, String compare, String type) {
        if (value == null) {
            return false;
        }
        String compareLow = compare.toLowerCase();
        if (value instanceof String) {
            return valueStr.toLowerCase().contains(compareLow);
        }
        if (value.getClass().isArray()) {
            Object[] values;
            for (Object item : values = CollectionUtil.convertArray(value)) {
                if (!compareLow.equals(item == null ? null : item.toString().toLowerCase())) continue;
                return true;
            }
        }
        if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                if (!compareLow.equals(item == null ? null : item.toString().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean in(Object value, String valueStr, String compare, String type) {
        if (value == null) {
            return false;
        }
        String[] compareAry = compare.toLowerCase().split("\\,");
        String compareLow = valueStr.toLowerCase();
        if (compareAry.length == 1) {
            return compareAry[0].contains(compareLow);
        }
        for (int i = 0; i < compareAry.length; ++i) {
            if (!compareLow.equals(compareAry[i].trim())) continue;
            return true;
        }
        return false;
    }

    private static boolean out(Object value, String valueStr, String compare, String type) {
        if (value == null) {
            return true;
        }
        String[] compareAry = compare.toLowerCase().split("\\,");
        String compareLow = valueStr.toLowerCase();
        if (compareAry.length == 1) {
            return !compareAry[0].contains(compareLow);
        }
        for (int i = 0; i < compareAry.length; ++i) {
            if (!compareLow.equals(compareAry[i].trim())) continue;
            return false;
        }
        return true;
    }

    private static boolean between(Object param, String valueStr, String beginContrast, String endContrast) {
        Date dateVar;
        if (null == param) {
            return false;
        }
        return param instanceof Date || param instanceof LocalDate || param instanceof LocalDateTime ? (dateVar = DateUtil.convertDateObject(param)).compareTo(DateUtil.convertDateObject(beginContrast)) >= 0 && dateVar.compareTo(DateUtil.convertDateObject(endContrast)) <= 0 : (param instanceof LocalTime ? ((LocalTime)param).compareTo(LocalTime.parse(beginContrast)) >= 0 && ((LocalTime)param).compareTo(LocalTime.parse(endContrast)) <= 0 : (param instanceof Number ? new BigDecimal(param.toString()).compareTo(new BigDecimal(beginContrast)) >= 0 && new BigDecimal(param.toString()).compareTo(new BigDecimal(endContrast)) <= 0 : valueStr.compareTo(beginContrast) >= 0 && valueStr.compareTo(endContrast) <= 0));
    }

    private static String removeStartEndQuote(String source) {
        if (source == null) {
            return source;
        }
        if (source.startsWith("'") && source.endsWith("'")) {
            return source.substring(1, source.length() - 1);
        }
        if (source.startsWith("\"") && source.endsWith("\"")) {
            return source.substring(1, source.length() - 1);
        }
        return source;
    }

    private static boolean hasArg(String value, int sqlParamType) {
        if (sqlParamType == 0 && StringUtil.matches(value, SqlConfigParseUtils.ARG_NAME_PATTERN)) {
            return true;
        }
        if (sqlParamType == 1 && StringUtil.matches(BLANK.concat(value).concat(BLANK), SqlToyConstants.SQL_NAMED_PATTERN)) {
            return true;
        }
        return sqlParamType == 2 && StringUtil.matches(value, SqlToyConstants.NOSQL_NAMED_PATTERN);
    }

    private static boolean isArg(String value, int sqlParamType) {
        int[] indexes;
        if (sqlParamType == 0 && value.equals("?")) {
            return true;
        }
        if (sqlParamType == 1 && (indexes = StringUtil.matchIndex(BLANK.concat(value).concat(BLANK), SqlToyConstants.SQL_NAMED_PATTERN, 0))[1] == value.length() + 2) {
            return true;
        }
        return sqlParamType == 2 && (indexes = StringUtil.matchIndex(value, SqlToyConstants.NOSQL_NAMED_PATTERN, 0))[1] == value.length();
    }
}

