/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.IllegalFormatFlagsException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.FieldTranslate;
import org.sagacity.sqltoy.config.model.NoSqlFieldsModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.translate.DynamicCacheFetch;
import org.sagacity.sqltoy.translate.FieldTranslateCacheHolder;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoElasticUtils {
    protected static final Logger logger = LoggerFactory.getLogger(MongoElasticUtils.class);
    private static final String SQL_PSEUDO_START_MARK = "#[";
    public static final String SQL_PSEUDO_SYM_START_MARK = "[";
    private static final String MQL_PSEUDO_START_MARK = "<#>";
    private static final String SQL_PSEUDO_END_MARK = "]";
    private static final String MQL_PSEUDO_END_MARK = "</#>";
    private static final String BLANK = " ";
    public static final String BLANK_REGEX = "(?i)\\@blank\\s*\\(\\s*\\:[A-Za-z_0-9\\-]+\\s*\\)";
    public static final Pattern BLANK_PATTERN = Pattern.compile("(?i)\\@blank\\s*\\(\\s*\\:[A-Za-z_0-9\\-]+\\s*\\)");
    public static final String VALUE_REGEX = "(?i)\\@value\\s*\\(\\s*\\:[A-Za-z_0-9\\-]+\\s*\\)";
    public static final Pattern VALUE_PATTERN = Pattern.compile("(?i)\\@value\\s*\\(\\s*\\:[A-Za-z_0-9\\-]+\\s*\\)");

    private MongoElasticUtils() {
    }

    private static SqlToyResult wrapNoSql(SqlToyConfig sqlToyConfig, String[] paramNames, Object[] paramValues) {
        String mql = sqlToyConfig.getSql(null);
        String[] fullNames = null;
        boolean sqlMode = sqlToyConfig.getNoSqlConfigModel().isSqlMode();
        fullNames = sqlMode ? SqlConfigParseUtils.getSqlParamsName(mql, false) : SqlConfigParseUtils.getNoSqlParamsName(mql, false);
        Pattern namedPattern = sqlMode ? SqlToyConstants.SQL_NAMED_PATTERN : SqlToyConstants.NOSQL_NAMED_PATTERN;
        Object[] fullParamValues = SqlConfigParseUtils.matchNamedParam(fullNames, paramNames, paramValues);
        SqlToyResult sqlToyResult = MongoElasticUtils.processNullConditions(mql, fullParamValues, sqlMode);
        MongoElasticUtils.processBlank(sqlToyResult, namedPattern, sqlMode);
        MongoElasticUtils.processValue(sqlToyResult, namedPattern, sqlMode);
        return sqlToyResult;
    }

    public static String wrapMql(SqlToyConfig sqlToyConfig, String[] paramNames, Object[] paramValues) {
        if (paramNames == null || paramNames.length == 0) {
            return sqlToyConfig.getSql(null);
        }
        SqlToyResult sqlToyResult = MongoElasticUtils.wrapNoSql(sqlToyConfig, paramNames, paramValues);
        if (sqlToyConfig.getNoSqlConfigModel().isSqlMode()) {
            return MongoElasticUtils.replaceSqlParams(sqlToyResult.getSql(), sqlToyResult.getParamsValue(), true);
        }
        String mongoJson = MongoElasticUtils.replaceNoSqlParams(sqlToyResult.getSql(), sqlToyResult.getParamsValue(), true).trim();
        if (!mongoJson.startsWith("{")) {
            mongoJson = "{".concat(mongoJson);
        }
        if (!mongoJson.endsWith("}")) {
            mongoJson = mongoJson.concat("}");
        }
        return mongoJson;
    }

    public static String wrapES(SqlToyConfig sqlToyConfig, String[] paramNames, Object[] paramValues) {
        if (paramNames == null || paramNames.length == 0) {
            return sqlToyConfig.getSql(null);
        }
        SqlToyResult sqlToyResult = MongoElasticUtils.wrapNoSql(sqlToyConfig, paramNames, paramValues);
        if (sqlToyConfig.getNoSqlConfigModel().isSqlMode()) {
            return MongoElasticUtils.replaceSqlParams(sqlToyResult.getSql(), sqlToyResult.getParamsValue(), true);
        }
        String elasticJson = MongoElasticUtils.replaceNoSqlParams(sqlToyResult.getSql(), sqlToyResult.getParamsValue(), false).trim();
        if (!elasticJson.startsWith("{")) {
            elasticJson = "{".concat(elasticJson);
        }
        if (!elasticJson.endsWith("}")) {
            elasticJson = elasticJson.concat("}");
        }
        return elasticJson;
    }

    private static SqlToyResult processNullConditions(String queryStr, Object[] paramValues, boolean sqlMode) {
        int sqlParamType;
        SqlToyResult sqlToyResult = new SqlToyResult();
        sqlToyResult.setSql(queryStr);
        sqlToyResult.setParamsValue(paramValues);
        if (queryStr.indexOf(SQL_PSEUDO_START_MARK) == -1 && queryStr.indexOf(MQL_PSEUDO_START_MARK) == -1) {
            return sqlToyResult;
        }
        boolean isMqlMark = false;
        if (queryStr.indexOf(MQL_PSEUDO_START_MARK) != -1) {
            isMqlMark = true;
        }
        String startMark = isMqlMark ? MQL_PSEUDO_START_MARK : SQL_PSEUDO_START_MARK;
        String endMark = isMqlMark ? MQL_PSEUDO_END_MARK : SQL_PSEUDO_END_MARK;
        Pattern namedPattern = sqlMode ? SqlToyConstants.SQL_NAMED_PATTERN : SqlToyConstants.NOSQL_NAMED_PATTERN;
        int startMarkLength = startMark.length();
        int endMarkLength = endMark.length();
        int pseudoMarkStart = queryStr.indexOf(startMark);
        List paramValuesList = CollectionUtil.arrayToList(paramValues);
        boolean isEndWithAndOr = false;
        int ifLogicCnt = 0;
        int offset = sqlMode ? 1 : 0;
        int n = sqlParamType = sqlMode ? 1 : 2;
        while (pseudoMarkStart != -1) {
            int paramCnt;
            ifLogicCnt = 0;
            isEndWithAndOr = false;
            int beginMarkIndex = queryStr.lastIndexOf(startMark);
            int endMarkIndex = StringUtil.getSymMarkIndex(startMark.equals(SQL_PSEUDO_START_MARK) ? SQL_PSEUDO_SYM_START_MARK : startMark, endMark, queryStr, beginMarkIndex);
            if (endMarkIndex == -1) {
                throw new IllegalFormatFlagsException("json\u67e5\u8be2\u8bed\u53e5\u4e2d\u7f3a\u4e4f:\"" + startMark + "\" \u76f8\u5bf9\u79f0\u7684:\"" + endMark + "\"\u7b26\u53f7,\u8bf7\u68c0\u67e5json\u67e5\u8be2\u8bed\u53e5\u683c\u5f0f!");
            }
            String preSql = queryStr.substring(0, beginMarkIndex).concat(BLANK);
            String markContentSql = BLANK.concat(queryStr.substring(beginMarkIndex + startMarkLength, endMarkIndex)).concat(BLANK);
            int ifLogicSignStart = StringUtil.matchIndex(markContentSql, SqlConfigParseUtils.IF_ALL_PATTERN);
            int ifStart = StringUtil.matchIndex(markContentSql, SqlConfigParseUtils.IF_PATTERN);
            if (ifStart == ifLogicSignStart && ifStart > 0) {
                ifLogicCnt = 1;
            } else if (ifStart == -1 && ifLogicSignStart > 0) {
                int symIfIndex = SqlConfigParseUtils.getStartIfIndex(preSql, startMark.equals(SQL_PSEUDO_START_MARK) ? SQL_PSEUDO_SYM_START_MARK : startMark, endMark);
                if (symIfIndex == -1) {
                    throw new IllegalFormatFlagsException("\u7f16\u5199\u6a21\u5f0f\u5b58\u5728\u9519\u8bef:@elseif(?==xx) @else \u6761\u4ef6\u5224\u65ad\u5fc5\u987b\u8981\u6709\u5bf9\u5e94\u7684@if()\u5f62\u6210\u5bf9\u79f0\u683c\u5f0f!");
                }
                beginMarkIndex = queryStr.substring(0, symIfIndex).lastIndexOf(startMark);
                preSql = queryStr.substring(0, beginMarkIndex).concat(BLANK);
                markContentSql = BLANK.concat(queryStr.substring(beginMarkIndex + startMarkLength, endMarkIndex)).concat(BLANK);
                ifLogicCnt = StringUtil.matchCnt(markContentSql, SqlConfigParseUtils.IF_ALL_PATTERN);
            }
            String tailSql = queryStr.substring(endMarkIndex + endMarkLength);
            int preParamCnt = StringUtil.matchCnt(preSql, namedPattern, offset);
            markContentSql = SqlConfigParseUtils.processIfLogic(markContentSql, startMark, endMark, namedPattern, paramValuesList, preSql, preParamCnt, ifLogicCnt, offset, sqlParamType);
            if (ifLogicCnt == 0) {
                if (sqlMode) {
                    isEndWithAndOr = StringUtil.matches(markContentSql, SqlToyConstants.AND_OR_END);
                }
                markContentSql = (paramCnt = StringUtil.matchCnt(markContentSql, namedPattern, offset)) == 0 ? BLANK : SqlConfigParseUtils.processMarkContent(markContentSql, namedPattern, paramValuesList, preParamCnt, paramCnt, sqlMode);
            } else {
                boolean isDynamicSql = SqlConfigParseUtils.isDynamicSql(markContentSql, startMark, endMark);
                if (!isDynamicSql) {
                    if (sqlMode) {
                        isEndWithAndOr = StringUtil.matches(markContentSql, SqlToyConstants.AND_OR_END);
                    }
                    paramCnt = StringUtil.matchCnt(markContentSql, namedPattern, offset);
                    markContentSql = SqlConfigParseUtils.processMarkContent(markContentSql, namedPattern, paramValuesList, preParamCnt, paramCnt, sqlMode);
                } else {
                    String clearSymMarkStr = StringUtil.clearSymMarkContent(markContentSql, startMark, endMark);
                    int clearAfterArgCnt = StringUtil.matchCnt(clearSymMarkStr, namedPattern, offset);
                    if (clearAfterArgCnt > 0) {
                        markContentSql = startMark.concat(markContentSql).concat(endMark);
                    } else if (sqlMode) {
                        isEndWithAndOr = StringUtil.matches(markContentSql, SqlToyConstants.AND_OR_END);
                    }
                }
            }
            queryStr = sqlMode ? SqlConfigParseUtils.processWhereLinkAnd(preSql, markContentSql, isEndWithAndOr, tailSql) : preSql.concat(BLANK).concat(markContentSql).concat(BLANK).concat(tailSql);
            pseudoMarkStart = queryStr.indexOf(startMark);
        }
        sqlToyResult.setSql(sqlMode ? queryStr : MongoElasticUtils.processComma(queryStr));
        sqlToyResult.setParamsValue(paramValuesList.toArray());
        return sqlToyResult;
    }

    private static void processBlank(SqlToyResult sqlToyResult, Pattern argNamedPattern, boolean sqlMode) {
        if (null == sqlToyResult.getParamsValue() || sqlToyResult.getParamsValue().length == 0) {
            return;
        }
        String queryStr = sqlToyResult.getSql().toLowerCase();
        Matcher m = BLANK_PATTERN.matcher(queryStr);
        int index = 0;
        int paramCnt = 0;
        int blankCnt = 0;
        List paramValueList = null;
        while (m.find()) {
            if (blankCnt == 0) {
                paramValueList = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
            }
            index = m.start();
            paramCnt = StringUtil.matchCnt(queryStr.substring(0, index), argNamedPattern, sqlMode ? 1 : 0);
            paramValueList.remove(paramCnt - blankCnt);
            ++blankCnt;
        }
        if (blankCnt > 0) {
            sqlToyResult.setSql(sqlToyResult.getSql().replaceAll(BLANK_REGEX, BLANK));
            sqlToyResult.setParamsValue(paramValueList.toArray());
        }
    }

    private static void processValue(SqlToyResult sqlToyResult, Pattern namedPattern, boolean sqlMode) {
        if (null == sqlToyResult.getParamsValue() || sqlToyResult.getParamsValue().length == 0) {
            return;
        }
        String queryStr = sqlToyResult.getSql().toLowerCase();
        Matcher m = VALUE_PATTERN.matcher(queryStr);
        int index = 0;
        int paramCnt = 0;
        int valueCnt = 0;
        List paramValueList = null;
        Object paramValue = null;
        while (m.find()) {
            if (valueCnt == 0) {
                paramValueList = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
            }
            index = m.start();
            paramCnt = StringUtil.matchCnt(queryStr.substring(0, index), namedPattern, sqlMode ? 1 : 0);
            paramValue = paramValueList.get(paramCnt - valueCnt);
            sqlToyResult.setSql(sqlToyResult.getSql().replaceFirst(VALUE_REGEX, paramValue == null ? "null" : paramValue.toString()));
            paramValueList.remove(paramCnt - valueCnt);
            ++valueCnt;
        }
        if (valueCnt > 0) {
            sqlToyResult.setParamsValue(paramValueList.toArray());
        }
    }

    public static String processComma(String sql) {
        String[] sqlSlice = sql.split("(?i)\\@(dot|comma)\\(\\s*\\)");
        if (sqlSlice.length == 1) {
            return sql;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < sqlSlice.length; ++i) {
            String fragment;
            if (i > 0) {
                result.append(" , ");
            }
            if ((fragment = sqlSlice[i].trim()).startsWith(",")) {
                fragment = fragment.substring(1);
            }
            if (fragment.endsWith(",")) {
                fragment = fragment.substring(0, fragment.length() - 1);
            }
            result.append(fragment);
        }
        return result.toString();
    }

    public static String replaceNoSqlParams(String sql, Object[] paramValues, boolean addSingleQuotation) {
        String sign;
        if (paramValues == null || paramValues.length == 0) {
            return sql;
        }
        Matcher m = SqlToyConstants.NOSQL_NAMED_PATTERN.matcher(sql);
        StringBuilder realMql = new StringBuilder();
        int start = 0;
        int index = 0;
        boolean isAry = false;
        Object[] ary = null;
        String string = sign = addSingleQuotation ? "'" : "";
        while (m.find()) {
            String groupStr = m.group();
            realMql.append(sql.substring(start, m.start()));
            start = m.end();
            String method = groupStr.substring(1, groupStr.indexOf("(")).toLowerCase().trim();
            Object value = paramValues[index];
            if ("".equals(method) || "param".equals(method) || "value".equals(method)) {
                isAry = true;
                if (value != null && value.getClass().isArray()) {
                    ary = CollectionUtil.convertArray(value);
                } else if (value instanceof Collection) {
                    ary = ((Collection)value).toArray();
                } else {
                    ary = new Object[]{value};
                    isAry = false;
                }
                if (isAry) {
                    realMql.append(SQL_PSEUDO_SYM_START_MARK);
                }
                int i = 0;
                for (Object item : ary) {
                    if (i > 0) {
                        realMql.append(",");
                    }
                    if (item == null) {
                        realMql.append("null");
                    } else if (item instanceof CharSequence) {
                        realMql.append(sign).append(MongoElasticUtils.removeDangerWords(item.toString())).append(sign);
                    } else {
                        realMql.append(SqlUtil.toSqlString(item, addSingleQuotation));
                    }
                    ++i;
                }
                if (isAry) {
                    realMql.append(SQL_PSEUDO_END_MARK);
                }
            }
            ++index;
        }
        realMql.append(sql.substring(start));
        return realMql.toString();
    }

    public static String replaceSqlParams(String sql, Object[] paramValues, boolean addSingleQuotation) {
        if (paramValues == null || paramValues.length == 0) {
            return sql;
        }
        Matcher m = SqlToyConstants.SQL_NAMED_PATTERN.matcher(sql);
        StringBuilder realMql = new StringBuilder();
        int start = 0;
        int index = 0;
        boolean isUpdateOrNotWhere = false;
        while (m.find(start)) {
            Object value = paramValues[index];
            String sqlPart = sql.substring(start, m.start() + 1);
            if (value == null) {
                String preSql = sql.substring(0, m.start() + 1);
                isUpdateOrNotWhere = false;
                if (StringUtil.matches(preSql, SqlConfigParseUtils.UPDATE_EQUAL_PATTERN) || !StringUtil.matches(preSql, SqlConfigParseUtils.WHERE_PATTERN)) {
                    isUpdateOrNotWhere = true;
                }
                realMql.append(MongoElasticUtils.processNull(sqlPart, isUpdateOrNotWhere)).append("null");
            } else {
                realMql.append(sqlPart);
                realMql.append(SqlUtil.toSqlString(value, true));
            }
            ++index;
            if (StringUtil.matches(m.group(), SqlToyConstants.BLANK_END)) {
                start = m.end() - 1;
                continue;
            }
            start = m.end();
        }
        realMql.append(sql.substring(start));
        return realMql.toString();
    }

    private static String processNull(String sqlContent, boolean isUpdateOrNotWhere) {
        int compareIndex = StringUtil.matchIndex(sqlContent, SqlConfigParseUtils.NOT_EQUAL_PATTERN);
        String sqlPart = " is not ";
        if (compareIndex == -1) {
            compareIndex = StringUtil.matchIndex(sqlContent, SqlConfigParseUtils.EQUAL_PATTERN);
            if (compareIndex != -1 && isUpdateOrNotWhere) {
                compareIndex = -1;
            }
            if (compareIndex != -1) {
                ++compareIndex;
            }
            sqlPart = " is ";
        }
        if (compareIndex != -1) {
            return sqlContent.substring(0, compareIndex).concat(sqlPart);
        }
        return sqlContent;
    }

    private static String removeDangerWords(String paramValue) {
        return paramValue.replaceAll("(\"|'|\\{|\\[|\\}|\\]|\\$|&quot;)", "");
    }

    public static void processTranslate(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, List resultSet, String[] fields) {
        HashMap<String, FieldTranslate> translateMap = sqlToyConfig.getTranslateMap();
        if (!sqlToyConfig.getTranslateMap().isEmpty()) {
            HashMap<String, FieldTranslateCacheHolder> translateCache = sqlToyContext.getTranslateManager().getTranslates(translateMap);
            MongoElasticUtils.translate(sqlToyContext.getDynamicCacheFetch(), sqlToyConfig.getTranslateMap(), translateCache, resultSet, fields);
        }
    }

    private static void translate(DynamicCacheFetch dynamicCacheFetch, HashMap<String, FieldTranslate> translateMap, HashMap<String, FieldTranslateCacheHolder> translateCache, List<List> dataSet, String[] fields) {
        if (translateCache == null || translateCache.isEmpty()) {
            return;
        }
        if (dataSet == null || dataSet.isEmpty()) {
            return;
        }
        HashMap<String, Integer> colIndexMap = new HashMap<String, Integer>();
        int fieldCnt = fields.length;
        int[] realIndex = new int[fieldCnt];
        for (int i = 0; i < fieldCnt; ++i) {
            colIndexMap.put(fields[i].toLowerCase(), i);
        }
        translateCache.forEach((fieldName, fieldTranslateCacheHolder) -> {
            for (Translate translate : fieldTranslateCacheHolder.getTranslates()) {
                if (!translate.getExtend().hasLogic || colIndexMap.containsKey(translate.getExtend().compareColumn)) continue;
                throw new IllegalArgumentException("\u7f13\u5b58\u7ffb\u8bd1\u914d\u7f6ewhere\u8868\u8fbe\u5f0f\u4e2d\u7684\u903b\u8f91\u5224\u65ad\u5217:[" + translate.getExtend().compareColumn + "]\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u7f13\u5b58\u7ffb\u8bd1!");
            }
        });
        for (int i = 0; i < fieldCnt; ++i) {
            String fieldLow = fields[i].toLowerCase();
            realIndex[i] = i;
            if (!translateMap.containsKey(fieldLow)) continue;
            FieldTranslate fieldTranslate = translateMap.get(fieldLow);
            if (fieldTranslate.aliasName == null) continue;
            realIndex[i] = (Integer)colIndexMap.get(fieldTranslate.aliasName.toLowerCase());
        }
        int size = dataSet.size();
        for (int i = 0; i < fieldCnt; ++i) {
            FieldTranslateCacheHolder fieldTranslateHandler = translateCache.get(fields[i].toLowerCase());
            if (fieldTranslateHandler == null) continue;
            for (int j = 0; j < size; ++j) {
                List rowList = dataSet.get(j);
                Object cellValue = rowList.get(realIndex[i]);
                if (cellValue == null) continue;
                rowList.set(i, fieldTranslateHandler.getRowCacheValue(dynamicCacheFetch, rowList, colIndexMap, cellValue.toString()));
            }
        }
    }

    public static NoSqlFieldsModel processFields(String[] fields, HashMap<String, String[]> fieldMap) {
        NoSqlFieldsModel result = new NoSqlFieldsModel();
        String[] realFields = new String[fields.length];
        String[] aliasFields = new String[fields.length];
        int aliasIndex = 0;
        for (int i = 0; i < fields.length; ++i) {
            realFields[i] = fields[i];
            aliasFields[i] = fields[i];
            aliasIndex = fields[i].indexOf(":");
            if (aliasIndex != -1) {
                realFields[i] = fields[i].substring(0, aliasIndex).trim();
                aliasFields[i] = fields[i].substring(aliasIndex + 1).trim();
            } else {
                aliasIndex = fields[i].lastIndexOf(".");
                if (aliasIndex != -1) {
                    aliasFields[i] = fields[i].substring(aliasIndex + 1).trim();
                }
            }
            if (fieldMap == null || !realFields[i].contains(".")) continue;
            fieldMap.put(realFields[i], realFields[i].split("\\."));
        }
        result.setFields(realFields);
        result.setAliasLabels(aliasFields);
        return result;
    }
}

