/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.ParallelCallbackHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.ShardingConfig;
import org.sagacity.sqltoy.config.model.ShardingGroupModel;
import org.sagacity.sqltoy.config.model.ShardingModel;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.executor.DialectExecutor;
import org.sagacity.sqltoy.model.ParallelConfig;
import org.sagacity.sqltoy.model.ShardingResult;
import org.sagacity.sqltoy.plugins.sharding.ShardingUtils;

public class ParallelUtils {
    private ParallelUtils() {
    }

    public static List execute(SqlToyContext sqlToyContext, List entities, boolean wrapIdValue, boolean notSharding, SqlType sqlType, DataSource dataSource, ParallelConfig parallelConfig, ParallelCallbackHandler handler) throws Exception {
        EntityMeta entityMeta;
        Class<?> entityClass = entities.get(0).getClass();
        boolean isEntity = notSharding ? false : sqlToyContext.isEntity(entityClass);
        EntityMeta entityMeta2 = entityMeta = isEntity ? sqlToyContext.getEntityMeta(entityClass) : null;
        if (wrapIdValue && isEntity) {
            ShardingUtils.assignPKs(sqlToyContext, entityMeta, entities);
        }
        Collection<ShardingGroupModel> shardingGroups = null;
        ShardingConfig shardingConfig = null;
        if (notSharding || (entityMeta == null || entityMeta.getShardingConfig() == null) && parallelConfig != null) {
            shardingGroups = ParallelUtils.splitSetParallel(entityMeta, entities, dataSource, parallelConfig);
            shardingConfig = new ShardingConfig();
            if (parallelConfig != null) {
                shardingConfig.setMaxConcurrents(parallelConfig.getMaxThreads());
                shardingConfig.setMaxWaitSeconds(parallelConfig.getMaxWaitSeconds());
            }
        } else {
            shardingGroups = ShardingUtils.groupShardings(sqlToyContext, entities, entityMeta, dataSource);
            shardingConfig = entityMeta.getShardingConfig();
        }
        if (shardingGroups.size() == 1) {
            return handler.execute(sqlToyContext, shardingGroups.iterator().next());
        }
        SqlExecuteStat.debug("\u5f00\u542f\u5e76\u884c\u6267\u884c", "\u5e76\u884c\u7ebf\u7a0b\u6570:{},\u6700\u5927\u7b49\u5f85\u65f6\u957f:{}\u79d2", shardingGroups.size(), shardingConfig.getMaxWaitSeconds());
        ArrayList results = new ArrayList();
        int threads = shardingGroups.size();
        boolean globalRollback = shardingConfig.isGlobalRollback();
        if (threads > shardingConfig.getMaxConcurrents() && shardingConfig.getMaxConcurrents() > 1) {
            threads = shardingConfig.getMaxConcurrents();
        }
        ExecutorService pool = Executors.newFixedThreadPool(threads);
        ArrayList<Future<ShardingResult>> futureResults = new ArrayList<Future<ShardingResult>>();
        for (ShardingGroupModel group : shardingGroups) {
            Future<ShardingResult> future = pool.submit(new DialectExecutor(sqlToyContext, group, handler));
            futureResults.add(future);
        }
        pool.shutdown();
        if (shardingConfig.getMaxWaitSeconds() > 0) {
            pool.awaitTermination(shardingConfig.getMaxWaitSeconds(), TimeUnit.SECONDS);
        } else {
            pool.awaitTermination(SqlToyConstants.PARALLEL_MAXWAIT_SECONDS, TimeUnit.SECONDS);
        }
        try {
            for (Future future : futureResults) {
                ShardingResult item = (ShardingResult)future.get();
                if (item != null && !item.isSuccess() && globalRollback) {
                    throw new RuntimeException(item.getMessage());
                }
                if (item == null || item.getRows() == null || item.getRows().isEmpty()) continue;
                results.addAll(item.getRows());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            pool.shutdownNow();
        }
        return results;
    }

    private static Collection<ShardingGroupModel> splitSetParallel(EntityMeta entityMeta, List entities, DataSource dataSource, ParallelConfig parallelConfig) {
        int groupSize;
        ArrayList<ShardingGroupModel> shardingGroups = new ArrayList<ShardingGroupModel>();
        ShardingModel shardingModel = new ShardingModel();
        shardingModel.setDataSource(dataSource);
        if (entityMeta != null) {
            shardingModel.setTableName(entityMeta.getTableName());
        }
        int recordSize = entities.size();
        if (parallelConfig == null) {
            groupSize = recordSize;
        } else {
            groupSize = recordSize % parallelConfig.getMaxThreads() == 0 ? recordSize / parallelConfig.getMaxThreads() : recordSize / parallelConfig.getMaxThreads() + 1;
            if (groupSize < parallelConfig.getGroupSize()) {
                groupSize = parallelConfig.getGroupSize();
            }
        }
        if (recordSize <= groupSize) {
            ShardingGroupModel groupModel = new ShardingGroupModel();
            groupModel.setEntities(entities);
            groupModel.setShardingModel(shardingModel);
            shardingGroups.add(groupModel);
        } else {
            int meter = 0;
            ArrayList subEntities = new ArrayList();
            for (Object item : entities) {
                subEntities.add(item);
                if (++meter % groupSize != 0 && meter != recordSize) continue;
                ShardingGroupModel groupModel = new ShardingGroupModel();
                groupModel.setEntities(subEntities);
                groupModel.setShardingModel(shardingModel);
                shardingGroups.add(groupModel);
                subEntities = new ArrayList();
            }
        }
        return shardingGroups;
    }
}

