/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.utils.StringUtil;

public class ReservedWordsUtil {
    private static HashSet<String> reservedWords = new HashSet();
    private static Pattern singlePattern = null;

    private ReservedWordsUtil() {
    }

    public static void put(String words) {
        if (StringUtil.isBlank(words)) {
            return;
        }
        String[] strs = words.split("\\,");
        String fullRegex = "";
        int index = 0;
        for (String str : strs) {
            String regex = str.trim().toLowerCase();
            if ("".equals(regex)) continue;
            reservedWords.add(regex);
            if (index > 0) {
                fullRegex = fullRegex.concat("|");
            }
            fullRegex = fullRegex.concat(regex);
            ++index;
        }
        singlePattern = Pattern.compile("(?i)(\\W||\\s)(`|'|\"|\\[)(" + fullRegex + ")(`|'|\"|\\])(\\s||\\W)");
    }

    public static String convertSimpleSql(String sql, Integer dbType) {
        if (reservedWords.isEmpty()) {
            return sql;
        }
        if (dbType == 40 || dbType == 90 || dbType == 42 || dbType == 150) {
            return sql.replaceAll("\\[", "`").replaceAll("\\]", "`");
        }
        if (dbType == 10 || dbType == 50 || dbType == 51 || dbType == 20 || dbType == 110 || dbType == 70 || dbType == 190 || dbType == 220 || dbType == 180 || dbType == 210 || dbType == 200 || dbType == 100 || dbType == 11) {
            return sql.replaceAll("\\[", "\"").replaceAll("\\]", "\"");
        }
        if (dbType == 170) {
            return sql.replaceAll("\\[", "'").replaceAll("\\]", "'");
        }
        if (dbType == null || dbType == 30 || dbType == 80) {
            return sql;
        }
        return sql.replaceAll("\\[", "").replaceAll("\\]", "");
    }

    public static String convertWord(String column, Integer dbType) {
        if (column == null) {
            return null;
        }
        if (reservedWords.isEmpty()) {
            return column;
        }
        if (!reservedWords.contains(column.toLowerCase())) {
            return column;
        }
        if (dbType == null || dbType == 30 || dbType == 80) {
            return "[".concat(column).concat("]");
        }
        if (dbType == 40 || dbType == 90 || dbType == 42 || dbType == 150) {
            return "`".concat(column).concat("`");
        }
        if (dbType == 170) {
            return "'".concat(column).concat("'");
        }
        if (dbType == 10 || dbType == 50 || dbType == 51 || dbType == 120 || dbType == 20 || dbType == 70 || dbType == 190 || dbType == 210 || dbType == 200 || dbType == 220 || dbType == 180 || dbType == 110 || dbType == 100 || dbType == 11) {
            return "\"".concat(column).concat("\"");
        }
        return column;
    }

    public static String convertSql(String sql, Integer dbType) {
        if (reservedWords.isEmpty()) {
            return sql;
        }
        if (dbType == null || dbType == 140 || dbType == 130 || dbType == 0) {
            return sql;
        }
        StringBuilder sqlBuff = new StringBuilder();
        int start = 0;
        int end = 0;
        Matcher matcher = singlePattern.matcher(sql);
        int subSize = 0;
        while (matcher.find()) {
            subSize = 0;
            end = matcher.start() + 1;
            String keyWord = matcher.group().substring(1);
            if (keyWord.startsWith("`") || keyWord.startsWith("\"") || keyWord.startsWith("[") || keyWord.startsWith("'")) {
                keyWord = keyWord.substring(1);
            }
            sqlBuff.append(sql.substring(start, end));
            keyWord = keyWord.substring(0, keyWord.length() - 1);
            if (keyWord.endsWith("`") || keyWord.endsWith("\"") || keyWord.endsWith("]") || keyWord.endsWith("'")) {
                keyWord = keyWord.substring(0, keyWord.length() - 1);
                subSize = 1;
            }
            if (dbType == 50 || dbType == 51 || dbType == 10 || dbType == 20 || dbType == 120 || dbType == 70 || dbType == 190 || dbType == 210 || dbType == 200 || dbType == 110 || dbType == 100 || dbType == 11 || dbType == 220 || dbType == 180) {
                sqlBuff.append("\"").append(keyWord).append("\"");
            } else if (dbType == 30 || dbType == 80) {
                sqlBuff.append("[").append(keyWord).append("]");
            } else if (dbType == 40 || dbType == 90 || dbType == 42 || dbType == 150) {
                sqlBuff.append("`").append(keyWord).append("`");
            } else if (dbType == 170) {
                sqlBuff.append("'").append(keyWord).append("'");
            } else {
                sqlBuff.append(keyWord);
            }
            start = matcher.end() - subSize;
        }
        if (start > 0) {
            sqlBuff.append(sql.substring(start));
            return sqlBuff.toString();
        }
        return sql;
    }

    public static boolean isKeyWord(String column) {
        if (column == null) {
            return false;
        }
        return reservedWords.contains(column.toLowerCase());
    }
}

