/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.StreamResultHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.ColsChainRelativeModel;
import org.sagacity.sqltoy.config.model.DataType;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldTranslate;
import org.sagacity.sqltoy.config.model.FormatModel;
import org.sagacity.sqltoy.config.model.LabelIndexModel;
import org.sagacity.sqltoy.config.model.LinkModel;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PivotModel;
import org.sagacity.sqltoy.config.model.ReverseModel;
import org.sagacity.sqltoy.config.model.RowsChainRelativeModel;
import org.sagacity.sqltoy.config.model.SecureMask;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.config.model.SummaryModel;
import org.sagacity.sqltoy.config.model.TableCascadeModel;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.config.model.TreeSortModel;
import org.sagacity.sqltoy.config.model.UnpivotModel;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.inner.DataSetResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.calculator.ColsChainRelative;
import org.sagacity.sqltoy.plugins.calculator.GroupSummary;
import org.sagacity.sqltoy.plugins.calculator.ReverseList;
import org.sagacity.sqltoy.plugins.calculator.RowsChainRelative;
import org.sagacity.sqltoy.plugins.calculator.TreeDataSort;
import org.sagacity.sqltoy.plugins.calculator.UnpivotList;
import org.sagacity.sqltoy.plugins.secure.DesensitizeProvider;
import org.sagacity.sqltoy.translate.DynamicCacheFetch;
import org.sagacity.sqltoy.translate.FieldTranslateCacheHolder;
import org.sagacity.sqltoy.translate.TranslateConfigParse;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResultUtils.class);

    private ResultUtils() {
    }

    public static QueryResult processResultSet(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, Connection conn, ResultSet rs, QueryExecutorExtend queryExecutorExtend, UpdateRowHandler updateRowHandler, DecryptHandler decryptHandler, int startColIndex) throws Exception {
        QueryResult result = new QueryResult();
        int index = 0;
        if (queryExecutorExtend != null && queryExecutorExtend.rowCallbackHandler != null) {
            while (rs.next()) {
                queryExecutorExtend.rowCallbackHandler.processRow(rs, index);
                ++index;
            }
            result.setRows(queryExecutorExtend.rowCallbackHandler.getResult());
        } else {
            IgnoreCaseSet decryptColumns;
            IgnoreCaseSet ignoreCaseSet = decryptColumns = decryptHandler == null ? null : decryptHandler.getColumns();
            if (sqlToyConfig.getDecryptColumns() != null) {
                if (decryptColumns == null) {
                    decryptColumns = sqlToyConfig.getDecryptColumns();
                } else {
                    decryptColumns.addAll(sqlToyConfig.getDecryptColumns());
                }
            }
            DecryptHandler realDecryptHandler = null;
            if (decryptColumns != null && !decryptColumns.isEmpty()) {
                realDecryptHandler = new DecryptHandler(sqlToyContext.getFieldsSecureProvider(), decryptColumns);
            }
            int rowCnt = rs.getMetaData().getColumnCount();
            Set<String> strTypeCols = ResultUtils.getStringColumns(sqlToyConfig);
            boolean hasToStrCols = !strTypeCols.isEmpty();
            String[] labelNames = new String[rowCnt - startColIndex];
            String[] labelTypes = new String[rowCnt - startColIndex];
            HashMap<String, Integer> labelIndexMap = new HashMap<String, Integer>();
            String colLabelUpperOrLower = sqlToyContext.getColumnLabelUpperOrLower();
            for (int i = startColIndex; i < rowCnt; ++i) {
                labelNames[index] = rs.getMetaData().getColumnLabel(i + 1);
                String labeNameLow = labelNames[index].toLowerCase();
                if ("lower".equals(colLabelUpperOrLower)) {
                    labelNames[index] = labelNames[index].toLowerCase();
                } else if ("upper".equals(colLabelUpperOrLower)) {
                    labelNames[index] = labelNames[index].toUpperCase();
                }
                labelIndexMap.put(labeNameLow, index);
                labelTypes[index] = rs.getMetaData().getColumnTypeName(i + 1);
                if (hasToStrCols && strTypeCols.contains(labeNameLow)) {
                    labelTypes[index] = "VARCHAR";
                }
                ++index;
            }
            result.setLabelNames(labelNames);
            result.setLabelTypes(labelTypes);
            try {
                result.setRows(ResultUtils.getResultSet(queryExecutorExtend, sqlToyConfig, sqlToyContext, conn, rs, updateRowHandler, realDecryptHandler, rowCnt, labelIndexMap, labelNames, startColIndex));
            }
            catch (Exception oie) {
                logger.error("sql={} \u63d0\u53d6\u7ed3\u679c\u53d1\u751f\u5f02\u5e38:{}!", (Object)sqlToyConfig.getId(), (Object)oie.getMessage());
                throw oie;
            }
        }
        if (result.getRows() != null) {
            result.setRecordCount(Long.valueOf(result.getRows().size()));
        }
        return result;
    }

    public static void consumeResult(SqlToyContext sqlToyContext, QueryExecutorExtend extend, SqlToyConfig sqlToyConfig, Connection conn, ResultSet rs, StreamResultHandler streamResultHandler, Class resultType, Boolean humpMapLabel, Map<Class, IgnoreKeyCaseMap<String, String>> fieldsMap) throws Exception {
        IgnoreCaseSet decryptColumns = sqlToyConfig.getDecryptColumns();
        DecryptHandler realDecryptHandler = null;
        if (decryptColumns != null && !decryptColumns.isEmpty()) {
            realDecryptHandler = new DecryptHandler(sqlToyContext.getFieldsSecureProvider(), decryptColumns);
        }
        int columnSize = rs.getMetaData().getColumnCount();
        Set<String> strTypeCols = ResultUtils.getStringColumns(sqlToyConfig);
        boolean hasToStrCols = !strTypeCols.isEmpty();
        String[] labelNames = new String[columnSize];
        String[] labelTypes = new String[columnSize];
        String colLabelUpperOrLower = sqlToyContext.getColumnLabelUpperOrLower();
        int index = 0;
        for (int i = 0; i < columnSize; ++i) {
            labelNames[index] = rs.getMetaData().getColumnLabel(i + 1);
            String labeNameLow = labelNames[index].toLowerCase();
            if ("lower".equals(colLabelUpperOrLower)) {
                labelNames[index] = labelNames[index].toLowerCase();
            } else if ("upper".equals(colLabelUpperOrLower)) {
                labelNames[index] = labelNames[index].toUpperCase();
            }
            labelTypes[index] = rs.getMetaData().getColumnTypeName(i + 1);
            if (hasToStrCols && strTypeCols.contains(labeNameLow)) {
                labelTypes[index] = "VARCHAR";
            }
            ++index;
        }
        HashMap<String, FieldTranslate> translateMap = sqlToyConfig.getTranslateMap();
        Boolean hasTranslate = !translateMap.isEmpty();
        HashMap<String, FieldTranslateCacheHolder> translateCache = null;
        if (hasTranslate.booleanValue()) {
            translateCache = sqlToyContext.getTranslateManager().getTranslates(translateMap);
        }
        LabelIndexModel labelIndexModel = ResultUtils.wrapLabelIndexMap(labelNames);
        boolean ignoreAllEmpty = sqlToyConfig.isIgnoreEmpty();
        List<SecureMask> secureMasks = sqlToyConfig.getSecureMasks();
        List<FormatModel> formatModels = sqlToyConfig.getFormatModels();
        boolean sqlSecure = !secureMasks.isEmpty();
        boolean sqlFormat = !formatModels.isEmpty();
        boolean extSecure = extend != null && !extend.secureMask.isEmpty();
        boolean extFormat = extend != null && !extend.colsFormat.isEmpty();
        DesensitizeProvider desensitizeProvider = sqlToyContext.getDesensitizeProvider();
        int type = 1;
        boolean isMap = false;
        boolean isConMap = false;
        HashMap<String, String> columnFieldMap = null;
        Method[] realMethods = null;
        String[] methodTypes = null;
        int[] methodTypeValues = null;
        Class[] genericTypes = null;
        String[] realProps = null;
        int[] indexs = null;
        HashMap<String, String> lowKeyLabelNameMap = ResultUtils.labelLowKeyMap(labelNames);
        HashMap<String, FieldTranslateCacheHolder> cacheDatas = null;
        HashMap<String, FieldTranslate> translateConfig = null;
        DynamicCacheFetch dynamicCacheFetch = sqlToyContext.getDynamicCacheFetch();
        String[] mapLabelNames = labelNames;
        if (resultType != null && resultType != ArrayList.class && resultType != Collection.class && resultType != List.class && !BeanUtil.isBaseDataType(resultType)) {
            if (resultType == Array.class) {
                type = 2;
            } else if (Map.class.isAssignableFrom(resultType)) {
                boolean isHumpLabel;
                type = 3;
                isMap = resultType.equals(Map.class);
                isConMap = resultType.equals(ConcurrentMap.class);
                boolean bl = isHumpLabel = humpMapLabel == null ? sqlToyContext.isHumpMapResultTypeLabel() : humpMapLabel.booleanValue();
                if (isHumpLabel) {
                    mapLabelNames = ResultUtils.humpFieldNames(labelNames, null);
                }
            } else {
                type = 4;
                if (Modifier.isAbstract(resultType.getModifiers()) || Modifier.isInterface(resultType.getModifiers())) {
                    throw new IllegalArgumentException("resultType:" + resultType.getName() + " \u662f\u62bd\u8c61\u7c7b\u6216\u63a5\u53e3,\u975e\u6cd5\u53c2\u6570!");
                }
                if (sqlToyContext.isEntity(resultType)) {
                    EntityMeta entityMeta = sqlToyContext.getEntityMeta(resultType);
                    columnFieldMap = entityMeta.getColumnFieldMap();
                }
                realProps = ResultUtils.convertRealProps(ResultUtils.wrapMapFields(labelNames, fieldsMap, resultType), columnFieldMap);
                realMethods = BeanUtil.matchSetMethods(resultType, realProps);
                methodTypes = new String[columnSize];
                methodTypeValues = new int[columnSize];
                genericTypes = new Class[columnSize];
                indexs = new int[columnSize];
                for (int i = 0; i < columnSize; ++i) {
                    indexs[i] = i;
                    if (null == realMethods[i]) continue;
                    Class<?> methodType = realMethods[i].getParameterTypes()[0];
                    methodTypes[i] = methodType.getTypeName();
                    methodTypeValues[i] = DataType.getType(methodType);
                    Type[] types = realMethods[i].getGenericParameterTypes();
                    if (types.length <= 0 || !(types[0] instanceof ParameterizedType)) continue;
                    genericTypes[i] = (Class)((ParameterizedType)types[0]).getActualTypeArguments()[0];
                }
                translateConfig = TranslateConfigParse.getClassTranslates(resultType);
                if (translateConfig != null && !translateConfig.isEmpty()) {
                    cacheDatas = sqlToyContext.getTranslateManager().getTranslates(translateConfig);
                }
            }
        }
        streamResultHandler.start(labelNames, labelTypes);
        index = 0;
        while (rs.next()) {
            List rowTemp = ResultUtils.processResultRow(dynamicCacheFetch, rs, labelNames, lowKeyLabelNameMap, columnSize, translateCache, realDecryptHandler, ignoreAllEmpty);
            if (rowTemp == null) continue;
            if (sqlSecure) {
                ResultUtils.secureMaskRow(desensitizeProvider, rowTemp, secureMasks.iterator(), labelIndexModel);
            }
            if (sqlFormat) {
                ResultUtils.formatRowColumn(rowTemp, formatModels.iterator(), labelIndexModel);
            }
            if (extSecure) {
                ResultUtils.secureMaskRow(desensitizeProvider, rowTemp, extend.secureMask.values().iterator(), labelIndexModel);
            }
            if (extFormat) {
                ResultUtils.formatRowColumn(rowTemp, extend.colsFormat.values().iterator(), labelIndexModel);
            }
            if (type == 1) {
                streamResultHandler.consume(rowTemp, index);
            } else if (type == 2) {
                Object[] rowAry = new Object[rowTemp.size()];
                rowTemp.toArray(rowAry);
                streamResultHandler.consume(rowAry, index);
            } else if (type == 3) {
                Map rowMap = isMap ? new HashMap() : (isConMap ? new ConcurrentHashMap() : (Map)resultType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                for (int j = 0; j < columnSize; ++j) {
                    rowMap.put(mapLabelNames[j], rowTemp.get(j));
                }
                streamResultHandler.consume(rowMap, index);
            } else {
                Object bean = BeanUtil.reflectRowToBean(sqlToyContext.getTypeHandler(), realMethods, methodTypeValues, methodTypes, genericTypes, rowTemp, indexs, realProps, resultType);
                if (cacheDatas != null) {
                    ResultUtils.wrapBeanTranslate(dynamicCacheFetch, cacheDatas, bean);
                }
                streamResultHandler.consume(bean, index);
            }
            ++index;
        }
        streamResultHandler.end();
        SqlExecuteStat.debug("\u64cd\u4f5c\u63d0\u793a", "\u6d41\u5f0f\u67e5\u8be2\u7d2f\u8ba1\u83b7\u53d6:{} \u6761\u8bb0\u5f55!", index);
    }

    private static void secureMask(DesensitizeProvider desensitizeProvider, List<List> rows, Iterator<SecureMask> masks, LabelIndexModel labelIndexMap) {
        while (masks.hasNext()) {
            SecureMask mask = masks.next();
            Integer index = labelIndexMap.get(mask.getColumn());
            if (index == null) continue;
            int columnIndex = index;
            for (List row : rows) {
                Object value = row.get(columnIndex);
                if (value == null) continue;
                row.set(columnIndex, desensitizeProvider.desensitize(value.toString(), mask));
            }
        }
    }

    private static void secureMaskRow(DesensitizeProvider desensitizeProvider, List row, Iterator<SecureMask> masks, LabelIndexModel labelIndexMap) {
        while (masks.hasNext()) {
            int columnIndex;
            Object value;
            SecureMask mask = masks.next();
            Integer index = labelIndexMap.get(mask.getColumn());
            if (index == null || (value = row.get(columnIndex = index.intValue())) == null) continue;
            row.set(columnIndex, desensitizeProvider.desensitize(value.toString(), mask));
        }
    }

    private static void formatColumn(List<List> rows, Iterator<FormatModel> formats, LabelIndexModel labelIndexMap) {
        while (formats.hasNext()) {
            FormatModel fmt = formats.next();
            Integer index = labelIndexMap.get(fmt.getColumn());
            if (index == null && NumberUtil.isInteger(fmt.getColumn())) {
                index = Integer.parseInt(fmt.getColumn());
            }
            if (index == null) continue;
            int columnIndex = index;
            for (List row : rows) {
                Object value = row.get(columnIndex);
                if (value == null) continue;
                if (fmt.getType() == 1) {
                    row.set(columnIndex, DateUtil.formatDate(value, fmt.getFormat(), fmt.getLocale() == null ? null : new Locale(fmt.getLocale())));
                    continue;
                }
                row.set(columnIndex, NumberUtil.format(value, fmt.getFormat(), fmt.getRoundingMode(), fmt.getLocale() == null ? null : new Locale(fmt.getLocale())));
            }
        }
    }

    private static void formatRowColumn(List row, Iterator<FormatModel> formats, LabelIndexModel labelIndexMap) {
        while (formats.hasNext()) {
            int columnIndex;
            Object value;
            FormatModel fmt = formats.next();
            Integer index = labelIndexMap.get(fmt.getColumn());
            if (index == null && NumberUtil.isInteger(fmt.getColumn())) {
                index = Integer.parseInt(fmt.getColumn());
            }
            if (index == null || (value = row.get(columnIndex = index.intValue())) == null) continue;
            if (fmt.getType() == 1) {
                row.set(columnIndex, DateUtil.formatDate(value, fmt.getFormat(), fmt.getLocale() == null ? null : new Locale(fmt.getLocale())));
                continue;
            }
            row.set(columnIndex, NumberUtil.format(value, fmt.getFormat(), fmt.getRoundingMode(), fmt.getLocale() == null ? null : new Locale(fmt.getLocale())));
        }
    }

    private static List getResultSet(QueryExecutorExtend queryExtend, SqlToyConfig sqlToyConfig, SqlToyContext sqlToyContext, Connection conn, ResultSet rs, UpdateRowHandler updateRowHandler, DecryptHandler decryptHandler, int rowCnt, HashMap<String, Integer> labelIndexMap, String[] labelNames, int startColIndex) throws Exception {
        boolean maxLimit;
        boolean warnLimit;
        int index;
        ArrayList<List> items;
        block44: {
            boolean ignoreAllEmpty;
            long maxThresholds;
            int warnThresholds;
            int columnSize;
            DynamicCacheFetch dynamicCacheFetch;
            HashMap<String, FieldTranslateCacheHolder> fieldTranslateCacheHolders;
            HashMap<String, String> lowKeyLabelNameMap;
            block43: {
                LinkModel linkModel = sqlToyConfig.getLinkModel();
                if (queryExtend != null && queryExtend.linkModel != null) {
                    linkModel = queryExtend.linkModel;
                }
                if (linkModel != null && linkModel.getColumns().length > 1) {
                    return ResultUtils.getMoreLinkResultSet(sqlToyConfig, sqlToyContext, decryptHandler, conn, rs, rowCnt, labelIndexMap, labelNames, startColIndex);
                }
                items = new ArrayList<List>();
                Boolean hasTranslate = !sqlToyConfig.getTranslateMap().isEmpty();
                lowKeyLabelNameMap = ResultUtils.labelLowKeyMap(labelNames);
                HashMap<String, FieldTranslate> translateMap = sqlToyConfig.getTranslateMap();
                fieldTranslateCacheHolders = null;
                dynamicCacheFetch = sqlToyContext.getDynamicCacheFetch();
                if (hasTranslate.booleanValue()) {
                    ResultUtils.validateCacheConfig(translateMap, lowKeyLabelNameMap);
                    fieldTranslateCacheHolders = sqlToyContext.getTranslateManager().getTranslates(translateMap);
                }
                columnSize = labelNames.length;
                index = 0;
                warnThresholds = SqlToyConstants.getWarnThresholds();
                warnLimit = false;
                maxThresholds = SqlToyConstants.getMaxThresholds();
                maxLimit = false;
                ignoreAllEmpty = sqlToyConfig.isIgnoreEmpty();
                if (maxThresholds > 1L && maxThresholds <= (long)warnThresholds) {
                    maxThresholds = warnThresholds;
                }
                if (linkModel == null) break block43;
                String identity = null;
                String linkColumn = linkModel.getColumns()[0];
                String linkColumnLow = linkColumn.toLowerCase();
                if (!labelIndexMap.containsKey(linkColumnLow)) {
                    throw new DataAccessException("\u505alink\u64cd\u4f5c\u65f6,\u67e5\u8be2\u7ed3\u679c\u5b57\u6bb5\u4e2d\u6ca1\u6709\u5b57\u6bb5:" + linkColumn + ",\u8bf7\u68c0\u67e5sql\u6216link \u914d\u7f6e\u7684\u6b63\u786e\u6027!");
                }
                linkColumn = lowKeyLabelNameMap.get(linkColumnLow);
                HashSet<String> linkSet = new HashSet<String>();
                int linkIndex = labelIndexMap.get(linkColumnLow);
                StringBuilder linkBuffer = new StringBuilder();
                ArrayList<Object> linkList = new ArrayList<Object>();
                boolean hasDecorate = linkModel.getDecorateAppendChar() != null;
                boolean isLeft = true;
                if (hasDecorate) {
                    isLeft = "left".equals(linkModel.getDecorateAlign());
                }
                String preIdentity = null;
                boolean translateLink = hasTranslate != false ? translateMap.containsKey(linkColumnLow) : false;
                FieldTranslateCacheHolder fieldTranslateHandler = null;
                if (translateLink) {
                    fieldTranslateHandler = fieldTranslateCacheHolders.get(linkColumnLow);
                }
                boolean isLastProcess = false;
                boolean doLink = true;
                int linkResultType = linkModel.getResultType();
                while (rs.next()) {
                    Object tmpObject;
                    isLastProcess = false;
                    Object linkValue = rs.getObject(linkColumn);
                    String linkStr = linkValue == null ? "" : (translateLink ? ((tmpObject = fieldTranslateHandler.getRSCacheValue(dynamicCacheFetch, rs, lowKeyLabelNameMap, linkValue.toString())) == null ? linkValue.toString() : tmpObject.toString()) : linkValue.toString());
                    String string = identity = linkModel.getGroupColumns() == null ? "default" : ResultUtils.getLinkColumnsId(rs, linkModel.getGroupColumns());
                    if (!identity.equals(preIdentity)) {
                        if (index != 0) {
                            if (linkResultType == 1) {
                                ((List)items.get(items.size() - 1)).set(linkIndex, linkList);
                                linkList = new ArrayList();
                            } else if (linkResultType == 2) {
                                ((List)items.get(items.size() - 1)).set(linkIndex, linkList.toArray());
                                linkList = new ArrayList();
                            } else if (linkResultType == 3) {
                                ((List)items.get(items.size() - 1)).set(linkIndex, new HashSet(linkList));
                                linkList = new ArrayList();
                            } else {
                                ((List)items.get(items.size() - 1)).set(linkIndex, linkBuffer.toString());
                                linkBuffer.delete(0, linkBuffer.length());
                            }
                            linkSet.clear();
                        }
                        if (linkResultType > 0) {
                            if (translateLink) {
                                linkList.add(linkStr);
                            } else {
                                linkList.add(linkValue);
                            }
                        } else {
                            linkBuffer.append(linkStr);
                        }
                        linkSet.add(linkStr);
                        List tempRow = ResultUtils.processResultRow(dynamicCacheFetch, rs, labelNames, lowKeyLabelNameMap, columnSize, fieldTranslateCacheHolders, decryptHandler, ignoreAllEmpty);
                        if (tempRow != null) {
                            items.add(tempRow);
                        }
                        preIdentity = identity;
                    } else {
                        isLastProcess = true;
                        doLink = true;
                        if (linkModel.isDistinct() && linkSet.contains(linkStr)) {
                            doLink = false;
                        }
                        linkSet.add(linkStr);
                        if (doLink) {
                            if (linkResultType > 0) {
                                if (translateLink) {
                                    linkList.add(linkStr);
                                } else {
                                    linkList.add(linkValue);
                                }
                            } else {
                                if (linkBuffer.length() > 0) {
                                    linkBuffer.append(linkModel.getSign());
                                }
                                linkBuffer.append(hasDecorate ? StringUtil.appendStr(linkStr, linkModel.getDecorateAppendChar(), linkModel.getDecorateSize(), isLeft) : linkStr);
                            }
                        }
                    }
                    if (++index == warnThresholds) {
                        warnLimit = true;
                    }
                    if ((long)index != maxThresholds) continue;
                    maxLimit = true;
                    break;
                }
                if (!isLastProcess) break block44;
                if (linkResultType == 1) {
                    ((List)items.get(items.size() - 1)).set(linkIndex, linkList);
                } else if (linkResultType == 2) {
                    ((List)items.get(items.size() - 1)).set(linkIndex, linkList.toArray());
                } else if (linkResultType == 3) {
                    ((List)items.get(items.size() - 1)).set(linkIndex, new HashSet(linkList));
                } else {
                    ((List)items.get(items.size() - 1)).set(linkIndex, linkBuffer.toString());
                }
                break block44;
            }
            boolean isUpdate = false;
            if (updateRowHandler != null) {
                isUpdate = true;
            }
            while (rs.next()) {
                List tempRow;
                if (isUpdate) {
                    updateRowHandler.updateRow(rs, index);
                    rs.updateRow();
                }
                if ((tempRow = ResultUtils.processResultRow(dynamicCacheFetch, rs, labelNames, lowKeyLabelNameMap, columnSize, fieldTranslateCacheHolders, decryptHandler, ignoreAllEmpty)) != null) {
                    items.add(tempRow);
                }
                if (++index == warnThresholds) {
                    warnLimit = true;
                }
                if ((long)index != maxThresholds) continue;
                maxLimit = true;
                break;
            }
        }
        if (warnLimit) {
            ResultUtils.warnLog(sqlToyConfig, index);
        }
        if (maxLimit) {
            logger.error("MaxLargeResult:\u6267\u884csql\u63d0\u53d6\u6570\u636e\u8d85\u51fa\u6700\u5927\u9600\u503c\u9650\u5236{}(\u53ef\u901a\u8fc7[spring.sqltoy.pageFetchSizeLimit]\u53c2\u6570\u8c03\u6574),sqlId={},\u5177\u4f53\u8bed\u53e5={}", new Object[]{index, sqlToyConfig.getId(), sqlToyConfig.getSql(null)});
        }
        return items;
    }

    private static void validateCacheConfig(HashMap<String, FieldTranslate> fieldTranslateMap, HashMap<String, String> lowKeyLabelNameMap) {
        if (fieldTranslateMap == null || fieldTranslateMap.isEmpty()) {
            return;
        }
        fieldTranslateMap.forEach((fieldName, fieldTranslate) -> {
            for (Translate translate : fieldTranslate.translates) {
                if (!translate.getExtend().hasLogic || lowKeyLabelNameMap.containsKey(translate.getExtend().compareColumn)) continue;
                throw new DataAccessException("\u67e5\u8be2\u7ed3\u679c\u5b57\u6bb5\u4e2d\u6ca1\u6709:[" + translate.getExtend().compareColumn + "]\u5b57\u6bb5,\u8bf7\u68c0\u67e5cache=" + translate.getExtend().cache + "\u7684\u7f13\u5b58\u7ffb\u8bd1,\u5176\u903b\u8f91\u8868\u8fbe\u5f0fwhere\u7684\u914d\u7f6e!");
            }
        });
    }

    private static Object getLinkColumnsId(ResultSet rs, String[] columns) throws Exception {
        if (columns.length == 1) {
            return rs.getObject(columns[0]);
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (String column : columns) {
            Object colValue;
            if (index > 0) {
                result.append("_");
            }
            result.append((colValue = rs.getObject(column)) == null ? "null" : colValue.toString());
            ++index;
        }
        return result.toString();
    }

    private static List getMoreLinkResultSet(SqlToyConfig sqlToyConfig, SqlToyContext sqlToyContext, DecryptHandler decryptHandler, Connection conn, ResultSet rs, int rowCnt, HashMap<String, Integer> labelIndexMap, String[] labelNames, int startColIndex) throws Exception {
        List tempRow;
        int i;
        LinkModel linkModel = sqlToyConfig.getLinkModel();
        ArrayList<List> items = new ArrayList<List>();
        Boolean hasTranslate = !sqlToyConfig.getTranslateMap().isEmpty();
        HashMap<String, String> lowKeyLabelNameMap = ResultUtils.labelLowKeyMap(labelNames);
        HashMap<String, FieldTranslate> translateMap = sqlToyConfig.getTranslateMap();
        HashMap<String, FieldTranslateCacheHolder> fieldTranslateCacheHolders = null;
        DynamicCacheFetch dynamicCacheFetch = sqlToyContext.getDynamicCacheFetch();
        if (hasTranslate.booleanValue()) {
            ResultUtils.validateCacheConfig(translateMap, lowKeyLabelNameMap);
            fieldTranslateCacheHolders = sqlToyContext.getTranslateManager().getTranslates(translateMap);
        }
        int columnSize = labelNames.length;
        int index = 0;
        int warnThresholds = SqlToyConstants.getWarnThresholds();
        boolean warnLimit = false;
        long maxThresholds = SqlToyConstants.getMaxThresholds();
        boolean maxLimit = false;
        boolean ignoreAllEmpty = sqlToyConfig.isIgnoreEmpty();
        if (maxThresholds > 1L && maxThresholds <= (long)warnThresholds) {
            maxThresholds = warnThresholds;
        }
        int linkColCnt = linkModel.getColumns().length;
        String[] linkColumns = linkModel.getColumns();
        int[] linkIndexs = new int[linkColCnt];
        String[] linkRealLabels = new String[linkColCnt];
        boolean[] translateLinks = new boolean[linkColCnt];
        StringBuilder[] linkBuffers = new StringBuilder[linkColCnt];
        HashSet[] linkSets = linkModel.isDistinct() ? new HashSet[linkColCnt] : null;
        String[] linkLowColumns = new String[linkColCnt];
        for (int i2 = 0; i2 < linkColCnt; ++i2) {
            String linkColumnLow;
            linkBuffers[i2] = new StringBuilder();
            linkLowColumns[i2] = linkColumnLow = linkColumns[i2].toLowerCase();
            if (!labelIndexMap.containsKey(linkColumnLow)) {
                throw new DataAccessException("\u505alink\u64cd\u4f5c\u65f6,\u67e5\u8be2\u7ed3\u679c\u5b57\u6bb5\u4e2d\u6ca1\u6709\u5b57\u6bb5:" + linkColumnLow + ",\u8bf7\u68c0\u67e5sql\u6216link \u914d\u7f6e\u7684\u6b63\u786e\u6027!");
            }
            linkRealLabels[i2] = lowKeyLabelNameMap.get(linkColumnLow);
            linkIndexs[i2] = labelIndexMap.get(linkColumnLow);
            if (hasTranslate.booleanValue()) {
                translateLinks[i2] = translateMap.containsKey(linkColumnLow);
            }
            if (!linkModel.isDistinct()) continue;
            linkSets[i2] = new HashSet();
        }
        boolean hasDecorate = linkModel.getDecorateAppendChar() != null;
        boolean isLeft = true;
        if (hasDecorate) {
            isLeft = "left".equals(linkModel.getDecorateAlign());
        }
        String preIdentity = null;
        Object[] linkValues = new Object[linkColCnt];
        String[] linkStrs = new String[linkColCnt];
        String identity = null;
        boolean isLastProcess = false;
        boolean doLink = false;
        while (rs.next()) {
            isLastProcess = false;
            for (i = 0; i < linkColCnt; ++i) {
                FieldTranslateCacheHolder fieldTranslateCacheHolder;
                Object tmpObject;
                linkValues[i] = rs.getObject(linkRealLabels[i]);
                linkStrs[i] = linkValues[i] == null ? "" : (translateLinks[i] ? ((tmpObject = (fieldTranslateCacheHolder = fieldTranslateCacheHolders.get(linkLowColumns[i])).getRSCacheValue(dynamicCacheFetch, rs, lowKeyLabelNameMap, linkValues[i].toString())) == null ? linkValues[i].toString() : tmpObject.toString()) : linkValues[i].toString());
            }
            String string = identity = linkModel.getGroupColumns() == null ? "default" : ResultUtils.getLinkColumnsId(rs, linkModel.getGroupColumns());
            if (!identity.equals(preIdentity)) {
                if (index != 0) {
                    tempRow = (List)items.get(items.size() - 1);
                    for (i = 0; i < linkColCnt; ++i) {
                        tempRow.set(linkIndexs[i], linkBuffers[i].toString());
                        linkBuffers[i].delete(0, linkBuffers[i].length());
                        if (!linkModel.isDistinct()) continue;
                        linkSets[i].clear();
                    }
                }
                for (i = 0; i < linkColCnt; ++i) {
                    linkBuffers[i].append(linkStrs[i]);
                    if (!linkModel.isDistinct()) continue;
                    linkSets[i].add(linkStrs[i]);
                }
                tempRow = ResultUtils.processResultRow(dynamicCacheFetch, rs, labelNames, lowKeyLabelNameMap, columnSize, fieldTranslateCacheHolders, decryptHandler, ignoreAllEmpty);
                if (tempRow != null) {
                    items.add(tempRow);
                }
                preIdentity = identity;
            } else {
                isLastProcess = true;
                for (i = 0; i < linkColCnt; ++i) {
                    doLink = true;
                    if (linkModel.isDistinct()) {
                        if (linkSets[i].contains(linkStrs[i])) {
                            doLink = false;
                        }
                        linkSets[i].add(linkStrs[i]);
                    }
                    if (!doLink) continue;
                    if (linkBuffers[i].length() > 0) {
                        linkBuffers[i].append(linkModel.getSign());
                    }
                    linkBuffers[i].append(hasDecorate ? StringUtil.appendStr(linkStrs[i], linkModel.getDecorateAppendChar(), linkModel.getDecorateSize(), isLeft) : linkStrs[i]);
                }
            }
            if (++index == warnThresholds) {
                warnLimit = true;
            }
            if ((long)index != maxThresholds) continue;
            maxLimit = true;
            break;
        }
        if (isLastProcess) {
            tempRow = (List)items.get(items.size() - 1);
            for (i = 0; i < linkColCnt; ++i) {
                tempRow.set(linkIndexs[i], linkBuffers[i].toString());
            }
        }
        if (warnLimit) {
            ResultUtils.warnLog(sqlToyConfig, index);
        }
        if (maxLimit) {
            logger.error("MaxLargeResult:\u6267\u884csql\u63d0\u53d6\u6570\u636e\u8d85\u51fa\u6700\u5927\u9600\u503c\u9650\u5236{}(\u53ef\u901a\u8fc7[spring.sqltoy.pageFetchSizeLimit]\u53c2\u6570\u8c03\u6574),sqlId={},\u5177\u4f53\u8bed\u53e5={}", new Object[]{index, sqlToyConfig.getId(), sqlToyConfig.getSql(null)});
        }
        return items;
    }

    private static List pivotResult(PivotModel pivotModel, LabelIndexModel labelIndexMap, List result, List pivotCategorySet) {
        if (result == null || result.isEmpty()) {
            return result;
        }
        if (pivotModel.getGroupCols() == null || pivotModel.getCategoryCols().length == 0) {
            return CollectionUtil.convertColToRow(result, null);
        }
        Integer[] categoryCols = ResultUtils.mappingLabelIndex(pivotModel.getCategoryCols(), labelIndexMap);
        Integer[] pivotCols = ResultUtils.mappingLabelIndex(pivotModel.getStartEndCols(), labelIndexMap);
        Integer[] groupCols = ResultUtils.mappingLabelIndex(pivotModel.getGroupCols(), labelIndexMap);
        List categoryList = pivotCategorySet == null ? ResultUtils.extractCategory(result, categoryCols) : pivotCategorySet;
        return CollectionUtil.pivotList(result, categoryList, null, groupCols, categoryCols, (int)pivotCols[0], (int)pivotCols[pivotCols.length - 1], pivotModel.getDefaultValue());
    }

    private static Integer[] mappingLabelIndex(String[] columnLabels, LabelIndexModel labelIndexMap) {
        Integer[] result = new Integer[columnLabels.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = NumberUtil.isInteger(columnLabels[i]) ? Integer.valueOf(Integer.parseInt(columnLabels[i])) : labelIndexMap.get(columnLabels[i].toLowerCase());
        }
        return result;
    }

    private static HashMap<String, String> labelLowKeyMap(String[] labelNames) {
        HashMap<String, String> lowKeyMap = new HashMap<String, String>();
        for (String label : labelNames) {
            lowKeyMap.put(label.toLowerCase(), label);
        }
        return lowKeyMap;
    }

    private static List extractCategory(List items, Integer[] categoryCols) {
        int i;
        List<List> categoryList = new ArrayList<List>();
        HashSet<String> identitySet = new HashSet<String>();
        int categorySize = categoryCols.length;
        int size = items.size();
        for (i = 0; i < size; ++i) {
            List row = (List)items.get(i);
            String tmpStr = "";
            ArrayList categoryRow = new ArrayList();
            for (int j = 0; j < categorySize; ++j) {
                Object obj = row.get(categoryCols[j]);
                categoryRow.add(obj);
                tmpStr = tmpStr.concat(obj == null ? "null" : obj.toString());
            }
            if (identitySet.contains(tmpStr)) continue;
            categoryList.add(categoryRow);
            identitySet.add(tmpStr);
        }
        if (categoryCols.length > 1) {
            categoryList = ResultUtils.sortList(categoryList, 0, 0, categoryList.size() - 1, true);
            for (i = 1; i < categoryCols.length; ++i) {
                categoryList = ResultUtils.sortGroupList(categoryList, i - 1, i, true);
            }
        }
        return CollectionUtil.convertColToRow(categoryList, null);
    }

    private static List sortGroupList(List<List> sortList, int groupCol, int orderCol, boolean ascend) {
        int length = sortList.size();
        int start = 0;
        Object compareValue = null;
        for (int i = 0; i < length; ++i) {
            Object tempObj = sortList.get(i).get(groupCol);
            if (!tempObj.equals(compareValue)) {
                int end = i - 1;
                ResultUtils.sortList(sortList, orderCol, start, end, ascend);
                start = i;
                compareValue = tempObj;
            }
            if (i != length - 1) continue;
            ResultUtils.sortList(sortList, orderCol, start, i, ascend);
        }
        return sortList;
    }

    private static List sortList(List<List> sortList, int orderCol, int start, int end, boolean ascend) {
        if (end <= start) {
            return sortList;
        }
        boolean lessThen = false;
        int dataType = 1;
        boolean finishedJudgeType = false;
        for (int i = start; i < end; ++i) {
            for (int j = i + 1; j < end + 1; ++j) {
                Object iData = sortList.get(i).get(orderCol);
                Object jData = sortList.get(j).get(orderCol);
                if (iData == null && jData == null || iData != null && jData == null) {
                    lessThen = false;
                } else if (iData == null && jData != null) {
                    lessThen = true;
                } else {
                    if (!finishedJudgeType) {
                        if (iData instanceof Number) {
                            dataType = 2;
                        } else if (iData instanceof Date) {
                            dataType = 3;
                        } else if (iData instanceof LocalDate) {
                            dataType = 4;
                        } else if (iData instanceof LocalDateTime) {
                            dataType = 5;
                        } else if (iData instanceof LocalTime) {
                            dataType = 6;
                        }
                        finishedJudgeType = true;
                    }
                    if (dataType == 1) {
                        String str1 = iData.toString();
                        String str2 = jData.toString();
                        lessThen = str1.length() < str2.length() ? true : (str1.length() > str2.length() ? false : str1.compareTo(str2) < 0);
                    } else if (dataType == 2) {
                        lessThen = ((Number)iData).doubleValue() < ((Number)jData).doubleValue();
                    } else if (dataType == 3) {
                        lessThen = ((Date)iData).before((Date)jData);
                    } else if (dataType == 4) {
                        lessThen = ((LocalDate)iData).compareTo((LocalDate)jData) < 0;
                    } else if (dataType == 5) {
                        lessThen = ((LocalDateTime)iData).compareTo((LocalDateTime)jData) < 0;
                    } else if (dataType == 6) {
                        boolean bl = lessThen = ((LocalTime)iData).compareTo((LocalTime)jData) < 0;
                    }
                }
                if ((!ascend || lessThen) && (ascend || !lessThen)) continue;
                List tempList = sortList.get(i);
                sortList.set(i, sortList.get(j));
                sortList.set(j, tempList);
            }
        }
        return sortList;
    }

    public static List processResultRow(DynamicCacheFetch dynamicCacheFetch, ResultSet rs, String[] labelNames, HashMap<String, String> lowKeyLabelNameMap, int size, HashMap<String, FieldTranslateCacheHolder> translateCaches, DecryptHandler decryptHandler, boolean ignoreAllEmptySet) throws Exception {
        ArrayList<Object> rowData = new ArrayList<Object>();
        boolean allNull = true;
        String label = null;
        boolean isLabel = labelNames != null;
        boolean doTranslate = translateCaches != null;
        for (int i = 0; i < size; ++i) {
            Object fieldValue;
            if (isLabel) {
                label = labelNames[i];
                fieldValue = rs.getObject(label);
                label = label.toLowerCase();
            } else {
                fieldValue = rs.getObject(i + 1);
            }
            if (null != fieldValue) {
                FieldTranslateCacheHolder fieldTranslateHandler;
                if (fieldValue instanceof Clob) {
                    fieldValue = SqlUtil.clobToString((Clob)fieldValue);
                } else if (fieldValue instanceof Blob) {
                    Blob blob = (Blob)fieldValue;
                    int blobSize = (int)blob.length();
                    fieldValue = blobSize > 0 ? (Object)blob.getBytes(1L, blobSize) : (Object)new byte[0];
                }
                if (decryptHandler != null) {
                    fieldValue = decryptHandler.decrypt(label, fieldValue);
                }
                if (doTranslate && (fieldTranslateHandler = translateCaches.get(label)) != null) {
                    fieldValue = fieldTranslateHandler.getRSCacheValue(dynamicCacheFetch, rs, lowKeyLabelNameMap, fieldValue.toString());
                }
                allNull = false;
            }
            rowData.add(fieldValue);
        }
        if (allNull && ignoreAllEmptySet) {
            return null;
        }
        return rowData;
    }

    public static List getPivotCategory(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, Connection conn, Integer dbType, String dialect) throws Exception {
        ArrayList resultProcessors = new ArrayList();
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        if (!sqlToyConfig.getResultProcessor().isEmpty()) {
            resultProcessors.addAll(sqlToyConfig.getResultProcessor());
        }
        if (extend != null && !extend.calculators.isEmpty()) {
            resultProcessors.addAll(extend.calculators);
        }
        for (int i = 0; i < resultProcessors.size(); ++i) {
            PivotModel pivotModel;
            Object processor = resultProcessors.get(i);
            if (!(processor instanceof PivotModel) || (pivotModel = (PivotModel)processor).getCategorySql() == null) continue;
            SqlToyConfig pivotSqlConfig = DialectUtils.getUnifyParamsNamedConfig(sqlToyContext, sqlToyContext.getSqlToyConfig(pivotModel.getCategorySql(), SqlType.search, "", null), queryExecutor, dialect, false);
            SqlToyResult pivotSqlToyResult = SqlConfigParseUtils.processSql(pivotSqlConfig.getSql(dialect), extend.getParamsName(), extend.getParamsValue(sqlToyContext, pivotSqlConfig), dialect);
            pivotSqlToyResult = DialectUtils.doInterceptors(sqlToyContext, pivotSqlConfig, OperateType.search, pivotSqlToyResult, null, dbType);
            List pivotCategory = SqlUtil.findByJdbcQuery(sqlToyContext.getTypeHandler(), pivotSqlToyResult.getSql(), pivotSqlToyResult.getParamsValue(), null, null, null, conn, dbType, sqlToyConfig.isIgnoreEmpty(), null, SqlToyConstants.FETCH_SIZE, -1);
            return CollectionUtil.convertColToRow(pivotCategory, null);
        }
        return null;
    }

    public static boolean calculate(DesensitizeProvider desensitizeProvider, SqlToyConfig sqlToyConfig, DataSetResult dataSetResult, List pivotCategorySet, QueryExecutorExtend extend) {
        List items = dataSetResult.getRows();
        if (items == null || items.isEmpty()) {
            return false;
        }
        boolean changedCols = false;
        List<SecureMask> secureMasks = sqlToyConfig.getSecureMasks();
        List<FormatModel> formatModels = sqlToyConfig.getFormatModels();
        ArrayList resultProcessors = new ArrayList();
        if (!sqlToyConfig.getResultProcessor().isEmpty()) {
            resultProcessors.addAll(sqlToyConfig.getResultProcessor());
        }
        if (extend != null && !extend.calculators.isEmpty()) {
            resultProcessors.addAll(extend.calculators);
        }
        LabelIndexModel labelIndexMap = null;
        if (!(secureMasks.isEmpty() && formatModels.isEmpty() && (extend == null || extend.secureMask.isEmpty() && extend.colsFormat.isEmpty()) && resultProcessors.isEmpty())) {
            labelIndexMap = ResultUtils.wrapLabelIndexMap(dataSetResult.getLabelNames());
        }
        if (!secureMasks.isEmpty()) {
            ResultUtils.secureMask(desensitizeProvider, items, secureMasks.iterator(), labelIndexMap);
        }
        if (!formatModels.isEmpty()) {
            ResultUtils.formatColumn(items, formatModels.iterator(), labelIndexMap);
        }
        if (extend != null) {
            if (!extend.secureMask.isEmpty()) {
                ResultUtils.secureMask(desensitizeProvider, items, extend.secureMask.values().iterator(), labelIndexMap);
            }
            if (!extend.colsFormat.isEmpty()) {
                ResultUtils.formatColumn(items, extend.colsFormat.values().iterator(), labelIndexMap);
            }
        }
        if (!resultProcessors.isEmpty()) {
            for (int i = 0; i < resultProcessors.size(); ++i) {
                Object processor = resultProcessors.get(i);
                if (processor instanceof PivotModel) {
                    items = ResultUtils.pivotResult((PivotModel)processor, labelIndexMap, items, pivotCategorySet);
                    changedCols = true;
                    continue;
                }
                if (processor instanceof UnpivotModel) {
                    items = UnpivotList.process((UnpivotModel)processor, dataSetResult, labelIndexMap, items);
                    continue;
                }
                if (processor instanceof SummaryModel) {
                    GroupSummary.process((SummaryModel)processor, labelIndexMap, items);
                    continue;
                }
                if (processor instanceof ColsChainRelativeModel) {
                    ColsChainRelative.process((ColsChainRelativeModel)processor, labelIndexMap, items);
                    changedCols = true;
                    continue;
                }
                if (processor instanceof RowsChainRelativeModel) {
                    RowsChainRelativeModel rowChainModel = (RowsChainRelativeModel)processor;
                    RowsChainRelative.process(rowChainModel, labelIndexMap, items);
                    if (!rowChainModel.isInsert()) continue;
                    changedCols = true;
                    continue;
                }
                if (processor instanceof ReverseModel) {
                    ReverseList.process((ReverseModel)processor, labelIndexMap, items);
                    continue;
                }
                if (!(processor instanceof TreeSortModel)) continue;
                TreeDataSort.process((TreeSortModel)processor, labelIndexMap, items);
            }
            dataSetResult.setRows(items);
        }
        return changedCols;
    }

    private static LabelIndexModel wrapLabelIndexMap(String[] fields) {
        LabelIndexModel result = new LabelIndexModel();
        if (fields != null && fields.length > 0) {
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                String realLabelName = fields[i].toLowerCase();
                int index = realLabelName.indexOf(":");
                if (index != -1) {
                    realLabelName = realLabelName.substring(index + 1).trim();
                }
                result.put(realLabelName, i);
            }
        }
        return result;
    }

    public static List wrapQueryResult(SqlToyContext sqlToyContext, List queryResultRows, String[] labelNames, Class resultType, boolean changedCols, Boolean humpMapLabel, boolean hiberarchy, Class[] hiberarchyClasses, Map<Class, IgnoreKeyCaseMap<String, String>> fieldsMap) throws Exception {
        if (queryResultRows == null || queryResultRows.isEmpty() || resultType == null) {
            return queryResultRows;
        }
        if (resultType.equals(List.class) || resultType.equals(ArrayList.class) || resultType.equals(Collection.class) || BeanUtil.isBaseDataType(resultType)) {
            if (BeanUtil.isBaseDataType(resultType) && labelNames != null && labelNames.length == 1) {
                return ResultUtils.getFirstColumn(queryResultRows, resultType);
            }
            return queryResultRows;
        }
        if (Array.class.equals((Object)resultType)) {
            return CollectionUtil.innerListToArray(queryResultRows);
        }
        if (changedCols) {
            logger.warn("\u67e5\u8be2\u4e2d\u5b58\u5728\u7c7b\u4f3cpivot\u3001\u5217\u540c\u6bd4\u73af\u6bd4\u8ba1\u7b97\u5bfc\u81f4\u7ed3\u679c'\u5217'\u6570\u4e0d\u56fa\u5b9a\uff0c\u56e0\u6b64\u4e0d\u652f\u6301\u8f6cmap\u6216VO\u5bf9\u8c61!");
            SqlExecuteStat.debug("\u6620\u5c04\u7ed3\u679c\u7c7b\u578b\u9519\u8bef", "\u67e5\u8be2\u4e2d\u5b58\u5728\u7c7b\u4f3cpivot\u3001\u5217\u540c\u6bd4\u73af\u6bd4\u8ba1\u7b97\u5bfc\u81f4\u7ed3\u679c'\u5217'\u6570\u4e0d\u56fa\u5b9a\uff0c\u56e0\u6b64\u4e0d\u652f\u6301\u8f6cmap\u6216VO\u5bf9\u8c61!", new Object[0]);
        }
        if (null == labelNames) {
            throw new DataAccessException("wrapQueryResult\u5c01\u88c5\u6570\u636e\u5230[" + resultType.getTypeName() + "]\u65f6\u6570\u636elabelNames\u4e3anull,\u65e0\u6cd5\u63d0\u4f9b\u5c5e\u6027\u540d\u79f0\u6620\u5c04!");
        }
        if (Map.class.isAssignableFrom(resultType)) {
            boolean isHumpLabel;
            int width = labelNames.length;
            String[] realLabels = labelNames;
            boolean bl = isHumpLabel = humpMapLabel == null ? sqlToyContext.isHumpMapResultTypeLabel() : humpMapLabel.booleanValue();
            if (isHumpLabel) {
                realLabels = ResultUtils.humpFieldNames(labelNames, null);
            }
            ArrayList result = new ArrayList();
            boolean isMap = resultType.equals(Map.class);
            boolean isConMap = resultType.equals(ConcurrentMap.class);
            int n = queryResultRows.size();
            for (int i = 0; i < n; ++i) {
                List rowList = (List)queryResultRows.get(i);
                Map rowMap = isMap ? new HashMap() : (isConMap ? new ConcurrentHashMap() : (Map)resultType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                for (int j = 0; j < width; ++j) {
                    rowMap.put(realLabels[j], rowList.get(j));
                }
                result.add(rowMap);
            }
            return result;
        }
        HashMap<String, String> columnFieldMap = null;
        EntityMeta entityMeta = null;
        if (sqlToyContext.isEntity(resultType)) {
            entityMeta = sqlToyContext.getEntityMeta(resultType);
            columnFieldMap = entityMeta.getColumnFieldMap();
        }
        boolean hasCascade = false;
        List<TableCascadeModel> cascadeModel = null;
        if (hiberarchy && (cascadeModel = entityMeta != null ? entityMeta.getCascadeModels() : BeanUtil.getCascadeModels(resultType)) != null && !cascadeModel.isEmpty()) {
            hasCascade = true;
        }
        List result = null;
        if (!hasCascade) {
            result = BeanUtil.reflectListToBean(sqlToyContext.getTypeHandler(), queryResultRows, ResultUtils.convertRealProps(ResultUtils.wrapMapFields(labelNames, fieldsMap, resultType), columnFieldMap), resultType);
            ResultUtils.wrapResultTranslate(sqlToyContext, result, resultType);
        } else {
            result = ResultUtils.hiberarchySet(sqlToyContext, entityMeta, columnFieldMap, queryResultRows, labelNames, resultType, cascadeModel, hiberarchyClasses, fieldsMap);
        }
        return result;
    }

    public static <T> List<T> getFirstColumn(List rows, Class<T> classType) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (rows == null || rows.isEmpty()) {
            return result;
        }
        String typeName = classType.getTypeName();
        int typeValue = DataType.getType(classType);
        try {
            for (Object row : rows) {
                Object cell = ((List)row).get(0);
                result.add(BeanUtil.convertType(cell, typeValue, typeName));
            }
            return result;
        }
        catch (Exception e) {
            throw new DataAccessException("\u5207\u53d6\u5355\u5217\u67e5\u8be2\u7ed3\u679c\u8fdb\u884c\u7c7b\u578b\u8f6c\u6362\u65f6\u53d1\u751f\u5f02\u5e38!" + e.getMessage());
        }
    }

    private static String[] convertRealProps(String[] labelNames, HashMap<String, String> colFieldMap) {
        String[] result = (String[])labelNames.clone();
        if (colFieldMap != null && !colFieldMap.isEmpty()) {
            for (int i = 0; i < result.length; ++i) {
                String key = result[i].toLowerCase();
                if (!colFieldMap.containsKey(key)) continue;
                result[i] = colFieldMap.get(key);
            }
        }
        return result;
    }

    private static List hiberarchySet(SqlToyContext sqlToyContext, EntityMeta entityMeta, HashMap<String, String> columnFieldMap, List queryResultRows, String[] labelNames, Class resultType, List<TableCascadeModel> cascadeModels, Class[] hiberarchyClasses, Map<Class, IgnoreKeyCaseMap<String, String>> fieldsMap) throws Exception {
        Object masterBean;
        String[] realLabelNames;
        ArrayList masterData;
        Iterator<List> groupListIter;
        IgnoreKeyCaseMap<String, Integer> labelIndexs = new IgnoreKeyCaseMap<String, Integer>();
        int index = 0;
        for (String label : labelNames) {
            labelIndexs.put(label, index);
            labelIndexs.put(label.replace("_", ""), index);
            ++index;
        }
        TableCascadeModel oneToMany = ResultUtils.getOneToManyCascade(cascadeModels, hiberarchyClasses);
        int[] oneToManyGroupColIndexs = null;
        LinkedHashMap<String, List> groupListMap = null;
        if (oneToMany != null) {
            oneToManyGroupColIndexs = ResultUtils.getGroupColIndexs(oneToMany, labelIndexs);
            groupListMap = ResultUtils.hashGroupList(queryResultRows, oneToManyGroupColIndexs);
            groupListIter = groupListMap.values().iterator();
            masterData = new ArrayList();
            while (groupListIter.hasNext()) {
                masterData.add(groupListIter.next().get(0));
            }
        } else {
            masterData = queryResultRows;
        }
        List result = BeanUtil.reflectListToBean(sqlToyContext.getTypeHandler(), masterData, ResultUtils.convertRealProps(ResultUtils.wrapMapFields(labelNames, fieldsMap, resultType), columnFieldMap), resultType);
        ResultUtils.wrapResultTranslate(sqlToyContext, result, resultType);
        ArrayList<List> oneToOnes = new ArrayList<List>();
        ArrayList<String> oneToOneProps = new ArrayList<String>();
        ArrayList<String> oneToOneNotNullField = new ArrayList<String>();
        for (TableCascadeModel cascade : cascadeModels) {
            if (cascade.getCascadeType() != 2) continue;
            boolean hasCascade = false;
            if (hiberarchyClasses != null) {
                for (Class hiberarchyClass : hiberarchyClasses) {
                    if (!hiberarchyClass.equals(cascade.getMappedType())) continue;
                    hasCascade = true;
                    break;
                }
            } else {
                hasCascade = true;
            }
            if (!hasCascade) continue;
            realLabelNames = (String[])labelNames.clone();
            if (cascade.getMappedFields() != null && cascade.getMappedFields().length > 0) {
                int groupSize = cascade.getFields().length;
                int[] colIndexs = ResultUtils.getGroupColIndexs(cascade, labelIndexs);
                for (int i = 0; i < groupSize; ++i) {
                    realLabelNames[colIndexs[i]] = cascade.getMappedFields()[i];
                }
            }
            columnFieldMap = null;
            if (entityMeta != null && sqlToyContext.isEntity(cascade.getMappedType())) {
                columnFieldMap = sqlToyContext.getEntityMeta(cascade.getMappedType()).getColumnFieldMap();
            }
            List oneToOneList = BeanUtil.reflectListToBean(sqlToyContext.getTypeHandler(), masterData, ResultUtils.convertRealProps(ResultUtils.wrapMapFields(realLabelNames, fieldsMap, cascade.getMappedType()), columnFieldMap), cascade.getMappedType());
            ResultUtils.wrapResultTranslate(sqlToyContext, oneToOneList, cascade.getMappedType());
            oneToOnes.add(oneToOneList);
            oneToOneProps.add(cascade.getProperty());
            oneToOneNotNullField.add(cascade.getNotNullField());
        }
        if (!oneToOneProps.isEmpty()) {
            int oneToOneSize = oneToOneProps.size();
            int n = result.size();
            for (int i = 0; i < n; ++i) {
                masterBean = result.get(i);
                for (int j = 0; j < oneToOneSize; ++j) {
                    String property = (String)oneToOneProps.get(j);
                    String notNullField = (String)oneToOneNotNullField.get(j);
                    Object oneToOneBean = ((List)oneToOnes.get(j)).get(i);
                    if (notNullField != null) {
                        if (null == BeanUtil.getProperty(oneToOneBean, notNullField)) continue;
                        BeanUtil.setProperty(masterBean, property, oneToOneBean);
                        continue;
                    }
                    BeanUtil.setProperty(masterBean, property, oneToOneBean);
                }
            }
        }
        if (oneToMany != null) {
            realLabelNames = (String[])labelNames.clone();
            if (oneToMany.getMappedFields() != null && oneToMany.getMappedFields().length > 0) {
                for (int i = 0; i < oneToManyGroupColIndexs.length; ++i) {
                    realLabelNames[oneToManyGroupColIndexs[i]] = oneToMany.getMappedFields()[i];
                }
            }
            Class oneToManyClass = oneToMany.getMappedType();
            columnFieldMap = null;
            if (entityMeta != null && sqlToyContext.isEntity(oneToManyClass)) {
                columnFieldMap = sqlToyContext.getEntityMeta(oneToManyClass).getColumnFieldMap();
            }
            String property = oneToMany.getProperty();
            String notNullField = oneToMany.getNotNullField();
            groupListIter = groupListMap.values().iterator();
            index = 0;
            while (groupListIter.hasNext()) {
                masterBean = result.get(index);
                List item = BeanUtil.reflectListToBean(sqlToyContext.getTypeHandler(), groupListIter.next(), ResultUtils.convertRealProps(ResultUtils.wrapMapFields(realLabelNames, fieldsMap, oneToManyClass), columnFieldMap), oneToManyClass);
                if (notNullField != null) {
                    for (int k = 0; k < item.size(); ++k) {
                        if (BeanUtil.getProperty(item.get(k), notNullField) != null) continue;
                        item.remove(k);
                        --k;
                    }
                }
                if (!item.isEmpty()) {
                    ResultUtils.wrapResultTranslate(sqlToyContext, item, oneToManyClass);
                    BeanUtil.setProperty(masterBean, property, item);
                }
                ++index;
            }
        }
        return result;
    }

    private static int[] getGroupColIndexs(TableCascadeModel cascade, IgnoreKeyCaseMap<String, Integer> labelIndexs) {
        if (cascade == null) {
            return null;
        }
        String[] groupFields = cascade.getFields();
        int groupSize = groupFields.length;
        int[] colIndexs = new int[groupSize];
        String cascadeType = cascade.getCascadeType() == 1 ? "OneToMany" : "OneToOne";
        for (int i = 0; i < groupSize; ++i) {
            if (!labelIndexs.containsKey(groupFields[i])) {
                throw new DataAccessException("\u5c42\u6b21\u7ed3\u6784\u5c01\u88c5\u64cd\u4f5c,\u67e5\u8be2\u7ed3\u679c\u4e2d\u672a\u5305\u542b" + cascadeType + "\u7684\u5206\u7ec4\u5c5e\u6027(\u5bf9\u8c61\u5c5e\u6027\u540d\u79f0,\u6b63\u5e38\u4e0d\u5305\u542b\u4e0b\u5212\u7ebf):" + groupFields[i] + " \u5bf9\u5e94\u7684\u503c!");
            }
            colIndexs[i] = labelIndexs.get(groupFields[i]);
        }
        return colIndexs;
    }

    public static TableCascadeModel getOneToManyCascade(List<TableCascadeModel> cascadeModels, Class[] hiberarchyClasses) {
        TableCascadeModel oneToMany = null;
        int oneToManySize = 0;
        block0: for (TableCascadeModel cascade : cascadeModels) {
            if (cascade.getCascadeType() != 1) continue;
            if (hiberarchyClasses != null) {
                for (Class hiberarchyClass : hiberarchyClasses) {
                    if (!hiberarchyClass.equals(cascade.getMappedType())) continue;
                    oneToMany = cascade;
                    continue block0;
                }
                continue;
            }
            if (oneToMany == null) {
                oneToMany = cascade;
            }
            ++oneToManySize;
        }
        if (oneToManySize > 1 && hiberarchyClasses == null) {
            throw new IllegalArgumentException("\u8fd4\u56de\u4f9d\u7167\u5c42\u6b21\u7ed3\u6784\u7ed3\u679c\u65f6\uff0c\u5b58\u5728\u591a\u4e2aoneToMany\u6620\u5c04\u5173\u7cfb\uff0c\u5fc5\u987b\u8981\u6307\u660ehiberarchyClasses!");
        }
        return oneToMany;
    }

    private static String[] wrapMapFields(String[] labelNames, Map<Class, IgnoreKeyCaseMap<String, String>> resultTypeFieldsMap, Class resultType) {
        if (resultTypeFieldsMap == null || resultTypeFieldsMap.isEmpty()) {
            return (String[])labelNames.clone();
        }
        IgnoreKeyCaseMap<String, String> fieldsMap = resultTypeFieldsMap.get(resultType);
        if (fieldsMap == null || fieldsMap.isEmpty()) {
            return (String[])labelNames.clone();
        }
        String[] result = (String[])labelNames.clone();
        int size = result.length;
        for (int i = 0; i < size; ++i) {
            String fieldName = fieldsMap.get(result[i]);
            if (fieldName == null) continue;
            for (int j = 0; j < size; ++j) {
                if (!result[j].equalsIgnoreCase(fieldName) && !result[j].replace("_", "").equalsIgnoreCase(fieldName)) continue;
                result[j] = result[j] + "SqlToyIgnoreField";
            }
            result[i] = fieldName;
        }
        return result;
    }

    private static LinkedHashMap<String, List> hashGroupList(List queryResultRows, int[] groupIndexes) {
        LinkedHashMap<String, List> groupListMap = new LinkedHashMap<String, List>();
        String key = "";
        for (int i = 0; i < queryResultRows.size(); ++i) {
            List row = (List)queryResultRows.get(i);
            key = "";
            for (int j = 0; j < groupIndexes.length; ++j) {
                key = key + "," + row.get(groupIndexes[j]);
            }
            ArrayList<List> groupList = groupListMap.get(key);
            if (groupList == null) {
                groupList = new ArrayList<List>();
            }
            groupList.add(row);
            groupListMap.put(key, groupList);
        }
        return groupListMap;
    }

    public static String[] humpFieldNames(String[] labelNames, HashMap<String, String> colFieldMap) {
        if (labelNames == null) {
            return null;
        }
        String[] result = new String[labelNames.length];
        if (colFieldMap == null) {
            int n = labelNames.length;
            for (int i = 0; i < n; ++i) {
                result[i] = StringUtil.toHumpStr(labelNames[i], false);
            }
        } else {
            int n = labelNames.length;
            for (int i = 0; i < n; ++i) {
                result[i] = colFieldMap.get(labelNames[i].toLowerCase());
                if (result[i] != null) continue;
                result[i] = StringUtil.toHumpStr(labelNames[i], false);
            }
        }
        return result;
    }

    private static void warnLog(SqlToyConfig sqlToyConfig, int totalCount) {
        logger.warn("Large Result:totalCount={},sqlId={},sql={}", new Object[]{totalCount, sqlToyConfig.getId(), sqlToyConfig.getSql(null)});
    }

    private static Set<String> getStringColumns(SqlToyConfig sqlToyConfig) {
        HashSet<String> strSet = new HashSet<String>();
        if (sqlToyConfig.getTranslateMap() != null && !sqlToyConfig.getTranslateMap().isEmpty()) {
            strSet.addAll(sqlToyConfig.getTranslateMap().keySet());
        }
        if (sqlToyConfig.getLinkModel() != null) {
            for (String col : sqlToyConfig.getLinkModel().getColumns()) {
                strSet.add(col.toLowerCase());
            }
        }
        if (sqlToyConfig.getFormatModels() != null && !sqlToyConfig.getFormatModels().isEmpty()) {
            for (FormatModel fmt : sqlToyConfig.getFormatModels()) {
                strSet.add(fmt.getColumn());
            }
        }
        return strSet;
    }

    public static void wrapResultTranslate(SqlToyContext sqlToyContext, Object result, Class resultType) {
        ArrayList<Object> voList;
        HashMap<String, FieldTranslate> translateConfig = TranslateConfigParse.getClassTranslates(resultType);
        if (result == null || translateConfig == null || translateConfig.isEmpty()) {
            return;
        }
        if (result instanceof List) {
            voList = (ArrayList<Object>)result;
        } else {
            voList = new ArrayList<Object>();
            voList.add(result);
        }
        if (voList.isEmpty()) {
            return;
        }
        HashMap<String, FieldTranslateCacheHolder> fieldTranslateHandlers = sqlToyContext.getTranslateManager().getTranslates(translateConfig);
        DynamicCacheFetch dynamicCacheFetch = sqlToyContext.getDynamicCacheFetch();
        int n = voList.size();
        for (int i = 0; i < n; ++i) {
            ResultUtils.wrapBeanTranslate(dynamicCacheFetch, fieldTranslateHandlers, voList.get(i));
        }
    }

    private static void wrapBeanTranslate(DynamicCacheFetch dynamicCacheFetch, HashMap<String, FieldTranslateCacheHolder> fieldTranslateHandlers, Object item) {
        fieldTranslateHandlers.forEach((fieldName, fieldTranslateHandler) -> {
            Object srcFieldValue = BeanUtil.getProperty(item, fieldTranslateHandler.getKeyField());
            Object fieldValue = BeanUtil.getProperty(item, fieldName);
            if (srcFieldValue != null && !"".equals(srcFieldValue.toString()) && fieldValue == null) {
                BeanUtil.setProperty(item, fieldName, fieldTranslateHandler.getBeanCacheValue(dynamicCacheFetch, item, srcFieldValue.toString()));
            }
        });
    }
}

