/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.util.HashMap;
import org.sagacity.sqltoy.model.inner.TranslateExtend;
import org.sagacity.sqltoy.translate.DynamicCacheFetch;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateUtils {
    protected static final Logger logger = LoggerFactory.getLogger(TranslateUtils.class);

    public static Object translateKey(TranslateExtend translateExtend, DynamicCacheFetch dynamicCacheFetch, HashMap<String, Object[]> cacheData, Object fieldValue) {
        String fieldStr = fieldValue.toString();
        if (translateExtend.splitRegex == null) {
            Object[] cacheValues;
            if (translateExtend.keyTemplate != null) {
                fieldStr = translateExtend.keyTemplate.replace("{}", fieldStr);
            }
            if ((cacheValues = cacheData.get(fieldStr)) == null || cacheValues.length == 0) {
                if (translateExtend.uncached != null) {
                    fieldValue = translateExtend.uncached.replace("${value}", fieldStr);
                } else {
                    fieldValue = fieldValue.toString();
                    logger.warn("translate cache:{},cacheType:{}, \u5bf9\u5e94\u7684key:{}\u6ca1\u6709\u8bbe\u7f6e\u76f8\u5e94\u7684value!", new Object[]{translateExtend.cache, translateExtend.cacheType, fieldValue});
                }
            } else {
                fieldValue = cacheValues[translateExtend.index];
            }
            return fieldValue;
        }
        String[] keys = StringUtil.splitRegex(fieldStr, translateExtend.splitRegex, true);
        String linkSign = translateExtend.linkSign;
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (String key : keys) {
            Object[] cacheValues;
            if (index > 0) {
                result.append(linkSign);
            }
            if ((cacheValues = cacheData.get(key)) == null || cacheValues.length == 0) {
                if (translateExtend.uncached != null) {
                    result.append(translateExtend.uncached.replace("${value}", key));
                } else {
                    result.append(key);
                    logger.warn("translate cache:{},cacheType:{}, \u5bf9\u5e94\u7684key:{}\u6ca1\u6709\u8bbe\u7f6e\u76f8\u5e94\u7684value!", new Object[]{translateExtend.cache, translateExtend.cacheType, key});
                }
            } else {
                result.append(cacheValues[translateExtend.index]);
            }
            ++index;
        }
        return result.toString();
    }

    public static boolean judgeTranslate(Object sourceValue, String compareType, String[] compareValues) {
        String sourceStr;
        String string = sourceStr = sourceValue == null ? "null" : sourceValue.toString().toLowerCase();
        if (compareType.equals("eq")) {
            return compareValues[0].equals(sourceStr);
        }
        if (compareType.equals("neq")) {
            return !compareValues[0].equals(sourceStr);
        }
        if (compareType.equals("in")) {
            for (String compareStr : compareValues) {
                if (!compareStr.equals(sourceStr)) continue;
                return true;
            }
            return false;
        }
        if (compareType.equals("out")) {
            for (String compareStr : compareValues) {
                if (!compareStr.equals(sourceStr)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

