/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.auth.Audience;
import com.salesforce.datacloud.jdbc.auth.PrivateKeyAuthenticationSettings;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import lombok.Generated;

final class JwtParts {
    private static final String JWT_CREATION_FAILURE = "JWT assertion creation failed. Please check Username, Client Id, Private key and try again.";
    private static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";

    public static String buildJwt(PrivateKeyAuthenticationSettings settings) throws DataCloudJDBCException {
        try {
            Instant now = Instant.now();
            Audience audience = Audience.of(settings.getLoginUrl());
            RSAPrivateKey privateKey = JwtParts.asPrivateKey(settings.getPrivateKey());
            return ((JwtBuilder)((JwtBuilder)((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setIssuer(settings.getClientId())).setSubject(settings.getUserName())).setAudience(audience.url)).setIssuedAt(Date.from(now))).setExpiration(Date.from(now.plus(2L, ChronoUnit.MINUTES)))).signWith((Key)privateKey, SignatureAlgorithm.RS256).compact();
        }
        catch (Exception ex) {
            throw new DataCloudJDBCException(JWT_CREATION_FAILURE, "28000", (Throwable)ex);
        }
    }

    private static RSAPrivateKey asPrivateKey(String privateKey) throws SQLException {
        String rsaPrivateKey = privateKey.replaceFirst(BEGIN_PRIVATE_KEY, "").replaceFirst(END_PRIVATE_KEY, "").replaceAll("\\s", "");
        byte[] bytes = JwtParts.decodeBase64(rsaPrivateKey);
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)factory.generatePrivate(keySpec);
        }
        catch (Exception ex) {
            throw new DataCloudJDBCException(JWT_CREATION_FAILURE, "28000", (Throwable)ex);
        }
    }

    private static byte[] decodeBase64(String input) {
        return Base64.getDecoder().decode(input);
    }

    @Generated
    private JwtParts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

