/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.http;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCacheInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataCacheInterceptor.class);
    private static final MediaType mediaType = MediaType.parse((String)"application/json");
    private final Cache<String, String> metaDataCache;

    public MetadataCacheInterceptor(Properties properties) {
        Integer metaDataCacheDurationInMs = PropertiesExtensions.getIntegerOrDefault((Properties)properties, (String)"metadataCacheTtlMs", (Integer)10000);
        this.metaDataCache = CacheBuilder.newBuilder().expireAfterWrite((long)metaDataCacheDurationInMs.intValue(), TimeUnit.MILLISECONDS).maximumSize(10L).build();
    }

    @NonNull
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        if (chain == null) {
            throw new IllegalArgumentException("chain is marked non-null but is null");
        }
        Request request = chain.request();
        String cacheKey = request.url().toString();
        String cachedResponse = (String)this.metaDataCache.getIfPresent((Object)cacheKey);
        Response.Builder builder = new Response.Builder().code(200).request(request).protocol(Protocol.HTTP_1_1).message("OK");
        if (cachedResponse != null) {
            log.trace("Getting the metadata response from local cache");
            builder.body(ResponseBody.create((String)cachedResponse, (MediaType)mediaType));
        } else {
            log.trace("Cache miss for metadata response. Getting from server");
            Response response = chain.proceed(request);
            if (response.isSuccessful()) {
                Optional.of(response).map(Response::body).map(t -> {
                    try {
                        return t.string();
                    }
                    catch (IOException ex) {
                        log.error("Caught exception when extracting body from response. {}", (Object)cacheKey, (Object)ex);
                        return null;
                    }
                }).ifPresent(responseString -> {
                    builder.body(ResponseBody.create((String)responseString, (MediaType)mediaType));
                    this.metaDataCache.put((Object)cacheKey, responseString);
                });
            } else {
                return response;
            }
        }
        return builder.build();
    }
}

