/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.auth.AuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.PasswordAuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.PasswordAuthenticationStrategy;
import com.salesforce.datacloud.jdbc.auth.PrivateKeyAuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.PrivateKeyAuthenticationStrategy;
import com.salesforce.datacloud.jdbc.auth.RefreshTokenAuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.RefreshTokenAuthenticationStrategy;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.http.FormCommand;
import java.sql.SQLException;
import java.util.Properties;
import lombok.Generated;
import lombok.NonNull;

interface AuthenticationStrategy {
    public static AuthenticationStrategy of(@NonNull Properties properties) throws DataCloudJDBCException {
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        AuthenticationSettings settings = AuthenticationSettings.of(properties);
        return AuthenticationStrategy.of(settings);
    }

    public static AuthenticationStrategy of(@NonNull AuthenticationSettings settings) throws DataCloudJDBCException {
        if (settings == null) {
            throw new IllegalArgumentException("settings is marked non-null but is null");
        }
        if (settings instanceof PasswordAuthenticationSettings) {
            return new PasswordAuthenticationStrategy((PasswordAuthenticationSettings)settings);
        }
        if (settings instanceof PrivateKeyAuthenticationSettings) {
            return new PrivateKeyAuthenticationStrategy((PrivateKeyAuthenticationSettings)settings);
        }
        if (settings instanceof RefreshTokenAuthenticationSettings) {
            return new RefreshTokenAuthenticationStrategy((RefreshTokenAuthenticationSettings)settings);
        }
        IllegalArgumentException rootCauseException = new IllegalArgumentException("Resolved settings were an unknown type of AuthenticationSettings");
        throw new DataCloudJDBCException("Resolved settings were an unknown type of AuthenticationSettings", "28000", (Throwable)rootCauseException);
    }

    public FormCommand buildAuthenticate() throws SQLException;

    public AuthenticationSettings getSettings();

    public static final class Keys {
        static final String GRANT_TYPE = "grant_type";
        static final String CLIENT_ID = "client_id";
        static final String CLIENT_SECRET = "client_secret";
        static final String USER_AGENT = "User-Agent";

        @Generated
        private Keys() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class Messages {
        static final String UNKNOWN_SETTINGS_TYPE = "Resolved settings were an unknown type of AuthenticationSettings";

        @Generated
        private Messages() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

