/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.http;

import com.salesforce.datacloud.jdbc.http.HttpClientLogger;
import com.salesforce.datacloud.jdbc.http.MetadataCacheInterceptor;
import com.salesforce.datacloud.jdbc.http.internal.SFDefaultSocketFactoryWrapper;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientBuilder.class);
    static final String LOG_LEVEL = "okhttp.logging.level";
    static final HttpLoggingInterceptor.Level DEFAULT_LOG_LEVEL = HttpLoggingInterceptor.Level.BASIC;
    static final String READ_TIME_OUT_SECONDS_KEY = "readTimeOutSeconds";
    static final int DEFAULT_READ_TIME_OUT_SECONDS = 600;
    static final String CONNECT_TIME_OUT_SECONDS_KEY = "connectTimeOutSeconds";
    static final int DEFAULT_CONNECT_TIME_OUT_SECONDS = 600;
    static final String CALL_TIME_OUT_SECONDS_KEY = "callTimeOutSeconds";
    static final int DEFAULT_CALL_TIME_OUT_SECONDS = 600;
    static final String DISABLE_SOCKS_PROXY_KEY = "disableSocksProxy";
    static final Boolean DISABLE_SOCKS_PROXY_DEFAULT = false;

    public static OkHttpClient buildOkHttpClient(Properties properties) {
        Boolean disableSocksProxy = PropertiesExtensions.optional((Properties)properties, (String)DISABLE_SOCKS_PROXY_KEY).map(Boolean::valueOf).orElse(DISABLE_SOCKS_PROXY_DEFAULT);
        Integer readTimeout = PropertiesExtensions.getIntegerOrDefault((Properties)properties, (String)READ_TIME_OUT_SECONDS_KEY, (Integer)600);
        Integer connectTimeout = PropertiesExtensions.getIntegerOrDefault((Properties)properties, (String)CONNECT_TIME_OUT_SECONDS_KEY, (Integer)600);
        Integer callTimeout = PropertiesExtensions.getIntegerOrDefault((Properties)properties, (String)CALL_TIME_OUT_SECONDS_KEY, (Integer)600);
        HttpLoggingInterceptor.Level level = (HttpLoggingInterceptor.Level)PropertiesExtensions.getEnumOrDefault((Properties)properties, (String)LOG_LEVEL, (Enum)DEFAULT_LOG_LEVEL);
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new HttpClientLogger());
        loggingInterceptor.setLevel(level);
        return new OkHttpClient.Builder().socketFactory((SocketFactory)new SFDefaultSocketFactoryWrapper(disableSocksProxy)).callTimeout((long)callTimeout.intValue(), TimeUnit.SECONDS).connectTimeout((long)connectTimeout.intValue(), TimeUnit.SECONDS).readTimeout((long)readTimeout.intValue(), TimeUnit.SECONDS).addInterceptor((Interceptor)new MetadataCacheInterceptor(properties)).addInterceptor((Interceptor)loggingInterceptor).build();
    }

    @Generated
    private ClientBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

