/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.salesforce.datacloud.jdbc.util.Result;
import com.salesforce.datacloud.jdbc.util.ThrowingSupplier;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;

public final class StreamUtilities {
    public static <T> Stream<T> lazyLimitedStream(Supplier<Stream<T>> streamSupplier, LongSupplier limitSupplier) {
        return streamSupplier.get().limit(limitSupplier.getAsLong());
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 16);
        return StreamSupport.stream(spliterator, false);
    }

    public static <T, E extends Exception> Optional<T> tryTimes(int times, ThrowingSupplier<T, E> attempt, Consumer<Throwable> consumer) {
        return Stream.iterate(attempt, UnaryOperator.identity()).limit(times).map(Result::of).filter(r -> {
            if (r.getError().isPresent()) {
                consumer.accept(r.getError().get());
                return false;
            }
            return true;
        }).findFirst().flatMap(Result::get);
    }

    public static <T> Stream<T> takeWhile(Stream<T> stream, final Predicate<T> predicate) {
        final Spliterator split = stream.spliterator();
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(split.estimateSize(), split.characteristics()){
            boolean shouldContinue;
            {
                super(x0, x1);
                this.shouldContinue = true;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                return this.shouldContinue && split.tryAdvance(elem -> {
                    if (predicate.test(elem)) {
                        action.accept(elem);
                    } else {
                        this.shouldContinue = false;
                    }
                });
            }
        }, false);
    }

    @Generated
    private StreamUtilities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

