/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.google.common.collect.ImmutableList;
import com.salesforce.datacloud.jdbc.util.StringCompatibility;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesExtensions {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertiesExtensions.class);

    public static Optional<String> optional(Properties properties, String key) {
        if (properties == null) {
            return Optional.empty();
        }
        if (key == null || !properties.containsKey(key)) {
            return Optional.empty();
        }
        String value = properties.getProperty(key);
        return value == null || StringCompatibility.isBlank(value) ? Optional.empty() : Optional.of(value);
    }

    public static String required(Properties properties, String key) {
        Optional<String> result = PropertiesExtensions.optional(properties, key);
        if (!result.isPresent()) {
            throw new IllegalArgumentException("Properties missing required value for key: " + key);
        }
        return result.get();
    }

    public static Properties copy(Properties properties, Set<String> filterKeys) {
        Properties result = new Properties();
        for (String key : filterKeys) {
            String value = properties.getProperty(key);
            if (value == null) continue;
            result.setProperty(key, value);
        }
        return result;
    }

    public static Integer getIntegerOrDefault(Properties properties, String key, Integer defaultValue) {
        return PropertiesExtensions.optional(properties, key).map(PropertiesExtensions::toIntegerOrNull).orElse(defaultValue);
    }

    public static Integer toIntegerOrNull(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Boolean getBooleanOrDefault(Properties properties, String key, Boolean defaultValue) {
        return PropertiesExtensions.optional(properties, key).map(PropertiesExtensions::toBooleanOrDefault).orElse(defaultValue);
    }

    public static Boolean toBooleanOrDefault(String s) {
        return Boolean.valueOf(s);
    }

    public static <T extends Enum<T>> T getEnumOrDefault(Properties properties, String key, T defaultValue) {
        Class enumClass = defaultValue.getDeclaringClass();
        return (T)PropertiesExtensions.optional(properties, key).map(str -> PropertiesExtensions.toEnumOrDefault(str, enumClass)).orElse(defaultValue);
    }

    public static <T extends Enum<T>> T toEnumOrDefault(String s, Class<T> enumClass) {
        if (s == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, s);
        }
        catch (Exception ex) {
            log.warn("Failed to parse enum value: {}", (Object)s, (Object)ex);
            return null;
        }
    }

    public static List<String> getListOrDefault(Properties properties, String key, String ... defaults) {
        return PropertiesExtensions.optional(properties, key).map(PropertiesExtensions::toList).orElse((List)ImmutableList.copyOf((Object[])defaults));
    }

    public static List<String> toList(String s) {
        return Arrays.stream(s.split(",")).map(String::trim).filter(StringCompatibility::isNotEmpty).collect(Collectors.toList());
    }

    @Generated
    private PropertiesExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static final class Messages {
        static final String REQUIRED_MISSING_PREFIX = "Properties missing required value for key: ";

        @Generated
        private Messages() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

