/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface ThrowingSupplier<T, E extends Exception> {
    public T get() throws E;

    public static <T, E extends Exception, R> Supplier<Stream<R>> rethrowSupplier(ThrowingSupplier<T, E> function) throws E {
        return () -> {
            try {
                return (Stream)function.get();
            }
            catch (Exception exception) {
                ThrowingSupplier.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T, E extends Exception> LongSupplier rethrowLongSupplier(ThrowingSupplier<T, E> function) throws E {
        return () -> {
            try {
                return (Long)function.get();
            }
            catch (Exception exception) {
                ThrowingSupplier.throwAsUnchecked(exception);
                return Long.parseLong(null);
            }
        };
    }

    public static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }
}

