/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.config;

import com.salesforce.datacloud.jdbc.config.DriverVersionInfo;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public final class DriverVersion {
    private static final String DRIVER_NAME = "salesforce-datacloud-jdbc";
    private static final String DATABASE_PRODUCT_NAME = "salesforce-datacloud-queryservice";
    private static final String DATABASE_PRODUCT_VERSION = "1.0";
    private static final AtomicReference<Object> driverVersionInfo = new AtomicReference();

    private DriverVersion() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static int getMajorVersion() {
        return DriverVersion.getDriverVersionInfo().getMajor();
    }

    public static int getMinorVersion() {
        return DriverVersion.getDriverVersionInfo().getMinor();
    }

    public static String getDriverName() {
        return DRIVER_NAME;
    }

    public static String getProductName() {
        return DATABASE_PRODUCT_NAME;
    }

    public static String getProductVersion() {
        return DATABASE_PRODUCT_VERSION;
    }

    public static String formatDriverInfo() {
        return String.format("%s/%s", DriverVersion.getDriverName(), DriverVersion.getDriverVersionInfo());
    }

    public static String getDriverVersion() {
        return DriverVersion.getDriverVersionInfo().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static DriverVersionInfo getDriverVersionInfo() {
        Object $value = driverVersionInfo.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = driverVersionInfo;
            synchronized (atomicReference) {
                $value = driverVersionInfo.get();
                if ($value == null) {
                    DriverVersionInfo actualValue = DriverVersionInfo.of();
                    $value = actualValue == null ? driverVersionInfo : actualValue;
                    driverVersionInfo.set($value);
                }
            }
        }
        return (DriverVersionInfo)($value == driverVersionInfo ? null : $value);
    }
}

