/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Exception> {
    public static <T, R, E extends Exception> Function<T, R> rethrowFunction(ThrowingFunction<T, R, E> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                ThrowingFunction.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    public R apply(T var1) throws E;
}

