/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.auth.AuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.DataCloudTokenProcessor;
import com.salesforce.datacloud.jdbc.auth.TokenProcessor;
import com.salesforce.datacloud.jdbc.core.DataCloudDatabaseMetadata;
import com.salesforce.datacloud.jdbc.core.DataCloudPreparedStatement;
import com.salesforce.datacloud.jdbc.core.DataCloudStatement;
import com.salesforce.datacloud.jdbc.core.DefaultParameterManager;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.http.ClientBuilder;
import com.salesforce.datacloud.jdbc.interceptor.AuthorizationHeaderInterceptor;
import com.salesforce.datacloud.jdbc.interceptor.DataspaceHeaderInterceptor;
import com.salesforce.datacloud.jdbc.interceptor.HyperDefaultsHeaderInterceptor;
import com.salesforce.datacloud.jdbc.interceptor.TracingHeadersInterceptor;
import com.salesforce.datacloud.jdbc.interceptor.UserAgentHeaderInterceptor;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelBuilder;
import java.net.URI;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudConnection
implements Connection,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudConnection.class);
    private static final int DEFAULT_PORT = 443;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final TokenProcessor tokenProcessor;
    @NonNull
    private final Properties properties;
    private List<ClientInterceptor> interceptors;
    @NonNull
    private final HyperGrpcClientExecutor executor;

    public static DataCloudConnection fromChannel(@NonNull ManagedChannelBuilder<?> builder, Properties properties) throws SQLException {
        if (builder == null) {
            throw new IllegalArgumentException("builder is marked non-null but is null");
        }
        List<ClientInterceptor> interceptors = DataCloudConnection.getClientInterceptors(null, properties);
        HyperGrpcClientExecutor executor = HyperGrpcClientExecutor.of(builder.intercept(interceptors), properties);
        return DataCloudConnection.builder().executor(executor).properties(properties).build();
    }

    public static DataCloudConnection fromTokenSupplier(AuthorizationHeaderInterceptor authInterceptor, @NonNull String host, int port, Properties properties) throws SQLException {
        if (host == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        ManagedChannelBuilder channel = ManagedChannelBuilder.forAddress((String)host, (int)port);
        return DataCloudConnection.fromTokenSupplier(authInterceptor, channel, properties);
    }

    public static DataCloudConnection fromTokenSupplier(AuthorizationHeaderInterceptor authInterceptor, @NonNull ManagedChannelBuilder<?> builder, Properties properties) throws SQLException {
        if (builder == null) {
            throw new IllegalArgumentException("builder is marked non-null but is null");
        }
        List<ClientInterceptor> interceptors = DataCloudConnection.getClientInterceptors(authInterceptor, properties);
        HyperGrpcClientExecutor executor = HyperGrpcClientExecutor.of(builder.intercept(interceptors), properties);
        return DataCloudConnection.builder().executor(executor).properties(properties).build();
    }

    static List<ClientInterceptor> getClientInterceptors(AuthorizationHeaderInterceptor authInterceptor, Properties properties) {
        return Stream.of(authInterceptor, new HyperDefaultsHeaderInterceptor(), TracingHeadersInterceptor.of(), UserAgentHeaderInterceptor.of(properties), DataspaceHeaderInterceptor.of(properties)).filter(Objects::nonNull).peek(t -> log.info("Registering interceptor. interceptor={}", t)).collect(Collectors.toList());
    }

    public static DataCloudConnection of(String url, Properties properties) throws SQLException {
        String serviceRootUrl = DataCloudConnection.getServiceRootUrl(url);
        properties.put("loginURL", serviceRootUrl);
        DataCloudConnection.addClientUsernameIfRequired(properties);
        if (!AuthenticationSettings.hasAny(properties)) {
            throw new DataCloudJDBCException("No authentication settings provided");
        }
        DataCloudTokenProcessor tokenProcessor = DataCloudTokenProcessor.of(properties);
        String host = tokenProcessor.getDataCloudToken().getTenantUrl();
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)host, (int)443);
        AuthorizationHeaderInterceptor authInterceptor = AuthorizationHeaderInterceptor.of(tokenProcessor);
        List<ClientInterceptor> interceptors = DataCloudConnection.getClientInterceptors(authInterceptor, properties);
        HyperGrpcClientExecutor executor = HyperGrpcClientExecutor.of(builder.intercept(interceptors), properties);
        return DataCloudConnection.builder().tokenProcessor(tokenProcessor).executor(executor).properties(properties).build();
    }

    @Override
    public Statement createStatement() {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return this.getQueryPreparedStatement(sql);
    }

    private DataCloudPreparedStatement getQueryPreparedStatement(String sql) {
        return new DataCloudPreparedStatement(this, sql, new DefaultParameterManager());
    }

    @Override
    public CallableStatement prepareCall(String sql) {
        return null;
    }

    @Override
    public String nativeSQL(String sql) {
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
    }

    @Override
    public boolean getAutoCommit() {
        return false;
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public void close() {
        try {
            if (this.closed.compareAndSet(false, true)) {
                this.executor.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public DatabaseMetaData getMetaData() {
        OkHttpClient client = ClientBuilder.buildOkHttpClient(this.properties);
        String userName = this.properties.getProperty("userName");
        String loginUrl = this.properties.getProperty("loginURL");
        return new DataCloudDatabaseMetadata(this.getQueryStatement(), Optional.ofNullable(this.tokenProcessor), client, loginUrl, userName);
    }

    @NonNull
    private DataCloudStatement getQueryStatement() {
        return new DataCloudStatement(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setCatalog(String catalog) {
    }

    @Override
    public String getCatalog() {
        return "";
    }

    @Override
    public void setTransactionIsolation(int level) {
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return this.getQueryStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return this.getQueryPreparedStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) {
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
    }

    @Override
    public void setHoldability(int holdability) {
    }

    @Override
    public int getHoldability() {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return this.getQueryPreparedStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return null;
    }

    @Override
    public Clob createClob() {
        return null;
    }

    @Override
    public Blob createBlob() {
        return null;
    }

    @Override
    public NClob createNClob() {
        return null;
    }

    @Override
    public SQLXML createSQLXML() {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new DataCloudJDBCException(String.format("Invalid timeout value: %d", timeout));
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) {
    }

    @Override
    public void setClientInfo(Properties properties) {
    }

    @Override
    public String getClientInfo(String name) {
        return "";
    }

    @Override
    public Properties getClientInfo() {
        return this.properties;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) {
        return null;
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public String getSchema() {
        return "";
    }

    @Override
    public void abort(Executor executor) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) {
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new DataCloudJDBCException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    public static boolean acceptsUrl(String url) {
        return url != null && url.startsWith("jdbc:salesforce-datacloud:") && DataCloudConnection.urlDoesNotContainScheme(url);
    }

    private static boolean urlDoesNotContainScheme(String url) {
        String suffix = url.substring("jdbc:salesforce-datacloud:".length());
        return !suffix.startsWith("http://") && !suffix.startsWith("https://");
    }

    static String getServiceRootUrl(String url) throws SQLException {
        if (!DataCloudConnection.acceptsUrl(url)) {
            throw new DataCloudJDBCException("URL is specified with invalid datasource, expected jdbc:salesforce-datacloud");
        }
        String serviceRootUrl = url.substring("jdbc:salesforce-datacloud:".length());
        String noTrailingSlash = StringUtils.removeEnd((String)serviceRootUrl, (String)"/");
        String host = StringUtils.removeStart((String)noTrailingSlash, (String)"//");
        return host.isBlank() ? host : DataCloudConnection.createURI(host).toString();
    }

    private static URI createURI(String host) throws SQLException {
        try {
            return URI.create("https://" + host);
        }
        catch (IllegalArgumentException e) {
            throw new DataCloudJDBCException("URL is specified with invalid datasource, expected jdbc:salesforce-datacloud", e);
        }
    }

    static void addClientUsernameIfRequired(Properties properties) {
        if (properties.containsKey("user")) {
            properties.computeIfAbsent("userName", (Function<? super Object, ?>)((Function<Object, Object>)p -> properties.get("user")));
        }
    }

    @Generated
    private static Properties $default$properties() {
        return new Properties();
    }

    @Generated
    private static List<ClientInterceptor> $default$interceptors() {
        return new ArrayList<ClientInterceptor>();
    }

    @Generated
    DataCloudConnection(TokenProcessor tokenProcessor, @NonNull Properties properties, List<ClientInterceptor> interceptors, @NonNull HyperGrpcClientExecutor executor) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor is marked non-null but is null");
        }
        this.tokenProcessor = tokenProcessor;
        this.properties = properties;
        this.interceptors = interceptors;
        this.executor = executor;
    }

    @Generated
    static DataCloudConnectionBuilder builder() {
        return new DataCloudConnectionBuilder();
    }

    @Generated
    public AtomicBoolean getClosed() {
        return this.closed;
    }

    @Generated
    public TokenProcessor getTokenProcessor() {
        return this.tokenProcessor;
    }

    @NonNull
    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @NonNull
    @Generated
    public HyperGrpcClientExecutor getExecutor() {
        return this.executor;
    }

    @Generated
    public void setInterceptors(List<ClientInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Generated
    static class DataCloudConnectionBuilder {
        @Generated
        private TokenProcessor tokenProcessor;
        @Generated
        private boolean properties$set;
        @Generated
        private Properties properties$value;
        @Generated
        private boolean interceptors$set;
        @Generated
        private List<ClientInterceptor> interceptors$value;
        @Generated
        private HyperGrpcClientExecutor executor;

        @Generated
        DataCloudConnectionBuilder() {
        }

        @Generated
        DataCloudConnectionBuilder tokenProcessor(TokenProcessor tokenProcessor) {
            this.tokenProcessor = tokenProcessor;
            return this;
        }

        @Generated
        DataCloudConnectionBuilder properties(@NonNull Properties properties) {
            if (properties == null) {
                throw new IllegalArgumentException("properties is marked non-null but is null");
            }
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        @Generated
        DataCloudConnectionBuilder interceptors(List<ClientInterceptor> interceptors) {
            this.interceptors$value = interceptors;
            this.interceptors$set = true;
            return this;
        }

        @Generated
        DataCloudConnectionBuilder executor(@NonNull HyperGrpcClientExecutor executor) {
            if (executor == null) {
                throw new IllegalArgumentException("executor is marked non-null but is null");
            }
            this.executor = executor;
            return this;
        }

        @Generated
        DataCloudConnection build() {
            Properties properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = DataCloudConnection.$default$properties();
            }
            List<ClientInterceptor> interceptors$value = this.interceptors$value;
            if (!this.interceptors$set) {
                interceptors$value = DataCloudConnection.$default$interceptors();
            }
            return new DataCloudConnection(this.tokenProcessor, properties$value, interceptors$value, this.executor);
        }

        @Generated
        public String toString() {
            return "DataCloudConnection.DataCloudConnectionBuilder(tokenProcessor=" + this.tokenProcessor + ", properties$value=" + this.properties$value + ", interceptors$value=" + this.interceptors$value + ", executor=" + this.executor + ")";
        }
    }
}

