/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.DataCloudConnection;
import com.salesforce.datacloud.jdbc.core.DataCloudResultSet;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.listener.AdaptiveQueryStatusListener;
import com.salesforce.datacloud.jdbc.core.listener.AsyncQueryStatusListener;
import com.salesforce.datacloud.jdbc.core.listener.QueryStatusListener;
import com.salesforce.datacloud.jdbc.core.listener.SyncQueryStatusListener;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import com.salesforce.hyperdb.grpc.QueryParam;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudStatement
implements Statement {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudStatement.class);
    protected ResultSet resultSet;
    protected static final String NOT_SUPPORTED_IN_DATACLOUD_QUERY = "Write is not supported in Data Cloud query";
    protected static final String BATCH_EXECUTION_IS_NOT_SUPPORTED = "Batch execution is not supported in Data Cloud query";
    private static final String QUERY_TIMEOUT = "queryTimeout";
    public static final int DEFAULT_QUERY_TIMEOUT = 10800;
    protected final DataCloudConnection dataCloudConnection;
    private int queryTimeout;
    protected QueryStatusListener listener;

    public DataCloudStatement(@NonNull DataCloudConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is marked non-null but is null");
        }
        this.dataCloudConnection = connection;
        this.queryTimeout = PropertiesExtensions.getIntegerOrDefault(connection.getProperties(), QUERY_TIMEOUT, 10800);
    }

    protected HyperGrpcClientExecutor getQueryExecutor() {
        return this.getQueryExecutor(null);
    }

    protected HyperGrpcClientExecutor getQueryExecutor(QueryParam additionalQueryParams) {
        HyperGrpcClientExecutor.HyperGrpcClientExecutorBuilder clientBuilder = this.dataCloudConnection.getExecutor().toBuilder();
        clientBuilder.interceptors(this.dataCloudConnection.getInterceptors());
        if (additionalQueryParams != null) {
            clientBuilder.additionalQueryParams(additionalQueryParams);
        }
        return clientBuilder.queryTimeout(this.getQueryTimeout()).build();
    }

    private void assertQueryReady() throws SQLException {
        if (this.listener == null) {
            throw new DataCloudJDBCException("a query was not executed before attempting to access results");
        }
        if (!this.listener.isReady()) {
            throw new DataCloudJDBCException("query results were not ready");
        }
    }

    public boolean isReady() {
        return this.listener.isReady();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        log.debug("Entering execute");
        this.resultSet = this.executeQuery(sql);
        return true;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        log.debug("Entering executeQuery");
        Boolean useSync = PropertiesExtensions.optional(this.dataCloudConnection.getProperties(), "force-sync").map(Boolean::parseBoolean).orElse(false);
        this.resultSet = useSync != false ? this.executeSyncQuery(sql) : this.executeAdaptiveQuery(sql);
        return this.resultSet;
    }

    public DataCloudResultSet executeSyncQuery(String sql) throws SQLException {
        log.debug("Entering executeSyncQuery");
        HyperGrpcClientExecutor client = this.getQueryExecutor();
        return this.executeSyncQuery(sql, client);
    }

    protected DataCloudResultSet executeSyncQuery(String sql, HyperGrpcClientExecutor client) throws SQLException {
        this.listener = SyncQueryStatusListener.of(sql, client);
        this.resultSet = this.listener.generateResultSet();
        log.info("executeSyncQuery completed.  queryId={}", (Object)this.listener.getQueryId());
        return (DataCloudResultSet)this.resultSet;
    }

    public DataCloudResultSet executeAdaptiveQuery(String sql) throws SQLException {
        log.debug("Entering executeAdaptiveQuery");
        HyperGrpcClientExecutor client = this.getQueryExecutor();
        Duration timeout = Duration.ofSeconds(this.getQueryTimeout());
        return this.executeAdaptiveQuery(sql, client, timeout);
    }

    protected DataCloudResultSet executeAdaptiveQuery(String sql, HyperGrpcClientExecutor client, Duration timeout) throws SQLException {
        this.listener = AdaptiveQueryStatusListener.of(sql, client, timeout);
        this.resultSet = this.listener.generateResultSet();
        log.info("executeAdaptiveQuery completed. queryId={}", (Object)this.listener.getQueryId());
        return (DataCloudResultSet)this.resultSet;
    }

    public DataCloudStatement executeAsyncQuery(String sql) throws SQLException {
        log.debug("Entering executeAsyncQuery");
        HyperGrpcClientExecutor client = this.getQueryExecutor();
        return this.executeAsyncQuery(sql, client);
    }

    protected DataCloudStatement executeAsyncQuery(String sql, HyperGrpcClientExecutor client) throws SQLException {
        this.listener = AsyncQueryStatusListener.of(sql, client);
        log.info("executeAsyncQuery completed. queryId={}", (Object)this.listener.getQueryId());
        return this;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new DataCloudJDBCException(NOT_SUPPORTED_IN_DATACLOUD_QUERY, "0A000");
    }

    @Override
    public void close() throws SQLException {
        log.debug("Entering close");
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                throw new DataCloudJDBCException(e);
            }
        }
        log.debug("Exiting close");
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public void setMaxRows(int max) {
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds < 0 ? 10800 : seconds;
    }

    @Override
    public void cancel() {
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        log.debug("Entering getResultSet");
        this.assertQueryReady();
        if (this.resultSet == null) {
            this.resultSet = this.listener.generateResultSet();
        }
        log.info("getResultSet completed. queryId={}", (Object)this.listener.getQueryId());
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() {
        return 0;
    }

    @Override
    public int getResultSetType() {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public Connection getConnection() {
        return this.dataCloudConnection;
    }

    @Override
    public boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public int getResultSetHoldability() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) {
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        if (iFace.isInstance(this)) {
            return iFace.cast(this);
        }
        throw new DataCloudJDBCException("Cannot unwrap to " + iFace.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) {
        return iFace.isInstance(this);
    }
}

