/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.HyperConnectionSettings;
import com.salesforce.datacloud.jdbc.interceptor.QueryIdHeaderInterceptor;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import com.salesforce.hyperdb.grpc.ExecuteQueryResponse;
import com.salesforce.hyperdb.grpc.HyperServiceGrpc;
import com.salesforce.hyperdb.grpc.OutputFormat;
import com.salesforce.hyperdb.grpc.QueryInfo;
import com.salesforce.hyperdb.grpc.QueryInfoParam;
import com.salesforce.hyperdb.grpc.QueryParam;
import com.salesforce.hyperdb.grpc.QueryResult;
import com.salesforce.hyperdb.grpc.QueryResultParam;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperGrpcClientExecutor
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HyperGrpcClientExecutor.class);
    private static final int GRPC_INBOUND_MESSAGE_MAX_SIZE = 0x8000000;
    @NonNull
    private final ManagedChannel channel;
    private final QueryParam additionalQueryParams;
    private final QueryParam settingsQueryParams;
    private int queryTimeout;
    private final List<ClientInterceptor> interceptors;
    private final AtomicReference<Object> stub = new AtomicReference();

    public static HyperGrpcClientExecutor of(@NonNull ManagedChannelBuilder<?> builder, @NonNull Properties properties) throws SQLException {
        if (builder == null) {
            throw new IllegalArgumentException("builder is marked non-null but is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        HyperGrpcClientExecutorBuilder client = HyperGrpcClientExecutor.builder();
        Map<String, String> settings = HyperConnectionSettings.of(properties).getSettings();
        if (!settings.isEmpty()) {
            client.settingsQueryParams(QueryParam.newBuilder().putAllSettings(settings).build());
        }
        if (PropertiesExtensions.getBooleanOrDefault(properties, "grpc.enableRetries", Boolean.TRUE).booleanValue()) {
            int maxRetryAttempts = PropertiesExtensions.getIntegerOrDefault(properties, "grpc.retryPolicy.maxAttempts", 5);
            builder.enableRetry().maxRetryAttempts(maxRetryAttempts).defaultServiceConfig(HyperGrpcClientExecutor.retryPolicy(maxRetryAttempts));
        }
        ManagedChannel channel = builder.maxInboundMessageSize(0x8000000).build();
        return client.channel(channel).build();
    }

    private static Map<String, Object> retryPolicy(int maxRetryAttempts) {
        return Map.of("methodConfig", List.of(Map.of("name", List.of(Collections.EMPTY_MAP), "retryPolicy", Map.of("maxAttempts", String.valueOf(maxRetryAttempts), "initialBackoff", "0.5s", "maxBackoff", "30s", "backoffMultiplier", 2.0, "retryableStatusCodes", List.of("UNAVAILABLE")))));
    }

    public static HyperGrpcClientExecutor of(HyperGrpcClientExecutorBuilder builder, QueryParam additionalQueryParams, int queryTimeout) {
        return builder.additionalQueryParams(additionalQueryParams).queryTimeout(queryTimeout).build();
    }

    public Iterator<ExecuteQueryResponse> executeAdaptiveQuery(String sql) throws SQLException {
        return this.execute(sql, QueryParam.TransferMode.ADAPTIVE);
    }

    public Iterator<ExecuteQueryResponse> executeAsyncQuery(String sql) throws SQLException {
        return this.execute(sql, QueryParam.TransferMode.ASYNC);
    }

    public Iterator<ExecuteQueryResponse> executeQuery(String sql) throws SQLException {
        return this.execute(sql, QueryParam.TransferMode.SYNC);
    }

    public Iterator<QueryInfo> getQueryInfo(String queryId) {
        QueryInfoParam param = this.getQueryInfoParam(queryId);
        return this.getStub(queryId).getQueryInfo(param);
    }

    public Iterator<QueryInfo> getQueryInfoStreaming(String queryId) {
        QueryInfoParam param = this.getQueryInfoParamStreaming(queryId);
        return this.getStub(queryId).getQueryInfo(param);
    }

    public Iterator<QueryResult> getQueryResult(String queryId, long chunkId, boolean omitSchema) {
        QueryResultParam param = this.getQueryResultParam(queryId, chunkId, omitSchema);
        return this.getStub(queryId).getQueryResult(param);
    }

    private QueryParam getQueryParams(String sql, QueryParam.TransferMode transferMode) {
        QueryParam.Builder builder = QueryParam.newBuilder().setQuery(sql).setTransferMode(transferMode).setOutputFormat(OutputFormat.ARROW_V3);
        if (this.additionalQueryParams != null) {
            builder.mergeFrom(this.additionalQueryParams);
        }
        if (this.settingsQueryParams != null) {
            builder.mergeFrom(this.settingsQueryParams);
        }
        return builder.build();
    }

    private QueryResultParam getQueryResultParam(String queryId, long chunkId, boolean omitSchema) {
        QueryResultParam.Builder builder = QueryResultParam.newBuilder().setQueryId(queryId).setChunkId(chunkId).setOutputFormat(OutputFormat.ARROW_V3);
        if (omitSchema) {
            builder.setOmitSchema(true);
        }
        return builder.build();
    }

    private QueryInfoParam getQueryInfoParam(String queryId) {
        return QueryInfoParam.newBuilder().setQueryId(queryId).build();
    }

    private QueryInfoParam getQueryInfoParamStreaming(String queryId) {
        return QueryInfoParam.newBuilder().setQueryId(queryId).setStreaming(true).build();
    }

    private Iterator<ExecuteQueryResponse> execute(String sql, QueryParam.TransferMode mode) throws SQLException {
        QueryParam request = this.getQueryParams(sql, mode);
        return this.getStub().executeQuery(request);
    }

    private HyperServiceGrpc.HyperServiceBlockingStub lazyStub() {
        HyperServiceGrpc.HyperServiceBlockingStub result = HyperServiceGrpc.newBlockingStub((Channel)this.channel);
        log.info("Stub will execute query. deadline={}", this.queryTimeout > 0 ? Duration.ofSeconds(this.queryTimeout) : "none");
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            log.info("Registering additional interceptors. count={}", (Object)this.interceptors.size());
            result = (HyperServiceGrpc.HyperServiceBlockingStub)result.withInterceptors((ClientInterceptor[])this.interceptors.toArray(ClientInterceptor[]::new));
        }
        if (this.queryTimeout > 0) {
            return (HyperServiceGrpc.HyperServiceBlockingStub)result.withDeadlineAfter(this.queryTimeout, TimeUnit.SECONDS);
        }
        return result;
    }

    private HyperServiceGrpc.HyperServiceBlockingStub getStub(String queryId) {
        QueryIdHeaderInterceptor queryIdHeaderInterceptor = new QueryIdHeaderInterceptor(queryId);
        return (HyperServiceGrpc.HyperServiceBlockingStub)this.getStub().withInterceptors(new ClientInterceptor[]{queryIdHeaderInterceptor});
    }

    @Override
    public void close() throws Exception {
        if (this.channel.isShutdown() || this.channel.isTerminated()) {
            return;
        }
        this.channel.shutdown();
    }

    @Generated
    private static int $default$queryTimeout() {
        return -1;
    }

    @Generated
    HyperGrpcClientExecutor(@NonNull ManagedChannel channel, QueryParam additionalQueryParams, QueryParam settingsQueryParams, int queryTimeout, List<ClientInterceptor> interceptors) {
        if (channel == null) {
            throw new IllegalArgumentException("channel is marked non-null but is null");
        }
        this.channel = channel;
        this.additionalQueryParams = additionalQueryParams;
        this.settingsQueryParams = settingsQueryParams;
        this.queryTimeout = queryTimeout;
        this.interceptors = interceptors;
    }

    @Generated
    public static HyperGrpcClientExecutorBuilder builder() {
        return new HyperGrpcClientExecutorBuilder();
    }

    @Generated
    public HyperGrpcClientExecutorBuilder toBuilder() {
        return new HyperGrpcClientExecutorBuilder().channel(this.channel).additionalQueryParams(this.additionalQueryParams).settingsQueryParams(this.settingsQueryParams).queryTimeout(this.queryTimeout).interceptors(this.interceptors);
    }

    @Generated
    public QueryParam getAdditionalQueryParams() {
        return this.additionalQueryParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private HyperServiceGrpc.HyperServiceBlockingStub getStub() {
        Object $value = this.stub.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.stub;
            synchronized (atomicReference) {
                $value = this.stub.get();
                if ($value == null) {
                    HyperServiceGrpc.HyperServiceBlockingStub actualValue = this.lazyStub();
                    $value = actualValue == null ? this.stub : actualValue;
                    this.stub.set($value);
                }
            }
        }
        return (HyperServiceGrpc.HyperServiceBlockingStub)((Object)($value == this.stub ? null : $value));
    }

    @Generated
    public static class HyperGrpcClientExecutorBuilder {
        @Generated
        private ManagedChannel channel;
        @Generated
        private QueryParam additionalQueryParams;
        @Generated
        private QueryParam settingsQueryParams;
        @Generated
        private boolean queryTimeout$set;
        @Generated
        private int queryTimeout$value;
        @Generated
        private List<ClientInterceptor> interceptors;

        @Generated
        HyperGrpcClientExecutorBuilder() {
        }

        @Generated
        public HyperGrpcClientExecutorBuilder channel(@NonNull ManagedChannel channel) {
            if (channel == null) {
                throw new IllegalArgumentException("channel is marked non-null but is null");
            }
            this.channel = channel;
            return this;
        }

        @Generated
        public HyperGrpcClientExecutorBuilder additionalQueryParams(QueryParam additionalQueryParams) {
            this.additionalQueryParams = additionalQueryParams;
            return this;
        }

        @Generated
        public HyperGrpcClientExecutorBuilder settingsQueryParams(QueryParam settingsQueryParams) {
            this.settingsQueryParams = settingsQueryParams;
            return this;
        }

        @Generated
        public HyperGrpcClientExecutorBuilder queryTimeout(int queryTimeout) {
            this.queryTimeout$value = queryTimeout;
            this.queryTimeout$set = true;
            return this;
        }

        @Generated
        public HyperGrpcClientExecutorBuilder interceptors(List<ClientInterceptor> interceptors) {
            this.interceptors = interceptors;
            return this;
        }

        @Generated
        public HyperGrpcClientExecutor build() {
            int queryTimeout$value = this.queryTimeout$value;
            if (!this.queryTimeout$set) {
                queryTimeout$value = HyperGrpcClientExecutor.$default$queryTimeout();
            }
            return new HyperGrpcClientExecutor(this.channel, this.additionalQueryParams, this.settingsQueryParams, queryTimeout$value, this.interceptors);
        }

        @Generated
        public String toString() {
            return "HyperGrpcClientExecutor.HyperGrpcClientExecutorBuilder(channel=" + this.channel + ", additionalQueryParams=" + this.additionalQueryParams + ", settingsQueryParams=" + this.settingsQueryParams + ", queryTimeout$value=" + this.queryTimeout$value + ", interceptors=" + this.interceptors + ")";
        }
    }
}

