/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.util.ThrowingFunction;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.AbstractCursor;
import org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.calcite.avatica.util.Cursor;

public class QueryJDBCCursor
extends AbstractCursor {
    private VectorSchemaRoot root;
    private final int rowCount;
    private int currentRow = -1;

    public QueryJDBCCursor(VectorSchemaRoot schemaRoot) {
        this.root = schemaRoot;
        this.rowCount = this.root.getRowCount();
    }

    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory) {
        return this.root.getFieldVectors().stream().map(ThrowingFunction.rethrowFunction(this::createAccessor)).collect(Collectors.toList());
    }

    private Cursor.Accessor createAccessor(FieldVector vector) throws SQLException {
        return QueryJDBCAccessorFactory.createAccessor((ValueVector)vector, this::getCurrentRow, wasNull -> {
            this.wasNull[0] = wasNull;
        });
    }

    protected AbstractCursor.Getter createGetter(int i) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    public boolean next() {
        ++this.currentRow;
        return this.currentRow < this.rowCount;
    }

    public void close() {
        try {
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.root});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getCurrentRow() {
        return this.currentRow;
    }
}

