/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.auth.OAuthToken;
import com.salesforce.datacloud.jdbc.auth.TokenProcessor;
import com.salesforce.datacloud.jdbc.config.QueryResources;
import com.salesforce.datacloud.jdbc.core.DataCloudStatement;
import com.salesforce.datacloud.jdbc.core.MetadataResultSet;
import com.salesforce.datacloud.jdbc.core.QueryDBMetadata;
import com.salesforce.datacloud.jdbc.core.QueryResultSetMetadata;
import com.salesforce.datacloud.jdbc.core.model.DataspaceResponse;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.http.FormCommand;
import com.salesforce.datacloud.jdbc.util.ArrowUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.SqlType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QueryMetadataUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryMetadataUtil.class);
    static final int NUM_TABLE_METADATA_COLUMNS = 10;
    static final int NUM_COLUMN_METADATA_COLUMNS = 24;
    static final int NUM_SCHEMA_METADATA_COLUMNS = 2;
    static final int NUM_TABLE_TYPES_METADATA_COLUMNS = 1;
    static final int NUM_CATALOG_METADATA_COLUMNS = 1;
    private static final String SOQL_ENDPOINT_SUFFIX = "services/data/v61.0/query/";
    private static final String SOQL_QUERY_PARAM_KEY = "q";
    private static final int TABLE_CATALOG_INDEX = 0;
    private static final int TABLE_SCHEMA_INDEX = 1;
    private static final int TABLE_NAME_INDEX = 2;
    private static final int COLUMN_NAME_INDEX = 3;
    private static final int DATA_TYPE_INDEX = 4;
    private static final int TYPE_NAME_INDEX = 5;
    private static final int COLUMN_SIZE_INDEX = 6;
    private static final int BUFFER_LENGTH_INDEX = 7;
    private static final int DECIMAL_DIGITS_INDEX = 8;
    private static final int NUM_PREC_RADIX_INDEX = 9;
    private static final int NULLABLE_INDEX = 10;
    private static final int DESCRIPTION_INDEX = 11;
    private static final int COLUMN_DEFAULT_INDEX = 12;
    private static final int SQL_DATA_TYPE_INDEX = 13;
    private static final int SQL_DATE_TIME_SUB_INDEX = 14;
    private static final int CHAR_OCTET_LENGTH_INDEX = 15;
    private static final int ORDINAL_POSITION_INDEX = 16;
    private static final int IS_NULLABLE_INDEX = 17;
    private static final int SCOPE_CATALOG_INDEX = 18;
    private static final int SCOPE_SCHEMA_INDEX = 19;
    private static final int SCOPE_TABLE_INDEX = 20;
    private static final int SOURCE_DATA_TYPE_INDEX = 21;
    private static final int AUTO_INCREMENT_INDEX = 22;
    private static final int GENERATED_COLUMN_INDEX = 23;
    private static final Map<String, String> dbTypeToSql = Map.ofEntries(Map.entry("int2", SqlType.SMALLINT.toString()), Map.entry("int4", SqlType.INTEGER.toString()), Map.entry("oid", SqlType.BIGINT.toString()), Map.entry("int8", SqlType.BIGINT.toString()), Map.entry("float", SqlType.DOUBLE.toString()), Map.entry("float4", SqlType.REAL.toString()), Map.entry("float8", SqlType.DOUBLE.toString()), Map.entry("bool", SqlType.BOOLEAN.toString()), Map.entry("char", SqlType.CHAR.toString()), Map.entry("text", SqlType.VARCHAR.toString()), Map.entry("date", SqlType.DATE.toString()), Map.entry("time", SqlType.TIME.toString()), Map.entry("timetz", SqlType.TIME.toString()), Map.entry("timestamp", SqlType.TIMESTAMP.toString()), Map.entry("timestamptz", SqlType.TIMESTAMP.toString()), Map.entry("array", SqlType.ARRAY.toString()));
    private static final Map<String, Map<String, String>> tableTypeClauses = Map.ofEntries(Map.entry("TABLE", Map.of("SCHEMAS", "c.relkind = 'r' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'r' AND c.relname !~ '^pg_'")), Map.entry("PARTITIONED TABLE", Map.of("SCHEMAS", "c.relkind = 'p' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'p' AND c.relname !~ '^pg_'")), Map.entry("VIEW", Map.of("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'v' AND c.relname !~ '^pg_'")), Map.entry("INDEX", Map.of("SCHEMAS", "c.relkind = 'i' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'i' AND c.relname !~ '^pg_'")), Map.entry("PARTITIONED INDEX", Map.of("SCHEMAS", "c.relkind = 'I' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'I' AND c.relname !~ '^pg_'")), Map.entry("SEQUENCE", Map.of("SCHEMAS", "c.relkind = 'S'", "NOSCHEMAS", "c.relkind = 'S'")), Map.entry("TYPE", Map.of("SCHEMAS", "c.relkind = 'c' AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'", "NOSCHEMAS", "c.relkind = 'c' AND c.relname !~ '^pg_'")), Map.entry("SYSTEM TABLE", Map.of("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')", "NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'")), Map.entry("SYSTEM TOAST TABLE", Map.of("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'pg_toast'", "NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^pg_toast_'")), Map.entry("SYSTEM TOAST INDEX", Map.of("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'pg_toast'", "NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_toast_'")), Map.entry("SYSTEM VIEW", Map.of("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ", "NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_'")), Map.entry("SYSTEM INDEX", Map.of("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ", "NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_' AND c.relname !~ '^pg_toast_' AND c.relname !~ '^pg_temp_'")), Map.entry("TEMPORARY TABLE", Map.of("SCHEMAS", "c.relkind IN ('r','p') AND n.nspname ~ '^pg_temp_' ", "NOSCHEMAS", "c.relkind IN ('r','p') AND c.relname ~ '^pg_temp_' ")), Map.entry("TEMPORARY INDEX", Map.of("SCHEMAS", "c.relkind = 'i' AND n.nspname ~ '^pg_temp_' ", "NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^pg_temp_' ")), Map.entry("TEMPORARY VIEW", Map.of("SCHEMAS", "c.relkind = 'v' AND n.nspname ~ '^pg_temp_' ", "NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^pg_temp_' ")), Map.entry("TEMPORARY SEQUENCE", Map.of("SCHEMAS", "c.relkind = 'S' AND n.nspname ~ '^pg_temp_' ", "NOSCHEMAS", "c.relkind = 'S' AND c.relname ~ '^pg_temp_' ")), Map.entry("FOREIGN TABLE", Map.of("SCHEMAS", "c.relkind = 'f'", "NOSCHEMAS", "c.relkind = 'f'")), Map.entry("MATERIALIZED VIEW", Map.of("SCHEMAS", "c.relkind = 'm'", "NOSCHEMAS", "c.relkind = 'm'")));

    public static ResultSet createTableResultSet(String schemaPattern, String tableNamePattern, String[] types, DataCloudStatement dataCloudStatement) throws SQLException {
        String tablesQuery = QueryMetadataUtil.getTablesQuery(schemaPattern, tableNamePattern, types);
        ResultSet resultSet = dataCloudStatement.executeQuery(tablesQuery);
        List<Object> data = QueryMetadataUtil.constructTableData(resultSet);
        QueryDBMetadata queryDbMetadata = QueryDBMetadata.GET_TABLES;
        return QueryMetadataUtil.getMetadataResultSet(queryDbMetadata, 10, data);
    }

    static AvaticaResultSet getMetadataResultSet(QueryDBMetadata queryDbMetadata, int columnsCount, List<Object> data) throws SQLException {
        QueryResultSetMetadata queryResultSetMetadata = new QueryResultSetMetadata(queryDbMetadata);
        List<ColumnMetaData> columnMetaData = ArrowUtils.convertJDBCMetadataToAvaticaColumns(queryResultSetMetadata, columnsCount);
        Meta.Signature signature = new Meta.Signature(columnMetaData, null, Collections.emptyList(), Collections.emptyMap(), null, Meta.StatementType.SELECT);
        return MetadataResultSet.of(null, new QueryState(), signature, queryResultSetMetadata, TimeZone.getDefault(), null, data);
    }

    private static List<Object> constructTableData(ResultSet resultSet) throws SQLException {
        ArrayList<Object> data = new ArrayList<Object>();
        try {
            while (resultSet.next()) {
                List<Object> rowData = Arrays.asList(resultSet.getString("TABLE_CAT"), resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_NAME"), "TABLE", resultSet.getString("REMARKS"), resultSet.getString("TYPE_CAT"), resultSet.getString("TYPE_SCHEM"), resultSet.getString("TYPE_NAME"), resultSet.getString("SELF_REFERENCING_COL_NAME"), resultSet.getString("REF_GENERATION"));
                data.add(rowData);
            }
        }
        catch (SQLException e) {
            throw new DataCloudJDBCException(e);
        }
        return data;
    }

    private static String getTablesQuery(String schemaPattern, String tableNamePattern, String[] types) {
        Object tablesQuery = QueryResources.getTablesQuery();
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            tablesQuery = (String)tablesQuery + " AND n.nspname LIKE " + QueryMetadataUtil.quoteStringLiteral(schemaPattern);
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            tablesQuery = (String)tablesQuery + " AND c.relname LIKE " + QueryMetadataUtil.quoteStringLiteral(tableNamePattern);
        }
        if (types != null && types.length > 0) {
            tablesQuery = (String)tablesQuery + " AND (false ";
            StringBuilder orclause = new StringBuilder();
            for (String type : types) {
                Map<String, String> clauses = tableTypeClauses.get(type);
                if (clauses == null) continue;
                String clause = clauses.get("SCHEMAS");
                orclause.append(" OR ( ").append(clause).append(" ) ");
            }
            tablesQuery = (String)tablesQuery + orclause.toString() + ") ";
        }
        tablesQuery = (String)tablesQuery + " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        return tablesQuery;
    }

    public static ResultSet createColumnResultSet(String schemaPattern, String tableNamePattern, String columnNamePattern, DataCloudStatement dataCloudStatement) throws SQLException {
        String getColumnsQuery = QueryMetadataUtil.getColumnsQuery(schemaPattern, tableNamePattern, columnNamePattern);
        ResultSet resultSet = dataCloudStatement.executeQuery(getColumnsQuery);
        List<Object> data = QueryMetadataUtil.constructColumnData(resultSet);
        QueryDBMetadata queryDbMetadata = QueryDBMetadata.GET_COLUMNS;
        return QueryMetadataUtil.getMetadataResultSet(queryDbMetadata, 24, data);
    }

    private static String getColumnsQuery(String schemaPattern, String tableNamePattern, String columnNamePattern) {
        Object getColumnsQuery = QueryResources.getColumnsQuery();
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            getColumnsQuery = (String)getColumnsQuery + " AND n.nspname LIKE " + QueryMetadataUtil.quoteStringLiteral(schemaPattern);
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            getColumnsQuery = (String)getColumnsQuery + " AND c.relname LIKE " + QueryMetadataUtil.quoteStringLiteral(tableNamePattern);
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            getColumnsQuery = (String)getColumnsQuery + " AND attname LIKE " + QueryMetadataUtil.quoteStringLiteral(columnNamePattern);
        }
        getColumnsQuery = (String)getColumnsQuery + " ORDER BY nspname, c.relname, attnum ";
        return getColumnsQuery;
    }

    private static List<Object> constructColumnData(ResultSet resultSet) throws SQLException {
        ArrayList<Object> data = new ArrayList<Object>();
        try {
            while (resultSet.next()) {
                Object[] rowData = new Object[24];
                Object tableCatalog = null;
                rowData[0] = tableCatalog;
                String tableSchema = resultSet.getString("nspname");
                rowData[1] = tableSchema;
                String tableName = resultSet.getString("relname");
                rowData[2] = tableName;
                String columnName = resultSet.getString("attname");
                rowData[3] = columnName;
                int dataType = (int)resultSet.getLong("atttypid");
                rowData[4] = dataType;
                String typeName = resultSet.getString("datatype");
                String string = typeName = typeName == null ? "" : typeName;
                if (typeName.toLowerCase().contains("numeric")) {
                    rowData[5] = SqlType.NUMERIC.toString();
                    rowData[4] = SqlType.valueOf((String)SqlType.NUMERIC.toString()).id;
                } else {
                    rowData[5] = dbTypeToSql.getOrDefault(typeName.toLowerCase(), typeName);
                    dataType = dbTypeToSql.containsKey(typeName.toLowerCase()) ? SqlType.valueOf((String)QueryMetadataUtil.dbTypeToSql.get((Object)typeName.toLowerCase())).id : (int)resultSet.getLong("atttypid");
                    rowData[4] = dataType;
                }
                int columnSize = 255;
                rowData[6] = columnSize;
                int decimalDigits = 2;
                rowData[8] = decimalDigits;
                int numPrecRadix = 10;
                rowData[9] = numPrecRadix;
                int nullable = resultSet.getBoolean("attnotnull") ? 0 : 1;
                rowData[10] = nullable;
                String description = resultSet.getString("description");
                rowData[11] = description;
                String columnDefault = resultSet.getString("adsrc");
                rowData[12] = columnDefault;
                rowData[13] = null;
                String sqlDateTimeSub = "";
                rowData[14] = sqlDateTimeSub;
                int charOctetLength = 2;
                rowData[15] = charOctetLength;
                int ordinalPosition = resultSet.getInt("attnum");
                rowData[16] = ordinalPosition;
                String isNullable = resultSet.getBoolean("attnotnull") ? "NO" : "YES";
                rowData[17] = isNullable;
                rowData[18] = null;
                rowData[19] = null;
                rowData[20] = null;
                rowData[21] = null;
                String identity = resultSet.getString("attidentity");
                String defval = resultSet.getString("adsrc");
                String autoIncrement = "NO";
                if (defval != null && defval.contains("nextval(") || identity != null) {
                    autoIncrement = "YES";
                }
                rowData[22] = autoIncrement;
                String generated = resultSet.getString("attgenerated");
                String generatedColumn = generated != null ? "YES" : "NO";
                rowData[23] = generatedColumn;
                data.add(Arrays.asList(rowData));
            }
        }
        catch (SQLException e) {
            throw new DataCloudJDBCException(e);
        }
        return data;
    }

    public static ResultSet createSchemaResultSet(String schemaPattern, DataCloudStatement dataCloudStatement) throws SQLException {
        String schemasQuery = QueryMetadataUtil.getSchemasQuery(schemaPattern);
        ResultSet resultSet = dataCloudStatement.executeQuery(schemasQuery);
        List<Object> data = QueryMetadataUtil.constructSchemaData(resultSet);
        QueryDBMetadata queryDbMetadata = QueryDBMetadata.GET_SCHEMAS;
        return QueryMetadataUtil.getMetadataResultSet(queryDbMetadata, 2, data);
    }

    private static String getSchemasQuery(String schemaPattern) {
        Object schemasQuery = QueryResources.getSchemasQuery();
        if (StringUtils.isNotEmpty((CharSequence)schemaPattern)) {
            schemasQuery = (String)schemasQuery + " AND nspname LIKE " + QueryMetadataUtil.quoteStringLiteral(schemaPattern);
        }
        return schemasQuery;
    }

    private static List<Object> constructSchemaData(ResultSet resultSet) throws SQLException {
        ArrayList<Object> data = new ArrayList<Object>();
        try {
            while (resultSet.next()) {
                List<Object> rowData = Arrays.asList(resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_CATALOG"));
                data.add(rowData);
            }
        }
        catch (SQLException e) {
            throw new DataCloudJDBCException(e);
        }
        return data;
    }

    public static ResultSet createTableTypesResultSet() throws SQLException {
        List<Object> data = QueryMetadataUtil.constructTableTypesData();
        QueryDBMetadata queryDbMetadata = QueryDBMetadata.GET_TABLE_TYPES;
        return QueryMetadataUtil.getMetadataResultSet(queryDbMetadata, 1, data);
    }

    private static List<Object> constructTableTypesData() {
        ArrayList<Object> data = new ArrayList<Object>();
        for (Map.Entry<String, Map<String, String>> entry : tableTypeClauses.entrySet()) {
            List<Object> rowData = Arrays.asList(entry.getValue());
            data.add(rowData);
        }
        return data;
    }

    public static ResultSet createCatalogsResultSet(Optional<TokenProcessor> tokenProcessor, OkHttpClient client) throws SQLException {
        String tenantId = tokenProcessor.get().getDataCloudToken().getTenantId();
        String dataspaceName = tokenProcessor.get().getSettings().getDataspace();
        List<Object> data = List.of(List.of("lakehouse:" + tenantId + ";" + dataspaceName));
        QueryDBMetadata queryDbMetadata = QueryDBMetadata.GET_CATALOGS;
        return QueryMetadataUtil.getMetadataResultSet(queryDbMetadata, 1, data);
    }

    public static List<String> createDataspacesResponse(Optional<TokenProcessor> tokenProcessor, OkHttpClient client) throws SQLException {
        try {
            DataspaceResponse dataspaceResponse = QueryMetadataUtil.getDataSpaceResponse(tokenProcessor, client, false);
            return dataspaceResponse.getRecords().stream().map(DataspaceResponse.DataSpaceAttributes::getName).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new DataCloudJDBCException(e);
        }
    }

    private static FormCommand buildGetDataspaceFormCommand(OAuthToken oAuthToken) throws URISyntaxException {
        FormCommand.Builder builder = FormCommand.builder();
        builder.url(oAuthToken.getInstanceUrl());
        builder.suffix(new URI(SOQL_ENDPOINT_SUFFIX));
        builder.queryParameters(Map.of(SOQL_QUERY_PARAM_KEY, "SELECT+name+from+Dataspace"));
        builder.header("Authorization", oAuthToken.getBearerToken());
        builder.header("Content-Type", "application/json");
        builder.header("User-Agent", "cdp/jdbc");
        builder.header("enable-stream-flow", "false");
        return builder.build();
    }

    private static DataspaceResponse getDataSpaceResponse(Optional<TokenProcessor> tokenProcessor, OkHttpClient client, boolean isGetCatalog) throws SQLException {
        String errorMessage;
        String string = errorMessage = isGetCatalog ? "Token processor is empty. getCatalogs() cannot be executed" : "Token processor is empty. getDataspaces() cannot be executed";
        if (tokenProcessor.isEmpty()) {
            throw new DataCloudJDBCException(errorMessage);
        }
        try {
            OAuthToken oAuthToken = tokenProcessor.get().getOAuthToken();
            FormCommand httpFormCommand = QueryMetadataUtil.buildGetDataspaceFormCommand(oAuthToken);
            return FormCommand.get(client, httpFormCommand, DataspaceResponse.class);
        }
        catch (Exception e) {
            throw new DataCloudJDBCException(e);
        }
    }

    public static String quoteStringLiteral(String v) {
        StringBuilder result = new StringBuilder();
        result.ensureCapacity(v.length() + 8);
        result.append("E'");
        boolean escaped = false;
        block9: for (int i = 0; i < v.length(); ++i) {
            char ch = v.charAt(i);
            switch (ch) {
                case '\'': {
                    result.append("''");
                    continue block9;
                }
                case '\\': {
                    result.append("\\\\");
                    escaped = true;
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    escaped = true;
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    escaped = true;
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    escaped = true;
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    escaped = true;
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    escaped = true;
                    continue block9;
                }
                default: {
                    if (ch < ' ') {
                        result.append('\\').append(String.format("%03o", ch));
                        escaped = true;
                        continue block9;
                    }
                    result.append(ch);
                }
            }
        }
        if (!escaped) {
            result.deleteCharAt(0);
        }
        return result.append('\'').toString();
    }

    @Generated
    private QueryMetadataUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

