/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.ArrowStreamReaderCursor;
import com.salesforce.datacloud.jdbc.core.DataCloudResultSet;
import com.salesforce.datacloud.jdbc.core.ExecuteQueryResponseChannel;
import com.salesforce.datacloud.jdbc.core.listener.QueryStatusListener;
import com.salesforce.datacloud.jdbc.exception.QueryExceptionHandler;
import com.salesforce.datacloud.jdbc.util.ArrowUtils;
import java.nio.channels.ReadableByteChannel;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.calcite.avatica.AvaticaResultSetMetaData;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.util.Cursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingResultSet
extends AvaticaResultSet
implements DataCloudResultSet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingResultSet.class);
    private static final int ROOT_ALLOCATOR_MB_FROM_V2 = 0x6400000;
    private final QueryStatusListener listener;
    private static final String QUERY_FAILURE = "Failed to execute query: ";

    private StreamingResultSet(QueryStatusListener listener, AvaticaStatement statement, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(statement, state, signature, resultSetMetaData, timeZone, firstFrame);
        this.listener = listener;
    }

    public static StreamingResultSet of(String sql, QueryStatusListener listener) {
        try {
            ExecuteQueryResponseChannel channel = ExecuteQueryResponseChannel.of(listener.stream());
            ArrowStreamReader reader = new ArrowStreamReader((ReadableByteChannel)channel, (BufferAllocator)new RootAllocator(0x6400000L));
            VectorSchemaRoot schemaRoot = reader.getVectorSchemaRoot();
            List<ColumnMetaData> columns = ArrowUtils.toColumnMetaData(schemaRoot.getSchema().getFields());
            TimeZone timezone = TimeZone.getDefault();
            QueryState state = new QueryState();
            Meta.Signature signature = new Meta.Signature(columns, sql, Collections.emptyList(), Collections.emptyMap(), null, Meta.StatementType.SELECT);
            AvaticaResultSetMetaData metadata = new AvaticaResultSetMetaData(null, null, signature);
            StreamingResultSet result = new StreamingResultSet(listener, null, state, signature, (ResultSetMetaData)metadata, timezone, null);
            ArrowStreamReaderCursor cursor = new ArrowStreamReaderCursor(reader);
            result.execute2((Cursor)cursor, columns);
            return result;
        }
        catch (Exception ex) {
            throw QueryExceptionHandler.createException(QUERY_FAILURE + sql, ex);
        }
    }

    @Override
    public String getQueryId() {
        return this.listener.getQueryId();
    }

    @Override
    public String getStatus() {
        return this.listener.getStatus();
    }

    @Override
    public boolean isReady() {
        return this.listener.isReady();
    }

    @Generated
    public QueryStatusListener getListener() {
        return this.listener;
    }
}

