/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.TypeHandler;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import lombok.Generated;

final class TypeHandlers {
    public static final TypeHandler STRING_HANDLER = (ps, idx, value) -> ps.setString(idx, (String)value);
    public static final TypeHandler BIGDECIMAL_HANDLER = (ps, idx, value) -> ps.setBigDecimal(idx, (BigDecimal)value);
    public static final TypeHandler SHORT_HANDLER = (ps, idx, value) -> ps.setShort(idx, (Short)value);
    public static final TypeHandler INTEGER_HANDLER = (ps, idx, value) -> ps.setInt(idx, (Integer)value);
    public static final TypeHandler LONG_HANDLER = (ps, idx, value) -> ps.setLong(idx, (Long)value);
    public static final TypeHandler FLOAT_HANDLER = (ps, idx, value) -> ps.setFloat(idx, ((Float)value).floatValue());
    public static final TypeHandler DOUBLE_HANDLER = (ps, idx, value) -> ps.setDouble(idx, (Double)value);
    public static final TypeHandler DATE_HANDLER = (ps, idx, value) -> ps.setDate(idx, (Date)value);
    public static final TypeHandler TIME_HANDLER = (ps, idx, value) -> ps.setTime(idx, (Time)value);
    public static final TypeHandler TIMESTAMP_HANDLER = (ps, idx, value) -> ps.setTimestamp(idx, (Timestamp)value);
    public static final TypeHandler BOOLEAN_HANDLER = (ps, idx, value) -> ps.setBoolean(idx, (Boolean)value);
    static final Map<Class<?>, TypeHandler> typeHandlerMap = Map.ofEntries(Map.entry(String.class, STRING_HANDLER), Map.entry(BigDecimal.class, BIGDECIMAL_HANDLER), Map.entry(Short.class, SHORT_HANDLER), Map.entry(Integer.class, INTEGER_HANDLER), Map.entry(Long.class, LONG_HANDLER), Map.entry(Float.class, FLOAT_HANDLER), Map.entry(Double.class, DOUBLE_HANDLER), Map.entry(Date.class, DATE_HANDLER), Map.entry(Time.class, TIME_HANDLER), Map.entry(Timestamp.class, TIMESTAMP_HANDLER), Map.entry(Boolean.class, BOOLEAN_HANDLER));

    @Generated
    private TypeHandlers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

