/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import java.nio.charset.StandardCharsets;
import java.util.function.IntSupplier;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.VarBinaryVector;

public class BinaryVectorAccessor
extends QueryJDBCAccessor {
    private final ByteArrayGetter getter;

    public BinaryVectorAccessor(FixedSizeBinaryVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        this(arg_0 -> ((FixedSizeBinaryVector)vector).get(arg_0), currentRowSupplier, wasNullConsumer);
    }

    public BinaryVectorAccessor(VarBinaryVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        this(arg_0 -> ((VarBinaryVector)vector).get(arg_0), currentRowSupplier, wasNullConsumer);
    }

    public BinaryVectorAccessor(LargeVarBinaryVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        this(arg_0 -> ((LargeVarBinaryVector)vector).get(arg_0), currentRowSupplier, wasNullConsumer);
    }

    private BinaryVectorAccessor(ByteArrayGetter getter, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        super(currentRowSupplier, wasNullConsumer);
        this.getter = getter;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = this.getter.get(this.getCurrentRow());
        this.wasNull = bytes == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return bytes;
    }

    @Override
    public Object getObject() {
        return this.getBytes();
    }

    @Override
    public Class<?> getObjectClass() {
        return byte[].class;
    }

    @Override
    public String getString() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static interface ByteArrayGetter {
        public byte[] get(int var1);
    }
}

