/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import java.math.BigDecimal;
import java.util.function.IntSupplier;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.holders.NullableBitHolder;

public class BooleanVectorAccessor
extends QueryJDBCAccessor {
    private final BitVector vector;
    private final NullableBitHolder holder;

    public BooleanVectorAccessor(BitVector vector, IntSupplier getCurrentRow, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        super(getCurrentRow, wasNullConsumer);
        this.vector = vector;
        this.holder = new NullableBitHolder();
    }

    @Override
    public Class<?> getObjectClass() {
        return Boolean.class;
    }

    @Override
    public Object getObject() {
        boolean value = this.getBoolean();
        return this.wasNull ? null : Boolean.valueOf(value);
    }

    @Override
    public byte getByte() {
        return (byte)this.getLong();
    }

    @Override
    public short getShort() {
        return (short)this.getLong();
    }

    @Override
    public int getInt() {
        return (int)this.getLong();
    }

    @Override
    public float getFloat() {
        return this.getLong();
    }

    @Override
    public double getDouble() {
        return this.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() {
        long value = this.getLong();
        return this.wasNull ? null : BigDecimal.valueOf(value);
    }

    @Override
    public String getString() {
        boolean value = this.getBoolean();
        return this.wasNull ? null : Boolean.toString(value);
    }

    @Override
    public long getLong() {
        this.vector.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return 0L;
        }
        return this.holder.value;
    }

    @Override
    public boolean getBoolean() {
        return this.getLong() != 0L;
    }
}

