/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import java.math.BigDecimal;
import java.util.function.IntSupplier;
import org.apache.arrow.vector.DecimalVector;

public class DecimalVectorAccessor
extends QueryJDBCAccessor {
    private final DecimalVector vector;

    public DecimalVectorAccessor(DecimalVector vector, IntSupplier getCurrentRow, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        super(getCurrentRow, wasNullConsumer);
        this.vector = vector;
    }

    @Override
    public Class<?> getObjectClass() {
        return BigDecimal.class;
    }

    @Override
    public BigDecimal getBigDecimal() {
        BigDecimal value = this.vector.getObject(this.getCurrentRow());
        this.wasNull = value == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return value;
    }

    @Override
    public Object getObject() {
        return this.getBigDecimal();
    }

    @Override
    public String getString() {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public int getInt() {
        BigDecimal value = this.getBigDecimal();
        return this.wasNull ? 0 : value.intValue();
    }
}

