/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.core.accessor.impl.TimeVectorGetter;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.DateTimeUtils;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.ValueVector;

public class TimeVectorAccessor
extends QueryJDBCAccessor {
    private final TimeVectorGetter.Getter getter;
    private final TimeUnit timeUnit;
    private final TimeVectorGetter.Holder holder = new TimeVectorGetter.Holder();
    private static final String INVALID_VECTOR_ERROR_RESPONSE = "Unsupported Timestamp vector type provided";

    public TimeVectorAccessor(TimeNanoVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = TimeVectorGetter.createGetter(vector);
        this.timeUnit = TimeVectorAccessor.getTimeUnitForVector((ValueVector)vector);
    }

    public TimeVectorAccessor(TimeMicroVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = TimeVectorGetter.createGetter(vector);
        this.timeUnit = TimeVectorAccessor.getTimeUnitForVector((ValueVector)vector);
    }

    public TimeVectorAccessor(TimeMilliVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = TimeVectorGetter.createGetter(vector);
        this.timeUnit = TimeVectorAccessor.getTimeUnitForVector((ValueVector)vector);
    }

    public TimeVectorAccessor(TimeSecVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = TimeVectorGetter.createGetter(vector);
        this.timeUnit = TimeVectorAccessor.getTimeUnitForVector((ValueVector)vector);
    }

    @Override
    public Class<?> getObjectClass() {
        return Time.class;
    }

    @Override
    public Object getObject() {
        return this.getTime(null);
    }

    @Override
    public Time getTime(Calendar calendar) {
        this.fillHolder();
        if (this.wasNull) {
            return null;
        }
        long value = this.holder.value;
        long milliseconds = this.timeUnit.toMillis(value);
        return DateTimeUtils.getUTCTimeFromMilliseconds(milliseconds);
    }

    private void fillHolder() {
        this.getter.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) {
        Time time = this.getTime(calendar);
        if (time == null) {
            return null;
        }
        return new Timestamp(time.getTime());
    }

    @Override
    public String getString() {
        Time time = this.getTime(null);
        if (time == null) {
            return null;
        }
        return time.toLocalTime().format(DateTimeFormatter.ISO_TIME);
    }

    protected static TimeUnit getTimeUnitForVector(ValueVector vector) throws SQLException {
        if (vector instanceof TimeNanoVector) {
            return TimeUnit.NANOSECONDS;
        }
        if (vector instanceof TimeMicroVector) {
            return TimeUnit.MICROSECONDS;
        }
        if (vector instanceof TimeMilliVector) {
            return TimeUnit.MILLISECONDS;
        }
        if (vector instanceof TimeSecVector) {
            return TimeUnit.SECONDS;
        }
        UnsupportedOperationException rootCauseException = new UnsupportedOperationException(INVALID_VECTOR_ERROR_RESPONSE);
        throw new DataCloudJDBCException(INVALID_VECTOR_ERROR_RESPONSE, "22007", rootCauseException);
    }
}

