/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;

public final class FormCommand {
    private static final String ACCEPT_HEADER_NAME = "Accept";
    public static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String URL_ENCODED_CONTENT = "application/x-www-form-urlencoded";
    private static ObjectMapper mapper = new ObjectMapper();
    @NonNull
    private final URI url;
    @NonNull
    private final URI suffix;
    private final Map<String, String> headers;
    private final Map<String, String> bodyEntries;
    private final Map<String, String> queryParameters;

    public static <T> T get(@NonNull OkHttpClient client, @NonNull FormCommand command, Class<T> type) throws SQLException {
        if (client == null) {
            throw new IllegalArgumentException("client is marked non-null but is null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        String url = FormCommand.getUrl(command);
        Headers headers = FormCommand.asHeaders(command);
        Request request = new Request.Builder().url(url).headers(headers).get().build();
        return FormCommand.executeRequest(client, request, type);
    }

    public static <T> T post(@NonNull OkHttpClient client, @NonNull FormCommand command, Class<T> type) throws SQLException {
        if (client == null) {
            throw new IllegalArgumentException("client is marked non-null but is null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        String url = FormCommand.getUrl(command);
        Headers headers = FormCommand.asHeaders(command);
        FormBody payload = FormCommand.asFormBody(command);
        Request request = new Request.Builder().url(url).headers(headers).post((RequestBody)payload).build();
        return FormCommand.executeRequest(client, request, type);
    }

    private static String getUrl(FormCommand command) {
        HttpUrl.Builder builder = Objects.requireNonNull(HttpUrl.parse((String)command.getUrl().toString())).newBuilder();
        builder.addPathSegments(command.suffix.toString());
        command.queryParameters.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)builder).addEncodedQueryParameter(arg_0, arg_1));
        return builder.build().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T executeRequest(@NonNull OkHttpClient client, Request request, Class<T> type) throws SQLException {
        if (client == null) {
            throw new IllegalArgumentException("client is marked non-null but is null");
        }
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody body = response.body();
            if (body == null) throw new IOException("Response Body was null " + response);
            if (StringUtils.isEmpty((CharSequence)body.toString())) {
                throw new IOException("Response Body was null " + response);
            }
            String json = body.string();
            Object object = mapper.readValue(json, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new DataCloudJDBCException(e);
        }
    }

    private static FormBody asFormBody(FormCommand command) {
        FormBody.Builder body = new FormBody.Builder();
        command.getBodyEntries().forEach((arg_0, arg_1) -> ((FormBody.Builder)body).add(arg_0, arg_1));
        return body.build();
    }

    private static Headers asHeaders(FormCommand command) {
        HashMap<String, String> headers = new HashMap<String, String>(command.getHeaders());
        headers.putIfAbsent(ACCEPT_HEADER_NAME, "application/json");
        headers.putIfAbsent(CONTENT_TYPE_HEADER_NAME, URL_ENCODED_CONTENT);
        return Headers.of(headers);
    }

    @Generated
    FormCommand(@NonNull URI url, @NonNull URI suffix, Map<String, String> headers, Map<String, String> bodyEntries, Map<String, String> queryParameters) {
        if (url == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("suffix is marked non-null but is null");
        }
        this.url = url;
        this.suffix = suffix;
        this.headers = headers;
        this.bodyEntries = bodyEntries;
        this.queryParameters = queryParameters;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public URI getUrl() {
        return this.url;
    }

    @NonNull
    @Generated
    public URI getSuffix() {
        return this.suffix;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public Map<String, String> getBodyEntries() {
        return this.bodyEntries;
    }

    @Generated
    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormCommand)) {
            return false;
        }
        FormCommand other = (FormCommand)o;
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        URI this$suffix = this.getSuffix();
        URI other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !((Object)this$suffix).equals(other$suffix)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, String> this$bodyEntries = this.getBodyEntries();
        Map<String, String> other$bodyEntries = other.getBodyEntries();
        if (this$bodyEntries == null ? other$bodyEntries != null : !((Object)this$bodyEntries).equals(other$bodyEntries)) {
            return false;
        }
        Map<String, String> this$queryParameters = this.getQueryParameters();
        Map<String, String> other$queryParameters = other.getQueryParameters();
        return !(this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        URI $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : ((Object)$suffix).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, String> $bodyEntries = this.getBodyEntries();
        result = result * 59 + ($bodyEntries == null ? 43 : ((Object)$bodyEntries).hashCode());
        Map<String, String> $queryParameters = this.getQueryParameters();
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FormCommand(url=" + this.getUrl() + ", suffix=" + this.getSuffix() + ", headers=" + this.getHeaders() + ", bodyEntries=" + this.getBodyEntries() + ", queryParameters=" + this.getQueryParameters() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private URI url;
        @Generated
        private URI suffix;
        @Generated
        private ArrayList<String> headers$key;
        @Generated
        private ArrayList<String> headers$value;
        @Generated
        private ArrayList<String> bodyEntries$key;
        @Generated
        private ArrayList<String> bodyEntries$value;
        @Generated
        private ArrayList<String> queryParameters$key;
        @Generated
        private ArrayList<String> queryParameters$value;

        @Generated
        Builder() {
        }

        @Generated
        public Builder url(@NonNull URI url) {
            if (url == null) {
                throw new IllegalArgumentException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        @Generated
        public Builder suffix(@NonNull URI suffix) {
            if (suffix == null) {
                throw new IllegalArgumentException("suffix is marked non-null but is null");
            }
            this.suffix = suffix;
            return this;
        }

        @Generated
        public Builder header(String headerKey, String headerValue) {
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            this.headers$key.add(headerKey);
            this.headers$value.add(headerValue);
            return this;
        }

        @Generated
        public Builder headers(Map<? extends String, ? extends String> headers) {
            if (headers == null) {
                throw new IllegalArgumentException("headers cannot be null");
            }
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : headers.entrySet()) {
                this.headers$key.add($lombokEntry.getKey());
                this.headers$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder clearHeaders() {
            if (this.headers$key != null) {
                this.headers$key.clear();
                this.headers$value.clear();
            }
            return this;
        }

        @Generated
        public Builder bodyEntry(String bodyEntryKey, String bodyEntryValue) {
            if (this.bodyEntries$key == null) {
                this.bodyEntries$key = new ArrayList();
                this.bodyEntries$value = new ArrayList();
            }
            this.bodyEntries$key.add(bodyEntryKey);
            this.bodyEntries$value.add(bodyEntryValue);
            return this;
        }

        @Generated
        public Builder bodyEntries(Map<? extends String, ? extends String> bodyEntries) {
            if (bodyEntries == null) {
                throw new IllegalArgumentException("bodyEntries cannot be null");
            }
            if (this.bodyEntries$key == null) {
                this.bodyEntries$key = new ArrayList();
                this.bodyEntries$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : bodyEntries.entrySet()) {
                this.bodyEntries$key.add($lombokEntry.getKey());
                this.bodyEntries$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder clearBodyEntries() {
            if (this.bodyEntries$key != null) {
                this.bodyEntries$key.clear();
                this.bodyEntries$value.clear();
            }
            return this;
        }

        @Generated
        public Builder queryParameter(String queryParameterKey, String queryParameterValue) {
            if (this.queryParameters$key == null) {
                this.queryParameters$key = new ArrayList();
                this.queryParameters$value = new ArrayList();
            }
            this.queryParameters$key.add(queryParameterKey);
            this.queryParameters$value.add(queryParameterValue);
            return this;
        }

        @Generated
        public Builder queryParameters(Map<? extends String, ? extends String> queryParameters) {
            if (queryParameters == null) {
                throw new IllegalArgumentException("queryParameters cannot be null");
            }
            if (this.queryParameters$key == null) {
                this.queryParameters$key = new ArrayList();
                this.queryParameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryParameters.entrySet()) {
                this.queryParameters$key.add($lombokEntry.getKey());
                this.queryParameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder clearQueryParameters() {
            if (this.queryParameters$key != null) {
                this.queryParameters$key.clear();
                this.queryParameters$value.clear();
            }
            return this;
        }

        @Generated
        public FormCommand build() {
            Map<String, String> queryParameters;
            Map<String, String> bodyEntries;
            Map<Object, Object> headers;
            switch (this.headers$key == null ? 0 : this.headers$key.size()) {
                case 0: {
                    headers = Collections.emptyMap();
                    break;
                }
                case 1: {
                    headers = Collections.singletonMap(this.headers$key.get(0), this.headers$value.get(0));
                    break;
                }
                default: {
                    headers = new LinkedHashMap(this.headers$key.size() < 0x40000000 ? 1 + this.headers$key.size() + (this.headers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.headers$key.size(); ++$i) {
                        headers.put(this.headers$key.get($i), this.headers$value.get($i));
                    }
                    headers = Collections.unmodifiableMap(headers);
                }
            }
            switch (this.bodyEntries$key == null ? 0 : this.bodyEntries$key.size()) {
                case 0: {
                    bodyEntries = Collections.emptyMap();
                    break;
                }
                case 1: {
                    bodyEntries = Collections.singletonMap(this.bodyEntries$key.get(0), this.bodyEntries$value.get(0));
                    break;
                }
                default: {
                    bodyEntries = new LinkedHashMap(this.bodyEntries$key.size() < 0x40000000 ? 1 + this.bodyEntries$key.size() + (this.bodyEntries$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.bodyEntries$key.size(); ++$i) {
                        bodyEntries.put(this.bodyEntries$key.get($i), this.bodyEntries$value.get($i));
                    }
                    bodyEntries = Collections.unmodifiableMap(bodyEntries);
                }
            }
            switch (this.queryParameters$key == null ? 0 : this.queryParameters$key.size()) {
                case 0: {
                    queryParameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    queryParameters = Collections.singletonMap(this.queryParameters$key.get(0), this.queryParameters$value.get(0));
                    break;
                }
                default: {
                    queryParameters = new LinkedHashMap(this.queryParameters$key.size() < 0x40000000 ? 1 + this.queryParameters$key.size() + (this.queryParameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.queryParameters$key.size(); ++$i) {
                        queryParameters.put(this.queryParameters$key.get($i), this.queryParameters$value.get($i));
                    }
                    queryParameters = Collections.unmodifiableMap(queryParameters);
                }
            }
            return new FormCommand(this.url, this.suffix, headers, bodyEntries, queryParameters);
        }

        @Generated
        public String toString() {
            return "FormCommand.Builder(url=" + this.url + ", suffix=" + this.suffix + ", headers$key=" + this.headers$key + ", headers$value=" + this.headers$value + ", bodyEntries$key=" + this.bodyEntries$key + ", bodyEntries$value=" + this.bodyEntries$value + ", queryParameters$key=" + this.queryParameters$key + ", queryParameters$value=" + this.queryParameters$value + ")";
        }
    }
}

