/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.http;

import com.salesforce.datacloud.jdbc.util.MetadataCacheUtil;
import java.io.IOException;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCacheInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataCacheInterceptor.class);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        String responseString = MetadataCacheUtil.getMetadata(request.url().toString());
        if (responseString != null) {
            log.trace("Getting the metadata response from local cache");
            response = new Response.Builder().code(200).request(request).protocol(Protocol.HTTP_1_1).message("OK").addHeader("from-local-cache", "true").body(ResponseBody.create((String)responseString, (MediaType)MediaType.parse((String)"application/json"))).build();
        } else {
            log.trace("Cache miss for metadata response. Getting from server");
            response = chain.proceed(request);
        }
        return response;
    }
}

