/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.interceptor;

import com.salesforce.datacloud.jdbc.auth.DataCloudToken;
import com.salesforce.datacloud.jdbc.auth.TokenProcessor;
import com.salesforce.datacloud.jdbc.interceptor.HeaderMutatingClientInterceptor;
import io.grpc.Metadata;
import java.sql.SQLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHeaderInterceptor
implements HeaderMutatingClientInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthorizationHeaderInterceptor.class);
    private static final String AUTH = "Authorization";
    private static final String AUD = "audience";
    private static final Metadata.Key<String> AUTH_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> AUD_KEY = Metadata.Key.of((String)"audience", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final TokenSupplier tokenSupplier;
    private final String name;

    public static AuthorizationHeaderInterceptor of(TokenProcessor tokenProcessor) {
        TokenProcessorSupplier supplier = new TokenProcessorSupplier(tokenProcessor);
        return new AuthorizationHeaderInterceptor(supplier, "oauth");
    }

    public static AuthorizationHeaderInterceptor of(TokenSupplier supplier) {
        return new AuthorizationHeaderInterceptor(supplier, "custom");
    }

    @Override
    public void mutate(Metadata headers) {
        String token = this.tokenSupplier.getToken();
        headers.put(AUTH_KEY, (Object)token);
        String audience = this.tokenSupplier.getAudience();
        if (audience != null) {
            headers.put(AUD_KEY, (Object)audience);
        }
    }

    @Generated
    public String toString() {
        return "AuthorizationHeaderInterceptor(name=" + this.name + ")";
    }

    @Generated
    private AuthorizationHeaderInterceptor(TokenSupplier tokenSupplier, String name) {
        this.tokenSupplier = tokenSupplier;
        this.name = name;
    }

    static class TokenProcessorSupplier
    implements TokenSupplier {
        private final TokenProcessor tokenProcessor;

        @Override
        public String getToken() {
            DataCloudToken token = this.tokenProcessor.getDataCloudToken();
            return token.getAccessToken();
        }

        @Override
        public String getAudience() {
            DataCloudToken token = this.tokenProcessor.getDataCloudToken();
            return token.getTenantId();
        }

        @Generated
        public TokenProcessorSupplier(TokenProcessor tokenProcessor) {
            this.tokenProcessor = tokenProcessor;
        }
    }

    public static interface TokenSupplier {
        public String getToken() throws SQLException;

        default public String getAudience() {
            return null;
        }
    }
}

