/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.interceptor;

import com.salesforce.datacloud.jdbc.interceptor.HeaderMutatingClientInterceptor;
import com.salesforce.datacloud.jdbc.internal.Tracer;
import io.grpc.Metadata;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingHeadersInterceptor
implements HeaderMutatingClientInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingHeadersInterceptor.class);
    private static final String TRACE_ID = "x-b3-traceid";
    private static final String SPAN_ID = "x-b3-spanid";
    private static final Metadata.Key<String> TRACE_ID_KEY = Metadata.Key.of((String)"x-b3-traceid", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SPAN_ID_KEY = Metadata.Key.of((String)"x-b3-spanid", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final Supplier<String> getTraceId;
    private final Supplier<String> getSpanId;

    public static TracingHeadersInterceptor of() {
        Tracer tracer = Tracer.get();
        String traceId = tracer.nextId();
        log.info("new tracing interceptor created. traceId={}", (Object)traceId);
        return TracingHeadersInterceptor.builder().getTraceId(() -> traceId).getSpanId(tracer::nextSpanId).build();
    }

    @Override
    public void mutate(Metadata headers) {
        headers.put(TRACE_ID_KEY, (Object)this.getTraceId.get());
        headers.put(SPAN_ID_KEY, (Object)this.getSpanId.get());
    }

    @Generated
    TracingHeadersInterceptor(Supplier<String> getTraceId, Supplier<String> getSpanId) {
        this.getTraceId = getTraceId;
        this.getSpanId = getSpanId;
    }

    @Generated
    private static TracingHeadersInterceptorBuilder builder() {
        return new TracingHeadersInterceptorBuilder();
    }

    @Generated
    public String toString() {
        return "TracingHeadersInterceptor(getTraceId=" + this.getTraceId + ", getSpanId=" + this.getSpanId + ")";
    }

    @Generated
    private static class TracingHeadersInterceptorBuilder {
        @Generated
        private Supplier<String> getTraceId;
        @Generated
        private Supplier<String> getSpanId;

        @Generated
        TracingHeadersInterceptorBuilder() {
        }

        @Generated
        private TracingHeadersInterceptorBuilder getTraceId(Supplier<String> getTraceId) {
            this.getTraceId = getTraceId;
            return this;
        }

        @Generated
        private TracingHeadersInterceptorBuilder getSpanId(Supplier<String> getSpanId) {
            this.getSpanId = getSpanId;
            return this;
        }

        @Generated
        private TracingHeadersInterceptor build() {
            return new TracingHeadersInterceptor(this.getTraceId, this.getSpanId);
        }

        @Generated
        public String toString() {
            return "TracingHeadersInterceptor.TracingHeadersInterceptorBuilder(getTraceId=" + this.getTraceId + ", getSpanId=" + this.getSpanId + ")";
        }
    }
}

