/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.interceptor;

import com.salesforce.datacloud.jdbc.config.DriverVersion;
import com.salesforce.datacloud.jdbc.interceptor.HeaderMutatingClientInterceptor;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import io.grpc.Metadata;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentHeaderInterceptor
implements HeaderMutatingClientInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserAgentHeaderInterceptor.class);
    private final String userAgent;
    private static final String USER_AGENT = "User-Agent";
    private static final Metadata.Key<String> USER_AGENT_KEY = Metadata.Key.of((String)"User-Agent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public static UserAgentHeaderInterceptor of(Properties properties) {
        Optional<String> provided = PropertiesExtensions.optional(properties, USER_AGENT);
        String userAgent = UserAgentHeaderInterceptor.getCombinedUserAgent(provided.orElse(null));
        return new UserAgentHeaderInterceptor(userAgent);
    }

    @Override
    public void mutate(Metadata headers) {
        headers.put(USER_AGENT_KEY, (Object)this.userAgent);
    }

    private static String getCombinedUserAgent(String clientProvidedUserAgent) {
        String driverInfo = DriverVersion.formatDriverInfo();
        if (clientProvidedUserAgent == null || clientProvidedUserAgent.isEmpty()) {
            return driverInfo;
        }
        if (clientProvidedUserAgent.equals(driverInfo)) {
            return driverInfo;
        }
        return String.format("%s %s", clientProvidedUserAgent, driverInfo);
    }

    @Generated
    public String toString() {
        return "UserAgentHeaderInterceptor(userAgent=" + this.userAgent + ")";
    }

    @Generated
    private UserAgentHeaderInterceptor(String userAgent) {
        this.userAgent = userAgent;
    }
}

