/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.internal;

import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public final class EncodingUtils {
    static final int BYTE_BASE16 = 2;
    private static final String ALPHABET = "0123456789abcdef";
    private static final char[] ENCODING = EncodingUtils.buildEncodingArray();
    private static final boolean[] VALID_HEX = EncodingUtils.buildValidHexArray();

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = ALPHABET.charAt(i >>> 4);
            encoding[i | 0x100] = ALPHABET.charAt(i & 0xF);
        }
        return encoding;
    }

    private static boolean[] buildValidHexArray() {
        boolean[] validHex = new boolean[65535];
        for (int i = 0; i < 65535; ++i) {
            validHex[i] = 48 <= i && i <= 57 || 97 <= i && i <= 102;
        }
        return validHex;
    }

    public static void longToBase16String(long value, char[] dest, int destOffset) {
        EncodingUtils.byteToBase16((byte)(value >> 56 & 0xFFL), dest, destOffset);
        EncodingUtils.byteToBase16((byte)(value >> 48 & 0xFFL), dest, destOffset + 2);
        EncodingUtils.byteToBase16((byte)(value >> 40 & 0xFFL), dest, destOffset + 4);
        EncodingUtils.byteToBase16((byte)(value >> 32 & 0xFFL), dest, destOffset + 6);
        EncodingUtils.byteToBase16((byte)(value >> 24 & 0xFFL), dest, destOffset + 8);
        EncodingUtils.byteToBase16((byte)(value >> 16 & 0xFFL), dest, destOffset + 10);
        EncodingUtils.byteToBase16((byte)(value >> 8 & 0xFFL), dest, destOffset + 12);
        EncodingUtils.byteToBase16((byte)(value & 0xFFL), dest, destOffset + 14);
    }

    public static void byteToBase16(byte value, char[] dest, int destOffset) {
        int b = value & 0xFF;
        dest[destOffset] = ENCODING[b];
        dest[destOffset + 1] = ENCODING[b | 0x100];
    }

    public static boolean isValidBase16String(CharSequence value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char b = value.charAt(i);
            if (EncodingUtils.isValidBase16Character(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidBase16Character(char b) {
        return VALID_HEX[b];
    }

    @Generated
    private EncodingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

