/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.salesforce.datacloud.jdbc.util.VectorValueSetter;
import org.apache.arrow.vector.ValueVector;

abstract class BaseVectorSetter<T extends ValueVector, V>
implements VectorValueSetter<T> {
    private final Class<V> valueType;

    BaseVectorSetter(Class<V> valueType) {
        this.valueType = valueType;
    }

    @Override
    public void setValue(T vector, Object value) {
        if (value == null) {
            this.setNullValue(vector);
        } else if (this.valueType.isInstance(value)) {
            this.setValueInternal(vector, this.valueType.cast(value));
        } else {
            throw new IllegalArgumentException("Value for " + vector.getClass().getSimpleName() + " must be of type " + this.valueType.getSimpleName());
        }
    }

    protected abstract void setNullValue(T var1);

    protected abstract void setValueInternal(T var1, V var2);
}

