/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumingPeekingIterator<T>
implements Iterator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsumingPeekingIterator.class);
    private final Iterator<T> iterator;
    private final Predicate<T> isNotEmpty;
    private final AtomicReference<T> consumable = new AtomicReference();

    public static <T> ConsumingPeekingIterator<T> of(Stream<T> stream, Predicate<T> isNotEmpty) {
        return new ConsumingPeekingIterator(stream.filter(isNotEmpty).iterator(), isNotEmpty);
    }

    private boolean consumableHasMore() {
        T head = this.consumable.get();
        return head != null && this.isNotEmpty.test(this.consumable.get());
    }

    @Override
    public boolean hasNext() {
        return this.consumableHasMore() || this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.consumableHasMore()) {
            return this.consumable.get();
        }
        boolean iteratorHasMore = this.iterator.hasNext();
        if (iteratorHasMore) {
            this.consumable.set(this.iterator.next());
            return this.consumable.get();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Generated
    private ConsumingPeekingIterator(Iterator<T> iterator, Predicate<T> isNotEmpty) {
        this.iterator = iterator;
        this.isNotEmpty = isNotEmpty;
    }
}

