/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.salesforce.datacloud.jdbc.util.BigIntVectorSetter;
import com.salesforce.datacloud.jdbc.util.BitVectorSetter;
import com.salesforce.datacloud.jdbc.util.DateDayVectorSetter;
import com.salesforce.datacloud.jdbc.util.DecimalVectorSetter;
import com.salesforce.datacloud.jdbc.util.Float4VectorSetter;
import com.salesforce.datacloud.jdbc.util.Float8VectorSetter;
import com.salesforce.datacloud.jdbc.util.IntVectorSetter;
import com.salesforce.datacloud.jdbc.util.SmallIntVectorSetter;
import com.salesforce.datacloud.jdbc.util.TimeMicroVectorSetter;
import com.salesforce.datacloud.jdbc.util.TimeStampMicroTZVectorSetter;
import com.salesforce.datacloud.jdbc.util.TinyIntVectorSetter;
import com.salesforce.datacloud.jdbc.util.VarCharVectorSetter;
import com.salesforce.datacloud.jdbc.util.VectorValueSetter;
import java.util.Calendar;
import java.util.Map;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;

class VectorValueSetterFactory {
    private final Map<Class<? extends ValueVector>, VectorValueSetter<?>> setterMap;

    VectorValueSetterFactory(Calendar calendar) {
        this.setterMap = Map.ofEntries(Map.entry(VarCharVector.class, new VarCharVectorSetter()), Map.entry(Float4Vector.class, new Float4VectorSetter()), Map.entry(Float8Vector.class, new Float8VectorSetter()), Map.entry(IntVector.class, new IntVectorSetter()), Map.entry(SmallIntVector.class, new SmallIntVectorSetter()), Map.entry(BigIntVector.class, new BigIntVectorSetter()), Map.entry(BitVector.class, new BitVectorSetter()), Map.entry(DecimalVector.class, new DecimalVectorSetter()), Map.entry(DateDayVector.class, new DateDayVectorSetter()), Map.entry(TimeMicroVector.class, new TimeMicroVectorSetter(calendar)), Map.entry(TimeStampMicroTZVector.class, new TimeStampMicroTZVectorSetter(calendar)), Map.entry(TinyIntVector.class, new TinyIntVectorSetter()));
    }

    <T extends ValueVector> VectorValueSetter<T> getSetter(Class<T> vectorClass) {
        return this.setterMap.get(vectorClass);
    }
}

