/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc;

import com.salesforce.datacloud.jdbc.config.DriverVersion;
import com.salesforce.datacloud.jdbc.core.DataCloudConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudJDBCDriver
implements Driver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudJDBCDriver.class);
    private static Driver registeredDriver;

    private static void register() throws SQLException {
        if (DataCloudJDBCDriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        registeredDriver = new DataCloudJDBCDriver();
        DriverManager.registerDriver(registeredDriver);
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException("Error occurred while registering JDBC driver. URL is null.");
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        return DataCloudConnection.of(url, info);
    }

    @Override
    public boolean acceptsURL(String url) {
        return DataCloudConnection.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return DriverVersion.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return DriverVersion.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return null;
    }

    static {
        try {
            DataCloudJDBCDriver.register();
            log.info("DataCloud JDBC driver registered");
        }
        catch (SQLException e) {
            log.error("Error occurred while registering DataCloud JDBC driver. {}", (Object)e.getMessage());
            throw new ExceptionInInitializerError(e);
        }
    }
}

