/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import java.sql.SQLException;
import lombok.Generated;

enum Audience {
    DEV("login.test1.pc-rnd.salesforce.com"),
    PROD("login.salesforce.com");

    public final String url;
    private static final String PROD_SUFFIX = ".salesforce.com";
    private static final String TEST_SUFFIX = ".test1.pc-rnd.salesforce.com";

    private Audience(String audience) {
        this.url = audience;
    }

    public static Audience of(String url) throws SQLException {
        if (url.contains(TEST_SUFFIX)) {
            return DEV;
        }
        if (url.endsWith(PROD_SUFFIX)) {
            return PROD;
        }
        String errorMessage = "The specified url: '" + url + "' didn't match any known environments";
        IllegalArgumentException rootCauseException = new IllegalArgumentException(errorMessage);
        throw new DataCloudJDBCException(errorMessage, "28000", rootCauseException);
    }

    @Generated
    public String getUrl() {
        return this.url;
    }
}

