/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.google.common.collect.ImmutableSet;
import com.salesforce.datacloud.jdbc.auth.PasswordAuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.PrivateKeyAuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.RefreshTokenAuthenticationSettings;
import com.salesforce.datacloud.jdbc.config.DriverVersion;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public abstract class AuthenticationSettings {
    private final Properties relevantProperties;
    private final String loginUrl;
    private final String clientId;
    private final String clientSecret;
    private final String dataspace;
    private final String userAgent;
    private final int maxRetries;

    public static AuthenticationSettings of(@NonNull Properties properties) throws SQLException {
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        AuthenticationSettings.checkNotEmpty(properties);
        AuthenticationSettings.checkHasAllRequired(properties);
        if (AuthenticationSettings.hasPrivateKey(properties)) {
            return new PrivateKeyAuthenticationSettings(properties);
        }
        if (AuthenticationSettings.hasPassword(properties)) {
            return new PasswordAuthenticationSettings(properties);
        }
        if (AuthenticationSettings.hasRefreshToken(properties)) {
            return new RefreshTokenAuthenticationSettings(properties);
        }
        throw new DataCloudJDBCException("Properties did not contain valid settings for known authentication strategies: password, privateKey, or refreshToken with coreToken", "28000");
    }

    public static boolean hasAll(Properties properties, Set<String> keys) {
        return keys.stream().allMatch(k -> PropertiesExtensions.optional(properties, k).isPresent());
    }

    public static boolean hasAny(Properties properties) {
        return AuthenticationSettings.hasPrivateKey(properties) || AuthenticationSettings.hasPassword(properties) || AuthenticationSettings.hasRefreshToken(properties);
    }

    private static boolean hasPrivateKey(Properties properties) {
        return AuthenticationSettings.hasAll(properties, Keys.PRIVATE_KEY_KEYS);
    }

    private static boolean hasPassword(Properties properties) {
        return AuthenticationSettings.hasAll(properties, Keys.PASSWORD_KEYS);
    }

    private static boolean hasRefreshToken(Properties properties) {
        return AuthenticationSettings.hasAll(properties, Keys.REFRESH_TOKEN_KEYS);
    }

    private static void checkNotEmpty(@NonNull Properties properties) throws SQLException {
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        if (properties.isEmpty()) {
            throw new DataCloudJDBCException("Properties cannot be empty when creating AuthenticationSettings.", "28000", new IllegalArgumentException("Properties cannot be empty when creating AuthenticationSettings."));
        }
    }

    private static void checkHasAllRequired(Properties properties) throws SQLException {
        if (AuthenticationSettings.hasAll(properties, Keys.REQUIRED_KEYS)) {
            return;
        }
        String missing = Keys.REQUIRED_KEYS.stream().filter(k -> !PropertiesExtensions.optional(properties, k).isPresent()).collect(Collectors.joining(", ", "Properties did not contain the following required settings: ", ""));
        throw new DataCloudJDBCException(missing, "28000", new IllegalArgumentException(missing));
    }

    final URI getLoginUri() throws SQLException {
        try {
            return new URI(this.loginUrl);
        }
        catch (URISyntaxException ex) {
            throw new DataCloudJDBCException(ex.getMessage(), "28000", ex);
        }
    }

    protected AuthenticationSettings(@NonNull Properties properties) throws SQLException {
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        AuthenticationSettings.checkNotEmpty(properties);
        this.relevantProperties = PropertiesExtensions.copy(properties, Keys.ALL);
        this.loginUrl = PropertiesExtensions.required(this.relevantProperties, "loginURL");
        this.clientId = PropertiesExtensions.required(this.relevantProperties, "clientId");
        this.clientSecret = PropertiesExtensions.required(this.relevantProperties, "clientSecret");
        this.dataspace = PropertiesExtensions.optional(this.relevantProperties, "dataspace").orElse(Defaults.DATASPACE);
        this.userAgent = PropertiesExtensions.optional(this.relevantProperties, "User-Agent").orElse(Defaults.USER_AGENT);
        this.maxRetries = PropertiesExtensions.optional(this.relevantProperties, "maxRetries").map(PropertiesExtensions::toIntegerOrNull).orElse(3);
    }

    @Generated
    public Properties getRelevantProperties() {
        return this.relevantProperties;
    }

    @Generated
    public String getLoginUrl() {
        return this.loginUrl;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getDataspace() {
        return this.dataspace;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public int getMaxRetries() {
        return this.maxRetries;
    }

    protected static final class Messages {
        static final String PROPERTIES_NULL = "properties is marked non-null but is null";
        static final String PROPERTIES_EMPTY = "Properties cannot be empty when creating AuthenticationSettings.";
        static final String PROPERTIES_MISSING = "Properties did not contain valid settings for known authentication strategies: password, privateKey, or refreshToken with coreToken";
        static final String PROPERTIES_REQUIRED = "Properties did not contain the following required settings: ";

        @Generated
        private Messages() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    protected static final class Defaults {
        static final int MAX_RETRIES = 3;
        static final String DATASPACE = null;
        static final String USER_AGENT = DriverVersion.formatDriverInfo();

        @Generated
        private Defaults() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    protected static final class Keys {
        static final String LOGIN_URL = "loginURL";
        static final String USER_NAME = "userName";
        static final String PASSWORD = "password";
        static final String PRIVATE_KEY = "privateKey";
        static final String CLIENT_SECRET = "clientSecret";
        static final String CLIENT_ID = "clientId";
        static final String DATASPACE = "dataspace";
        static final String MAX_RETRIES = "maxRetries";
        static final String USER_AGENT = "User-Agent";
        static final String REFRESH_TOKEN = "refreshToken";
        static final Set<String> REQUIRED_KEYS = ImmutableSet.of((Object)"loginURL", (Object)"clientId", (Object)"clientSecret");
        static final Set<String> OPTIONAL_KEYS = ImmutableSet.of((Object)"dataspace", (Object)"User-Agent", (Object)"maxRetries");
        static final Set<String> PASSWORD_KEYS = ImmutableSet.of((Object)"userName", (Object)"password");
        static final Set<String> PRIVATE_KEY_KEYS = ImmutableSet.of((Object)"userName", (Object)"privateKey");
        static final Set<String> REFRESH_TOKEN_KEYS = ImmutableSet.of((Object)"refreshToken");
        static final Set<String> ALL = Stream.of(REQUIRED_KEYS, OPTIONAL_KEYS, PASSWORD_KEYS, PRIVATE_KEY_KEYS, REFRESH_TOKEN_KEYS).flatMap(Collection::stream).collect(Collectors.toSet());

        @Generated
        private Keys() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

