/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.auth.AuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.HttpCommandPath;
import com.salesforce.datacloud.jdbc.auth.OAuthToken;
import com.salesforce.datacloud.jdbc.http.FormCommand;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

class ExchangeTokenAuthenticationStrategy {
    private static final String GRANT_TYPE = "urn:salesforce:grant-type:external:cdp";
    private static final String ACCESS_TOKEN = "urn:ietf:params:oauth:token-type:access_token";
    static final String SUBJECT_TOKEN_TYPE = "subject_token_type";
    static final String SUBJECT_TOKEN_KEY = "subject_token";
    static final String DATASPACE = "dataspace";
    private final AuthenticationSettings settings;
    private final OAuthToken token;

    static ExchangeTokenAuthenticationStrategy of(@NonNull AuthenticationSettings settings, @NonNull OAuthToken token) {
        if (settings == null) {
            throw new IllegalArgumentException("settings is marked non-null but is null");
        }
        if (token == null) {
            throw new IllegalArgumentException("token is marked non-null but is null");
        }
        return new ExchangeTokenAuthenticationStrategy(settings, token);
    }

    public FormCommand toCommand() {
        FormCommand.Builder builder = FormCommand.builder();
        builder.url(this.token.getInstanceUrl());
        builder.suffix(HttpCommandPath.EXCHANGE.getSuffix());
        builder.header("User-Agent", this.settings.getUserAgent());
        builder.bodyEntry("grant_type", GRANT_TYPE);
        builder.bodyEntry(SUBJECT_TOKEN_TYPE, ACCESS_TOKEN);
        builder.bodyEntry(SUBJECT_TOKEN_KEY, this.token.getToken());
        if (StringUtils.isNotBlank((CharSequence)this.settings.getDataspace())) {
            builder.bodyEntry(DATASPACE, this.settings.getDataspace());
        }
        return builder.build();
    }

    @Generated
    private ExchangeTokenAuthenticationStrategy(AuthenticationSettings settings, OAuthToken token) {
        this.settings = settings;
        this.token = token;
    }

    @Generated
    public AuthenticationSettings getSettings() {
        return this.settings;
    }
}

