/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.config;

import com.salesforce.datacloud.jdbc.config.ResourceReader;
import java.util.Properties;
import lombok.Generated;

final class DriverVersionInfo {
    private final int major;
    private final int minor;

    static String getVersion(Properties properties) {
        String version = properties.getProperty("version");
        if (version == null || version.isEmpty()) {
            return "0.0";
        }
        return version.replaceAll("-.*$", "");
    }

    static DriverVersionInfo of(Properties properties) {
        DriverVersionInfoBuilder builder = DriverVersionInfo.builder();
        String version = DriverVersionInfo.getVersion(properties);
        if (!version.isEmpty()) {
            String[] chunks = version.split("\\.", -1);
            builder.major(Integer.parseInt(chunks[0]));
            builder.minor(Integer.parseInt(chunks[1]));
            return builder.build();
        }
        return builder.build();
    }

    public String toString() {
        return String.format("%d.%d", this.major, this.minor);
    }

    static DriverVersionInfo of() {
        Properties properties = ResourceReader.readResourceAsProperties("/version.properties");
        return DriverVersionInfo.of(properties);
    }

    @Generated
    private static int $default$major() {
        return 0;
    }

    @Generated
    private static int $default$minor() {
        return 0;
    }

    @Generated
    DriverVersionInfo(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    @Generated
    private static DriverVersionInfoBuilder builder() {
        return new DriverVersionInfoBuilder();
    }

    @Generated
    public int getMajor() {
        return this.major;
    }

    @Generated
    public int getMinor() {
        return this.minor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DriverVersionInfo)) {
            return false;
        }
        DriverVersionInfo other = (DriverVersionInfo)o;
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        return this.getMinor() == other.getMinor();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        return result;
    }

    @Generated
    private static class DriverVersionInfoBuilder {
        @Generated
        private boolean major$set;
        @Generated
        private int major$value;
        @Generated
        private boolean minor$set;
        @Generated
        private int minor$value;

        @Generated
        DriverVersionInfoBuilder() {
        }

        @Generated
        private DriverVersionInfoBuilder major(int major) {
            this.major$value = major;
            this.major$set = true;
            return this;
        }

        @Generated
        private DriverVersionInfoBuilder minor(int minor) {
            this.minor$value = minor;
            this.minor$set = true;
            return this;
        }

        @Generated
        private DriverVersionInfo build() {
            int major$value = this.major$value;
            if (!this.major$set) {
                major$value = DriverVersionInfo.$default$major();
            }
            int minor$value = this.minor$value;
            if (!this.minor$set) {
                minor$value = DriverVersionInfo.$default$minor();
            }
            return new DriverVersionInfo(major$value, minor$value);
        }

        @Generated
        public String toString() {
            return "DriverVersionInfo.DriverVersionInfoBuilder(major$value=" + this.major$value + ", minor$value=" + this.minor$value + ")";
        }
    }
}

