/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.ThrowingFunction;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.AbstractCursor;
import org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.calcite.avatica.util.Cursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrowStreamReaderCursor
extends AbstractCursor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArrowStreamReaderCursor.class);
    private static final int INIT_ROW_NUMBER = -1;
    private final ArrowStreamReader reader;
    private final AtomicInteger currentRow = new AtomicInteger(-1);

    private void wasNullConsumer(boolean wasNull) {
        this.wasNull[0] = wasNull;
    }

    private VectorSchemaRoot getSchemaRoot() {
        return this.reader.getVectorSchemaRoot();
    }

    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory) {
        return this.getSchemaRoot().getFieldVectors().stream().map(ThrowingFunction.rethrowFunction(this::createAccessor)).collect(Collectors.toList());
    }

    private Cursor.Accessor createAccessor(FieldVector vector) throws SQLException {
        return QueryJDBCAccessorFactory.createAccessor((ValueVector)vector, this.currentRow::get, this::wasNullConsumer);
    }

    private boolean loadNextBatch() throws SQLException {
        try {
            if (this.reader.loadNextBatch()) {
                this.currentRow.set(0);
                return true;
            }
        }
        catch (IOException e) {
            throw new DataCloudJDBCException(e);
        }
        return false;
    }

    public boolean next() {
        int current = this.currentRow.incrementAndGet();
        int total = this.getSchemaRoot().getRowCount();
        try {
            return current < total || this.loadNextBatch();
        }
        catch (Exception e) {
            throw new DataCloudJDBCException("Failed to load next batch", e);
        }
    }

    protected AbstractCursor.Getter createGetter(int i) {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.reader.close();
    }

    @Generated
    public ArrowStreamReaderCursor(ArrowStreamReader reader) {
        this.reader = reader;
    }
}

