/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.google.protobuf.ByteString;
import com.salesforce.datacloud.jdbc.core.DataCloudConnection;
import com.salesforce.datacloud.jdbc.core.DataCloudStatement;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.ParameterManager;
import com.salesforce.datacloud.jdbc.core.TypeHandler;
import com.salesforce.datacloud.jdbc.core.TypeHandlers;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.ArrowUtils;
import com.salesforce.datacloud.jdbc.util.DateTimeUtils;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import com.salesforce.hyperdb.grpc.QueryParam;
import com.salesforce.hyperdb.grpc.QueryParameterArrow;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.Calendar;
import java.util.TimeZone;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudPreparedStatement
extends DataCloudStatement
implements PreparedStatement {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudPreparedStatement.class);
    private String sql;
    private final ParameterManager parameterManager;
    private final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    DataCloudPreparedStatement(DataCloudConnection connection, ParameterManager parameterManager) {
        super(connection);
        this.parameterManager = parameterManager;
    }

    DataCloudPreparedStatement(DataCloudConnection connection, String sql, ParameterManager parameterManager) {
        super(connection);
        this.sql = sql;
        this.parameterManager = parameterManager;
    }

    private <T> void setParameter(int parameterIndex, int sqlType, T value) throws SQLException {
        try {
            this.parameterManager.setParameter(parameterIndex, sqlType, value);
        }
        catch (SQLException e) {
            throw new DataCloudJDBCException(e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.sql = sql;
        return this.executeQuery();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.resultSet = this.executeQuery(sql);
        return true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        byte[] encodedRow;
        try {
            encodedRow = ArrowUtils.toArrowByteArray(this.parameterManager.getParameters(), this.calendar);
        }
        catch (IOException e) {
            throw new DataCloudJDBCException("Failed to encode parameters on prepared statement", e);
        }
        QueryParam queryParamBuilder = QueryParam.newBuilder().setParamStyle(QueryParam.ParameterStyle.QUESTION_MARK).setArrowParameters(QueryParameterArrow.newBuilder().setData(ByteString.copyFrom((byte[])encodedRow)).build()).build();
        HyperGrpcClientExecutor client = this.getQueryExecutor(queryParamBuilder);
        Duration timeout = Duration.ofSeconds(this.getQueryTimeout());
        Boolean useSync = PropertiesExtensions.optional(this.dataCloudConnection.getProperties(), "force-sync").map(Boolean::parseBoolean).orElse(false);
        this.resultSet = useSync != false ? this.executeSyncQuery(this.sql, client) : this.executeAdaptiveQuery(this.sql, client, timeout);
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, sqlType, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, 16, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, -6, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, 5, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, 4, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, -5, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, 6, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, 8, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, 3, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, 12, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter(parameterIndex, 91, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, 92, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, 93, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void clearParameters() {
        this.parameterManager.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        this.setParameter(parameterIndex, targetSqlType, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        TypeHandler handler = TypeHandlers.typeHandlerMap.get(x.getClass());
        if (handler != null) {
            try {
                handler.setParameter(this, parameterIndex, x);
            }
            catch (SQLException e) {
                throw new DataCloudJDBCException(e);
            }
        } else {
            String message = "Object type not supported for: " + x.getClass().getSimpleName() + " (value: " + x + ")";
            throw new DataCloudJDBCException(new SQLFeatureNotSupportedException(message));
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.resultSet = this.executeQuery();
        return true;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new DataCloudJDBCException("Batch execution is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Date utcDate = DateTimeUtils.getUTCDateFromDateAndCalendar(x, cal);
        this.setParameter(parameterIndex, 91, utcDate);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Time utcTime = DateTimeUtils.getUTCTimeFromTimeAndCalendar(x, cal);
        this.setParameter(parameterIndex, 92, utcTime);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Timestamp utcTimestamp = DateTimeUtils.getUTCTimestampFromTimestampAndCalendar(x, cal);
        this.setParameter(parameterIndex, 93, utcTimestamp);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new DataCloudJDBCException("Write is not supported in Data Cloud query", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        if (iFace.isInstance(this)) {
            return iFace.cast(this);
        }
        throw new DataCloudJDBCException("Cannot unwrap to " + iFace.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) {
        return iFace.isInstance(this);
    }
}

