/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.salesforce.datacloud.jdbc.core.TypeHandler;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import lombok.Generated;

final class TypeHandlers {
    public static final TypeHandler STRING_HANDLER = (ps, idx, value) -> ps.setString(idx, (String)value);
    public static final TypeHandler BIGDECIMAL_HANDLER = (ps, idx, value) -> ps.setBigDecimal(idx, (BigDecimal)value);
    public static final TypeHandler SHORT_HANDLER = (ps, idx, value) -> ps.setShort(idx, (Short)value);
    public static final TypeHandler INTEGER_HANDLER = (ps, idx, value) -> ps.setInt(idx, (Integer)value);
    public static final TypeHandler LONG_HANDLER = (ps, idx, value) -> ps.setLong(idx, (Long)value);
    public static final TypeHandler FLOAT_HANDLER = (ps, idx, value) -> ps.setFloat(idx, ((Float)value).floatValue());
    public static final TypeHandler DOUBLE_HANDLER = (ps, idx, value) -> ps.setDouble(idx, (Double)value);
    public static final TypeHandler DATE_HANDLER = (ps, idx, value) -> ps.setDate(idx, (Date)value);
    public static final TypeHandler TIME_HANDLER = (ps, idx, value) -> ps.setTime(idx, (Time)value);
    public static final TypeHandler TIMESTAMP_HANDLER = (ps, idx, value) -> ps.setTimestamp(idx, (Timestamp)value);
    public static final TypeHandler BOOLEAN_HANDLER = (ps, idx, value) -> ps.setBoolean(idx, (Boolean)value);
    static final Map<Class<?>, TypeHandler> typeHandlerMap = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Maps.immutableEntry(String.class, (Object)STRING_HANDLER), Maps.immutableEntry(BigDecimal.class, (Object)BIGDECIMAL_HANDLER), Maps.immutableEntry(Short.class, (Object)SHORT_HANDLER), Maps.immutableEntry(Integer.class, (Object)INTEGER_HANDLER), Maps.immutableEntry(Long.class, (Object)LONG_HANDLER), Maps.immutableEntry(Float.class, (Object)FLOAT_HANDLER), Maps.immutableEntry(Double.class, (Object)DOUBLE_HANDLER), Maps.immutableEntry(Date.class, (Object)DATE_HANDLER), Maps.immutableEntry(Time.class, (Object)TIME_HANDLER), Maps.immutableEntry(Timestamp.class, (Object)TIMESTAMP_HANDLER), Maps.immutableEntry(Boolean.class, (Object)BOOLEAN_HANDLER)});

    @Generated
    private TypeHandlers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

