/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.ArrowUtils;
import java.sql.Array;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class DataCloudArray
implements Array {
    private final FieldVector dataVector;
    private final long startOffset;
    private final long valuesCount;
    protected static final String NOT_SUPPORTED_IN_DATACLOUD_QUERY = "Array method is not supported in Data Cloud query";

    public DataCloudArray(FieldVector dataVector, long startOffset, long valuesCount) {
        this.dataVector = dataVector;
        this.startOffset = startOffset;
        this.valuesCount = valuesCount;
    }

    @Override
    public String getBaseTypeName() {
        ArrowType arrowType = this.dataVector.getField().getType();
        int baseType = ArrowUtils.getSQLTypeFromArrowType(arrowType);
        return JDBCType.valueOf(baseType).getName();
    }

    @Override
    public int getBaseType() {
        ArrowType arrowType = this.dataVector.getField().getType();
        return ArrowUtils.getSQLTypeFromArrowType(arrowType);
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArray(null);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            throw new DataCloudJDBCException(NOT_SUPPORTED_IN_DATACLOUD_QUERY, "0A000");
        }
        return DataCloudArray.getArrayNoBoundCheck((ValueVector)this.dataVector, this.startOffset, this.valuesCount);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(index, count, null);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            throw new DataCloudJDBCException(NOT_SUPPORTED_IN_DATACLOUD_QUERY, "0A000");
        }
        this.checkBoundaries(index, count);
        int start = LargeMemoryUtil.checkedCastToInt((long)(this.startOffset + index));
        return DataCloudArray.getArrayNoBoundCheck((ValueVector)this.dataVector, start, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new DataCloudJDBCException(NOT_SUPPORTED_IN_DATACLOUD_QUERY, "0A000");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new DataCloudJDBCException(NOT_SUPPORTED_IN_DATACLOUD_QUERY, "0A000");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new DataCloudJDBCException(NOT_SUPPORTED_IN_DATACLOUD_QUERY, "0A000");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new DataCloudJDBCException(NOT_SUPPORTED_IN_DATACLOUD_QUERY, "0A000");
    }

    @Override
    public void free() {
    }

    private static Object getArrayNoBoundCheck(ValueVector dataVector, long start, long count) {
        Object[] result = new Object[LargeMemoryUtil.checkedCastToInt((long)count)];
        int i = 0;
        while ((long)i < count) {
            result[i] = dataVector.getObject(LargeMemoryUtil.checkedCastToInt((long)(start + (long)i)));
            ++i;
        }
        return result;
    }

    private void checkBoundaries(long index, int count) {
        if (index < 0L || index + (long)count > this.startOffset + this.valuesCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

